/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.Authenticator;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.DisplayUtils;
import com.sun.identity.common.SearchResults;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public class SessionCommand
extends AuthenticatedCommand {
    private static final String ARGUMENT_HOST_NAME = "host";
    private static final String USER_ID = "UserId";
    private Session curSession;
    private SessionID curSessionID;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        Authenticator auth = Authenticator.getInstance();
        String bindUser = this.getAdminUserID();
        if (bindUser == null) {
            bindUser = this.getAdminID();
        }
        AuthContext lc = auth.sessionBasedLogin(this.getCommandManager(), bindUser, this.getAdminPassword());
        try {
            this.handleRequest(lc.getSSOToken());
            try {
                lc.logout();
            }
            catch (AuthLoginException e) {
                throw new CLIException(e, 22);
            }
        }
        catch (Exception e) {
            throw new CLIException(e, 20);
        }
    }

    private void handleRequest(SSOToken ssoToken) throws CLIException {
        IOutput ouputWriter = this.getOutputWriter();
        List sList = this.displaySessions(ssoToken);
        if (sList != null && !sList.isEmpty()) {
            Iterator i = sList.iterator();
            while (i.hasNext()) {
                this.printSessionInformation(ouputWriter, (SessionData)i.next());
            }
            if (sList.size() > 1) {
                this.promptForInvalidation(ouputWriter, sList);
            }
        } else {
            ouputWriter.printlnMessage(this.getResourceString("session-no-sessions"));
        }
    }

    private void promptForInvalidation(IOutput ouputWriter, List sessionList) throws CLIException {
        ArrayList<String> snList = new ArrayList<String>(sessionList.size());
        ouputWriter.printlnMessage(this.getResourceString("session-to-invalidate"));
        ouputWriter.printlnMessage(this.getResourceString("session-cr-to-exit"));
        try {
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(System.in));
            String si = buffReader.readLine();
            StringTokenizer st = new StringTokenizer(si, " ");
            if (st.countTokens() != 0) {
                boolean matched = true;
                while (st.hasMoreTokens() && matched) {
                    String sn = st.nextToken();
                    matched = this.sessionIndexMatched(sessionList, sn);
                    if (matched) {
                        snList.add(sn);
                        continue;
                    }
                    ouputWriter.printlnError(this.getResourceString("session-selection-not-in-list"));
                }
                if (matched) {
                    this.invalidateSessions(ouputWriter, sessionList, snList);
                }
            }
        }
        catch (IOException ioe) {
            ouputWriter.printlnError(this.getResourceString("session-io-exception-reading-input") + " " + ioe);
        }
    }

    private void destroySession(Session session, SessionData sData) throws CLIException {
        try {
            Session sess = sData.session;
            String[] params = new String[]{sData.userId};
            this.writeLog(0, Level.INFO, "ATTEMPT_SESSION_DESTROY", params);
            session.destroySession(sess);
            this.writeLog(0, Level.INFO, "SUCCEED_SESSION_DESTROY", params);
        }
        catch (SessionException se) {
            String[] params = new String[]{sData.userId, se.getMessage()};
            this.debugError("SessionCommand.destroySession", (Throwable)((Object)se));
            this.writeLog(1, Level.INFO, "FAILED_SESSION_DESTROY", params);
        }
    }

    private void invalidateSessions(IOutput ouputWriter, List sessionList, List list) throws CLIException {
        if (list != null && !list.isEmpty()) {
            Iterator iter = sessionList.iterator();
            while (iter.hasNext()) {
                SessionData sData = (SessionData)iter.next();
                String strIndex = String.valueOf(sData.index);
                if (!list.contains(strIndex)) continue;
                this.destroySession(this.curSession, sData);
            }
            ouputWriter.printlnMessage(this.getResourceString("session-destroy-session-succeeded"));
        }
    }

    private boolean sessionIndexMatched(List sessionList, String idx) {
        boolean match = false;
        try {
            int index = Integer.parseInt(idx);
            match = index >= 0 && index < sessionList.size();
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return match;
    }

    private void printSessionInformation(IOutput ouputWriter, SessionData sData) {
        if (sData.index == -1) {
            ouputWriter.printMessage(this.getResourceString("session-current-session") + " ");
        } else {
            ouputWriter.printMessage(this.getResourceString("session-index") + " " + sData.index + " ");
        }
        ouputWriter.printlnMessage(this.getResourceString("session-userId") + " " + sData.userId + " " + this.getResourceString("session-time-remain") + " " + sData.timeRemain + " " + this.getResourceString("session-max-session-time") + " " + sData.maxSessionTime + " " + this.getResourceString("session-idle-time") + " " + sData.idleTime + " " + this.getResourceString("session-max-idle-time") + " " + sData.maxIdleTime);
    }

    private List displaySessions(SSOToken ssoToken) throws CLIException {
        String origHost = this.getStringOptionValue(ARGUMENT_HOST_NAME);
        String host = this.trimTrailingSlash(origHost);
        StringTokenizer st = new StringTokenizer(host, ":");
        if (st.countTokens() != 3) {
            Object[] params = new Object[]{origHost};
            throw new CLIException(MessageFormat.format(this.getResourceString("session-invalid-host-name"), params), 23);
        }
        this.curSessionID = new SessionID(((Object)ssoToken.getTokenID()).toString());
        String filter = this.getStringOptionValue("filter");
        if (filter == null || filter.trim().length() == 0) {
            filter = "*";
        }
        try {
            this.curSession = Session.getSession(this.curSessionID);
            return this.getSessionList(host, filter);
        }
        catch (SessionException se) {
            throw new CLIException((Throwable)((Object)se), 20);
        }
    }

    private String trimTrailingSlash(String str) {
        for (int len = str.length(); len > 0 && str.charAt(len - 1) == '/'; --len) {
            str = str.substring(0, len - 1);
        }
        return str;
    }

    private List getSessionList(String name, String pattern) throws CLIException {
        IOutput output = this.getOutputWriter();
        ArrayList<SessionData> list = new ArrayList<SessionData>();
        try {
            String currentSessionHandler = this.curSession.getProperty("SessionHandle");
            SearchResults result = this.curSession.getValidSessions(name, null);
            String warning = this.getSearchResultWarningMessage(result);
            if (warning.length() > 0) {
                output.printlnMessage(warning);
            }
            Hashtable sessions = (Hashtable)result.getResultAttributes();
            boolean isCurrentSession = false;
            int i = 0;
            Iterator iter = sessions.values().iterator();
            while (iter.hasNext()) {
                String userId;
                boolean isCurr = false;
                Session sess = (Session)((Object)iter.next());
                if (!isCurrentSession) {
                    try {
                        isCurr = sess.getProperty("SessionHandle").equals(currentSessionHandler);
                    }
                    catch (SessionException se) {
                        throw new CLIException((Throwable)((Object)se), 127);
                    }
                    isCurrentSession = isCurr;
                }
                if ((userId = sess.getProperty(USER_ID)) == null || !DisplayUtils.wildcardMatch(userId = this.dnToName(userId), pattern)) continue;
                int idx = isCurr ? -1 : i++;
                SessionData sData = this.createSessionData(idx, userId, sess);
                if (idx == -1) {
                    list.add(0, sData);
                    continue;
                }
                list.add(sData);
            }
        }
        catch (SessionException se) {
            throw new CLIException(this.getResourceString("session-invalid-host-name"), 23);
        }
        return list;
    }

    private String getSearchResultWarningMessage(SearchResults results) {
        String message = null;
        if (results != null) {
            int errorCode = results.getErrorCode();
            if (errorCode == 1) {
                message = this.getResourceString("sizeLimitExceeded");
            } else if (errorCode == 2) {
                message = this.getResourceString("timeLimitExceeded");
            }
        }
        return message != null ? message : "";
    }

    private SessionData createSessionData(int index, String userId, Session sess) throws SessionException {
        SessionData sData = new SessionData();
        sData.userId = userId;
        sData.clientID = sess.getClientID();
        sData.index = index;
        sData.session = sess;
        sData.timeRemain = String.valueOf(sess.getTimeLeft() / 60L);
        sData.maxSessionTime = String.valueOf(sess.getMaxSessionTime());
        sData.idleTime = String.valueOf(sess.getIdleTime() / 60L);
        sData.maxIdleTime = String.valueOf(sess.getMaxIdleTime());
        return sData;
    }

    private String dnToName(String dn) {
        String ret = dn;
        if (DN.isDN((String)dn)) {
            String[] comps = LDAPDN.explodeDN((String)dn, (boolean)true);
            ret = comps[0];
        }
        return ret;
    }

    private class SessionData {
        private int index = 0;
        private String userId = null;
        private String clientID = null;
        private Session session = null;
        private String timeRemain = null;
        private String maxSessionTime = null;
        private String idleTime = null;
        private String maxIdleTime = null;

        private SessionData() {
        }
    }
}

