/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.util.HashSet;
import java.util.logging.Level;

public class RemoveAgentProperties
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String agentName = this.getStringOptionValue("agentname");
        HashSet attributeNames = new HashSet();
        attributeNames.addAll(rc.getOption("attributenames"));
        String[] params = new String[]{realm, agentName, ((Object)attributeNames).toString()};
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_AGENT_PROPERTIES", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, agentName, IdType.AGENTONLY, realm, null);
            amid.removeAttributes(attributeNames);
            outputWriter.printlnMessage(this.getResourceString("agent-remove-properties-succeeded"));
            this.writeLog(0, Level.INFO, "SUCCEED_REMOVE_AGENT_PROPERTIES", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, agentName, e.getMessage()};
            this.debugError("RemoveAgentProperties.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_AGENT_PROPERTIES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, agentName, e.getMessage()};
            this.debugError("RemoveAgentProperties.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_AGENT_PROPERTIES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

