/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.SMSException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class UpdateAgentGroup
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String agentGroupName = this.getStringOptionValue("agentgroupname");
        String datafile = this.getStringOptionValue("datafile");
        boolean bSet = this.isOptionSet("set");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        String[] params = new String[]{realm, agentGroupName};
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_UPDATE_AGENT_GROUP", params);
            AgentConfiguration.updateAgentGroup(adminSSOToken, realm, agentGroupName, attributeValues, bSet);
            outputWriter.printlnMessage(this.getResourceString("update-agent-group-succeeded"));
            this.writeLog(0, Level.INFO, "SUCCEED_UPDATE_AGENT_GROUP", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, agentGroupName, e.getMessage()};
            this.debugError("UpdateAgent.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_AGENT_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{realm, agentGroupName, e.getMessage()};
            this.debugError("UpdateAgent.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_AGENT_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, agentGroupName, e.getMessage()};
            this.debugError("UpdateAgent.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_AGENT_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, agentGroupName, e.getMessage()};
            this.debugError("UpdateAgent.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_AGENT_GROUP", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

