/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.config.AuthConfigurationEntry;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AddAuthConfigurationEntry
extends AuthenticatedCommand {
    private static Set POSSIBLE_CRITERIA = new HashSet();

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String configName = this.getStringOptionValue("name");
        String moduleName = this.getStringOptionValue("modulename");
        String criteria = this.getStringOptionValue("criteria");
        String options = this.getStringOptionValue("options");
        String[] params = new String[]{realm, configName, moduleName};
        if (!POSSIBLE_CRITERIA.contains(criteria)) {
            throw new CLIException(this.getResourceString("authentication-add-auth-config-entry-criteria.invalid"), 127);
        }
        int pos = this.getPosition();
        this.writeLog(0, Level.INFO, "ATTEMPT_ADD_AUTH_CONFIG_ENTRY", params);
        try {
            AuthConfigurationEntry ae = new AuthConfigurationEntry(moduleName, criteria, options);
            Set instanceNames = this.getInstanceNames(realm, adminSSOToken);
            String instanceName = ae.getLoginModuleName();
            if (!instanceNames.contains(instanceName)) {
                Object[] p = new Object[]{instanceName};
                throw new CLIException(MessageFormat.format(this.getResourceString("authentication-add-auth-config-entry-not-found"), p), 127);
            }
            ArrayList<AuthConfigurationEntry> entries = this.getConfigEntries(realm, configName, adminSSOToken);
            if (entries == null) {
                entries = new ArrayList<AuthConfigurationEntry>();
            }
            if (pos == -1 || pos >= entries.size()) {
                entries.add(ae);
            } else {
                entries.add(pos, ae);
            }
            HashMap configData = new HashMap(2);
            HashSet<String> tmp = new HashSet<String>(2);
            String xml = AMAuthConfigUtils.authConfigurationEntryToXMLString(entries);
            tmp.add(xml);
            configData.put("iplanet-am-auth-configuration", tmp);
            IOutput outputWriter = this.getOutputWriter();
            AMAuthConfigUtils.replaceNamedConfig(configName, 0, configData, realm, adminSSOToken);
            outputWriter.printlnMessage(this.getResourceString("authentication-add-auth-config-entry-succeeded"));
            this.writeLog(0, Level.INFO, "SUCCEEDED_ADD_AUTH_CONFIG_ENTRY", params);
        }
        catch (AMConfigurationException e) {
            this.debugError("GetAuthConfigurationEntries.handleRequest", (Throwable)((Object)e));
            String[] p = new String[]{realm, configName, moduleName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_AUTH_CONFIG_ENTRY", p);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            this.debugError("GetAuthConfigurationEntries.handleRequest", e);
            String[] p = new String[]{realm, configName, moduleName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_AUTH_CONFIG_ENTRY", p);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            this.debugError("GetAuthConfigurationEntries.handleRequest", (Throwable)((Object)e));
            String[] p = new String[]{realm, configName, moduleName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_AUTH_CONFIG_ENTRY", p);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }

    private int getPosition() throws CLIException {
        int pos = 0;
        String position = this.getStringOptionValue("position");
        if (position == null || position.trim().length() == 0) {
            pos = -1;
        } else {
            try {
                pos = Integer.parseInt(position);
                if (pos < 0) {
                    throw new CLIException(this.getResourceString("authentication-add-auth-config-entry-position.invalid"), 127);
                }
            }
            catch (NumberFormatException e) {
                throw new CLIException(this.getResourceString("authentication-add-auth-config-entry-position.invalid"), 127);
            }
        }
        return pos;
    }

    private Set getInstanceNames(String realm, SSOToken adminSSOToken) throws AMConfigurationException {
        HashSet<String> names = new HashSet<String>();
        AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, realm);
        Set instances = mgr.getAuthenticationInstances();
        Iterator i = instances.iterator();
        while (i.hasNext()) {
            AMAuthenticationInstance instance = (AMAuthenticationInstance)i.next();
            names.add(instance.getName());
        }
        return names;
    }

    private List getConfigEntries(String realm, String configName, SSOToken adminSSOToken) throws SMSException, SSOException, AMConfigurationException {
        Set tmp;
        ArrayList entries = null;
        Map configData = AMAuthConfigUtils.getNamedConfig(configName, realm, adminSSOToken);
        if (configData != null && !configData.isEmpty() && (tmp = (Set)configData.get("iplanet-am-auth-configuration")) != null && !tmp.isEmpty()) {
            String xml = (String)tmp.iterator().next();
            entries = new ArrayList(AMAuthConfigUtils.xmlToAuthConfigurationEntry(xml));
        }
        return entries;
    }

    static {
        POSSIBLE_CRITERIA.add("REQUIRED");
        POSSIBLE_CRITERIA.add("OPTIONAL");
        POSSIBLE_CRITERIA.add("SUFFICIENT");
        POSSIBLE_CRITERIA.add("REQUISITE");
    }
}

