/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.common.configuration.UnknownPropertyNameException;
import com.sun.identity.sm.ServiceAttributeValidator;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class ServerPropertyValidator
implements ServiceAttributeValidator {
    private static Map keyToPossibleValues = new HashMap();
    private static Set arrayKeys = new HashSet();
    private static Set mapKeys = new HashSet();
    private static Set integerKeys = new HashSet();
    private static Set floatKeys = new HashSet();
    private static final String MAP = "map";
    private static final String INTEGER = "integer";
    private static final String FLOAT = "float";

    private static void initialize() {
        ResourceBundle rb = ResourceBundle.getBundle("validserverconfig");
        Enumeration<String> e = rb.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = rb.getString(key);
            if (key.endsWith(".*")) {
                arrayKeys.add(key.substring(0, key.length() - 1));
                continue;
            }
            if (value.equals(MAP)) {
                mapKeys.add(key);
                continue;
            }
            if (value.equals(INTEGER)) {
                integerKeys.add(key);
                continue;
            }
            if (value.equals(FLOAT)) {
                floatKeys.add(key);
                continue;
            }
            if (value.length() > 0) {
                StringTokenizer st = new StringTokenizer(value, ",");
                HashSet<Object> set = new HashSet<Object>(st.countTokens() * 2);
                while (st.hasMoreTokens()) {
                    set.add(st.nextElement());
                }
                keyToPossibleValues.put(key, set);
                continue;
            }
            keyToPossibleValues.put(key, Collections.EMPTY_SET);
        }
    }

    public boolean validate(Set properties) {
        try {
            ServerPropertyValidator.validateProperty(properties);
            return true;
        }
        catch (UnknownPropertyNameException ex) {
            return false;
        }
        catch (ConfigurationException ex) {
            return false;
        }
    }

    public static void validateProperty(Set properties) throws UnknownPropertyNameException, ConfigurationException {
        try {
            ServerPropertyValidator.validate(ServerConfiguration.getProperties(properties));
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex.getMessage());
        }
    }

    public static void validate(Map properties) throws UnknownPropertyNameException, ConfigurationException {
        HashSet<String> unknownProperyNames = new HashSet<String>();
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)properties.get(key);
            if (value.indexOf("%") != -1) continue;
            try {
                boolean valid = ServerPropertyValidator.validateMap(key, value) || ServerPropertyValidator.validateNumber(key, value) || ServerPropertyValidator.validate(key, value);
            }
            catch (UnknownPropertyNameException e) {
                unknownProperyNames.add(key);
            }
        }
        if (!unknownProperyNames.isEmpty()) {
            if (unknownProperyNames.size() == 1) {
                String key = (String)unknownProperyNames.iterator().next();
                Object[] param = new String[]{key};
                throw new UnknownPropertyNameException("unknown.property", param);
            }
            StringBuffer keys = new StringBuffer();
            boolean first = true;
            Iterator i2 = unknownProperyNames.iterator();
            while (i2.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    keys.append(", ");
                }
                keys.append((String)i2.next());
            }
            Object[] param = new String[]{keys.toString()};
            throw new UnknownPropertyNameException("unknown.properties", param);
        }
    }

    private static boolean validateMap(String key, String value) throws UnknownPropertyNameException, ConfigurationException {
        boolean validated = false;
        if (key.endsWith("]")) {
            int startBracket = key.indexOf(91);
            if (startBracket == -1) {
                Object[] param = new String[]{key};
                throw new ConfigurationException("invalid.map.property", param);
            }
            String k = key.substring(0, startBracket);
            if (!mapKeys.contains(k) && !arrayKeys.contains(k)) {
                Object[] param = new String[]{key};
                throw new UnknownPropertyNameException("unknown.property", param);
            }
            if (arrayKeys.contains(k)) {
                int endBracket = key.indexOf(91);
                String ind = key.substring(startBracket + 1, endBracket);
                try {
                    Integer.parseInt(ind);
                }
                catch (NumberFormatException ex) {
                    Object[] param = new String[]{key};
                    throw new ConfigurationException("invalid.array.property", param);
                }
            }
            validated = true;
        }
        return validated;
    }

    private static boolean validateNumber(String key, String value) throws UnknownPropertyNameException, ConfigurationException {
        boolean validated = false;
        if (floatKeys.contains(key)) {
            try {
                Float.parseFloat(value);
            }
            catch (NumberFormatException ex) {
                Object[] param = new String[]{key};
                throw new ConfigurationException("invalid.float.property", param);
            }
            validated = true;
        } else if (integerKeys.contains(key)) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                Object[] param = new String[]{key};
                throw new ConfigurationException("invalid.integer.property", param);
            }
            validated = true;
        }
        return validated;
    }

    private static boolean validate(String key, String value) throws UnknownPropertyNameException, ConfigurationException {
        Set possibleValues;
        if (!keyToPossibleValues.keySet().contains(key)) {
            Object[] param = new String[]{key};
            throw new UnknownPropertyNameException("unknown.property", param);
        }
        if (value.length() > 0 && !(possibleValues = (Set)keyToPossibleValues.get(key)).isEmpty() && !possibleValues.contains(value)) {
            Object[] param = new String[]{key};
            throw new ConfigurationException("invalid.value.property", param);
        }
        return true;
    }

    public static String getTrueValue(String propertyKey) {
        Set set = (Set)keyToPossibleValues.get(propertyKey);
        Iterator i = set.iterator();
        return (String)i.next();
    }

    public static String getFalseValue(String propertyKey) {
        Set set = (Set)keyToPossibleValues.get(propertyKey);
        Iterator i = set.iterator();
        i.next();
        return (String)i.next();
    }

    static {
        ServerPropertyValidator.initialize();
    }
}

