/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base;

import com.iplanet.am.util.BrowserEncoding;
import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.Encoder;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.Button;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.sun.identity.console.base.AMAdminFrameViewBean;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMI18NUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSSchema;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.server.UID;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AMViewBeanBase
extends ViewBeanBase {
    public static Debug debug = Debug.getInstance((String)"amConsole");
    private static final int MAX_PG_SESSION_SIZE = 992;
    private static final String TXT_LOCATION = "txtLocation";
    private static final String TXT_RANDOM_STR = "txtRandomStr";
    private static final String PG_SESSION = "pgSession";
    private static final String IALERT_COMMON = "ialertCommon";
    protected static final String PG_SESSION_ATTR_ID = "dsame.pgSessionID";
    protected static final String PG_SESSION_SSO_ID = "dsame.pgSessionSSOID";
    protected static final String PG_SESSION_ATTR = "dsame.pgSession";
    protected static final String SZ_CACHE = "szCache";
    protected static final String BTN_GHOST = "g";
    protected boolean initialized = false;
    private final String vbUID = new UID().toString();
    private boolean pageSessionInSessionStore = false;
    private AMModel dataModel;
    private Set blankTextFields = new HashSet();

    public AMViewBeanBase(String name) {
        super(name);
    }

    public void forwardTo(RequestContext rc) throws NavigationException {
        this.initialize();
        super.forwardTo(rc);
    }

    public void setRequestContext(RequestContext context) {
        super.setRequestContext(context);
        this.handlePageSessionThruURL(context);
        this.setRequestContentInitialize(context);
    }

    protected void setRequestContentInitialize(RequestContext context) {
        this.initialize();
    }

    protected void initialize() {
    }

    protected void registerChildren() {
        this.registerChild(SZ_CACHE, SerializedField.class);
        this.registerChild(BTN_GHOST, Button.class);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(PG_SESSION)) {
            view = new StaticTextField((ContainerView)this, name, (Object)"");
        } else if (name.equals(BTN_GHOST)) {
            view = new Button((ContainerView)this, name, (Object)"");
        } else if (name.startsWith("txt")) {
            view = new CCStaticTextField((ContainerView)this, name, null);
        } else if (name.startsWith("sz")) {
            view = new SerializedField((ContainerView)this, name, null);
        } else if (name.startsWith("cb")) {
            view = new CCCheckBox((ContainerView)this, name, (Object)"true", (Object)"false", false);
        } else if (name.startsWith("tf")) {
            view = new CCTextField((ContainerView)this, name, null);
        } else if (name.startsWith("lbl")) {
            view = new CCLabel((ContainerView)this, name, null);
        } else if (name.startsWith("btn")) {
            view = new CCButton((ContainerView)this, name, null);
        } else if (name.startsWith("singleChoice")) {
            view = new CCDropDownMenu((ContainerView)this, name, null);
        } else if (name.startsWith("href")) {
            view = new CCHref((ContainerView)this, name, null);
        } else if (name.startsWith("radio")) {
            view = new CCRadioButton((ContainerView)this, name, null);
        } else if (name.startsWith("ialert")) {
            view = new CCAlertInline((ContainerView)this, name, null);
        } else {
            throw new IllegalArgumentException("Invalid child name [" + name + "]");
        }
        return view;
    }

    private void handlePageSessionThruURL(RequestContext context) {
        HttpServletRequest req = context.getRequest();
        String pgSession = req.getParameter(PG_SESSION_ATTR);
        if (pgSession != null) {
            try {
                Map map = (Map)Encoder.deserialize((byte[])Encoder.decodeHttp64((String)pgSession), (boolean)false);
                if (map != null) {
                    Iterator i = map.keySet().iterator();
                    while (i.hasNext()) {
                        String k = (String)i.next();
                        this.setPageSessionAttribute(k, (Serializable)map.get(k));
                    }
                }
            }
            catch (ClassNotFoundException e) {
                debug.warning("AMModelBase.handlePageSessionThruURL", (Throwable)e);
            }
            catch (IOException e) {
                debug.warning("AMModelBase.handlePageSessionThruURL", (Throwable)e);
            }
        }
    }

    public String getCharset(AMModel model) {
        Locale locale = model.getUserLocale();
        String agentType = model.getClientType();
        String charset = AMI18NUtils.getCharset(agentType, locale);
        String jCharset = BrowserEncoding.mapHttp2JavaCharset(charset);
        return jCharset;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        AMModel model = this.getModel();
        this.setPageEncoding(model);
        this.setDisplayFieldValue(TXT_RANDOM_STR, model.getRandomString());
        this.setDisplayFieldValue(PG_SESSION, this.getPageSessionAttributeString());
        this.setDisplayFieldValue(TXT_LOCATION, this.getModel().getLocalizedString("label.location"));
        this.performDelegationTasks();
    }

    public void passPgSessionMap(ViewBean other) {
        this.passPgSessionMap(other, this.getPageSessionAttributes());
    }

    public void passPgSessionMap(ViewBean other, Map attributes) {
        if (attributes != null && attributes.size() > 0) {
            Iterator iter = attributes.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                other.setPageSessionAttribute(key, (Serializable)attributes.get(key));
            }
        }
    }

    public AMModel getModel() {
        if (this.dataModel == null) {
            this.dataModel = this.getModelInternal();
        }
        return this.dataModel;
    }

    protected void setInlineAlertMessage(String type, String title, String message) {
        CCAlertInline alert = (CCAlertInline)this.getChild(IALERT_COMMON);
        alert.setType(type);
        alert.setSummary(title);
        alert.setDetail(message);
    }

    protected boolean isInlineAlertMessageSet() {
        CCAlertInline alert = (CCAlertInline)this.getChild(IALERT_COMMON);
        String detail = alert.getDetail();
        return detail != null && detail.length() > 0;
    }

    protected void mapRequestParameter(DisplayField field, Object[] childValues) {
        if (field instanceof SerializedField) {
            if (childValues != null && childValues.length > 0) {
                ((SerializedField)field).setSerializedString((String)childValues[0]);
            }
        } else {
            super.mapRequestParameter(field, childValues);
        }
    }

    protected abstract AMModel getModelInternal();

    public OptionList createOptionList(Map map) {
        OptionList optionList = new OptionList();
        if (map != null && !map.isEmpty()) {
            List sorted = AMFormatUtils.sortItems(map.values(), this.getModel().getUserLocale());
            Map reversed = AMFormatUtils.reverseStringMap(map);
            Iterator iter = sorted.iterator();
            while (iter.hasNext()) {
                String label = (String)iter.next();
                optionList.add(label, (String)reversed.get(label));
            }
        }
        return optionList;
    }

    public static OptionList createOptionList(Map map, Locale locale) {
        OptionList optionList = new OptionList();
        if (map != null && !map.isEmpty()) {
            Map reverseMap = AMFormatUtils.reverseStringMap(map);
            List list = AMFormatUtils.sortKeyInMap(reverseMap, locale);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String label = (String)iter.next();
                optionList.add(label, (String)reverseMap.get(label));
            }
        }
        return optionList;
    }

    public static OptionList createOptionList(Collection collection, Locale locale) {
        OptionList optionList = new OptionList();
        if (collection != null && !collection.isEmpty()) {
            collection = AMFormatUtils.sortItems(collection, locale);
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                String value = (String)iter.next();
                optionList.add(value, value);
            }
        }
        return optionList;
    }

    public OptionList createOptionList(Collection collection) {
        OptionList optionList = new OptionList();
        if (collection != null && !collection.isEmpty()) {
            collection = AMFormatUtils.sortItems(collection, this.getModel().getUserLocale());
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                String value = (String)iter.next();
                optionList.add(value, value);
            }
        }
        return optionList;
    }

    public static Set getValues(OptionList optList) {
        HashSet<String> set = null;
        if (optList != null && optList.size() > 0) {
            int sz = optList.size();
            set = new HashSet<String>(sz * 2);
            for (int i = 0; i < sz; ++i) {
                set.add(optList.getValue(i));
            }
        }
        return set != null ? set : Collections.EMPTY_SET;
    }

    public static List getList(OptionList optList) {
        int sz = optList.size();
        ArrayList<String> list = new ArrayList<String>(sz);
        for (int i = 0; i < sz; ++i) {
            list.add(optList.getValue(i));
        }
        return list;
    }

    protected String appendPgSession(String url) {
        StringBuffer sb = new StringBuffer();
        sb.append(url);
        if (url.indexOf("?") == -1) {
            sb.append("?");
        } else {
            sb.append("&");
        }
        sb.append(PG_SESSION_ATTR).append("=").append(this.encodePageSessionMap());
        return sb.toString();
    }

    private String encodePageSessionMap() {
        String encoded = "";
        try {
            HashMap map = new HashMap(this.getPageSessionAttributes());
            encoded = Encoder.encodeHttp64((byte[])Encoder.serialize(map, (boolean)false), (int)800);
        }
        catch (IOException e) {
            debug.error("AMViewBeanBase.encodePageSessionMap", (Throwable)e);
        }
        return encoded;
    }

    protected void resetButtonState(String btnName) {
        CCButton btn = (CCButton)this.getChild(btnName);
        btn.resetStateData();
    }

    public void disableButton(String btnName, boolean disable) {
        CCButton btn = (CCButton)this.getChild(btnName);
        btn.setDisabled(disable);
    }

    protected String getCharset() {
        AMModel model = this.getModel();
        Locale locale = model.getUserLocale();
        String agentType = model.getClientType();
        String charset = AMI18NUtils.getCharset(agentType, locale);
        return BrowserEncoding.mapHttp2JavaCharset(charset);
    }

    protected String getContentType() {
        AMModel model = this.getModel();
        Locale locale = model.getUserLocale();
        String agentType = model.getClientType();
        String content_type = AMI18NUtils.getContentType(agentType);
        return content_type;
    }

    private void setPageEncoding(AMModel model) {
        HttpServletResponse res = this.getRequestContext().getResponse();
        HttpServletRequest req = this.getRequestContext().getRequest();
        String content_type = this.getContentType();
        String charset = this.getCharset();
        String jCharset = BrowserEncoding.mapHttp2JavaCharset(charset);
        res.setContentType(content_type + ";charset=" + jCharset);
        CCI18N.initContentType((ServletRequest)req, (ServletResponse)res);
    }

    public void handleGRequest(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void resetView() {
    }

    protected void bypassForwardTo(RequestContext rc) {
        super.forwardTo(rc);
    }

    public void setCurrentLocation(String dn) {
        if (dn != null) {
            this.setPageSessionAttribute("com-iplanet-am-console-location-dn", (Serializable)((Object)dn));
        }
    }

    public String getCurrentLocationDN() {
        return (String)this.getPageSessionAttribute("com-iplanet-am-console-location-dn");
    }

    public String getCurrentLocation() {
        String tmp = (String)this.getPageSessionAttribute("com-iplanet-am-console-location-dn");
        if (tmp != null && tmp.length() > 0) {
            int x = tmp.lastIndexOf("/");
            tmp = tmp.substring(x + 1);
        }
        return tmp;
    }

    public void hideTableSelectionIcons(String tableName) {
        CCActionTable table = (CCActionTable)this.getChild(tableName);
        CCActionTableModelInterface model = table.getModel();
        model.setSelectionType("none");
    }

    public Set getBlankTextFields() {
        return this.blankTextFields;
    }

    public void addBlankTextField(String name) {
        this.blankTextFields.add(name);
    }

    protected void performDelegationTasks() {
        DelegationConfig config = DelegationConfig.getInstance();
        String realmName = (String)this.getPageSessionAttribute("CurrentProfileView");
        config.configureButtonsAndTables(realmName, this.getServiceNameForAccessControl(), this.getModel(), this);
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        boolean display = false;
        Method method = this.getBeginDisplayMethod(event.getChildName());
        if (method != null) {
            Object[] param = new Object[]{event};
            try {
                Boolean results = (Boolean)method.invoke((Object)this, param);
                display = results;
            }
            catch (IllegalAccessException e) {
                debug.warning("AMViewBeanBase.beginChildDisplay", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                debug.warning("AMViewBeanBase.beginChildDisplay", (Throwable)e);
            }
        } else {
            super.endDisplay((DisplayEvent)event);
            display = !this.blankTextFields.contains(event.getChildName());
        }
        return display;
    }

    private Method getBeginDisplayMethod(String childName) {
        char[] nameChars = childName.toCharArray();
        nameChars[0] = Character.toUpperCase(nameChars[0]);
        String methodName = "begin" + new String(nameChars) + "Display";
        Class[] param = new Class[]{ChildDisplayEvent.class};
        Method method = null;
        try {
            method = ((Object)((Object)this)).getClass().getMethod(methodName, param);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return method;
    }

    protected String getServiceNameForAccessControl() {
        return null;
    }

    public AMViewBeanBase getCallingView() {
        String returnVB = (String)this.removePageSessionAttribute("returnToViewBean");
        if (returnVB == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(returnVB);
            AMViewBeanBase vb = (AMViewBeanBase)this.getViewBean(clazz);
            return vb;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public Locale getUserLocale() {
        AMModel model = this.getModel();
        return model != null ? model.getUserLocale() : Locale.US;
    }

    public String getPageSessionAttributeString() {
        String strAttr;
        if (this.pageSessionInSessionStore) {
            this.pageSessionInSessionStore = false;
            strAttr = super.getPageSessionAttributeString();
            this.pageSessionInSessionStore = true;
        } else {
            strAttr = super.getPageSessionAttributeString();
            if (strAttr.length() >= 992) {
                SSOToken ssoToken = this.getModel().getUserSSOToken();
                String ssoTokenID = ((Object)ssoToken.getTokenID()).toString();
                Map store = SessionStore.getSessionStore(ssoToken);
                Map attributes = this.getPageSessionAttributes();
                store.put(this.vbUID, attributes);
                HashMap<String, String> tmp = new HashMap<String, String>(4);
                tmp.put(PG_SESSION_ATTR_ID, this.vbUID);
                tmp.put(PG_SESSION_SSO_ID, ssoTokenID);
                super.setPageSessionAttributes(tmp);
                strAttr = super.getPageSessionAttributeString();
                this.pageSessionInSessionStore = true;
            }
        }
        return strAttr;
    }

    protected void deserializePageAttributes() {
        Map store;
        super.deserializePageAttributes();
        this.pageSessionInSessionStore = false;
        String ssoid = (String)super.getPageSessionAttribute(PG_SESSION_SSO_ID);
        if (ssoid != null && (store = SessionStore.getSessionStore(ssoid)) != null) {
            Map savedAttr = (Map)store.get((String)super.getPageSessionAttribute(PG_SESSION_ATTR_ID));
            super.setPageSessionAttributes(savedAttr);
        }
    }

    protected void setPageSessionAttributes(Map value) {
        if (this.pageSessionInSessionStore) {
            String ssoTokenID = ((Object)this.getModel().getUserSSOToken().getTokenID()).toString();
            Map store = SessionStore.getSessionStore(ssoTokenID);
            store.put(this.vbUID, value);
            super.getPageSessionAttributes().put(PG_SESSION_ATTR_ID, this.vbUID);
        } else {
            super.setPageSessionAttributes(value);
        }
    }

    protected Map getPageSessionAttributes() {
        Map attributes;
        if (this.pageSessionInSessionStore) {
            String ssoTokenID = ((Object)this.getModel().getUserSSOToken().getTokenID()).toString();
            Map store = SessionStore.getSessionStore(ssoTokenID);
            attributes = (Map)store.get(this.vbUID);
        } else {
            attributes = super.getPageSessionAttributes();
        }
        return attributes;
    }

    protected void redirectToStartURL() {
        AMAdminFrameViewBean vb = (AMAdminFrameViewBean)this.getViewBean(AMAdminFrameViewBean.class);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getBackButtonLabel(String label) {
        String localizedLabel = this.getModel().getLocalizedString(label);
        if (localizedLabel.equals(label)) {
            localizedLabel = this.getModel().getLocalizedString("previous.view");
        }
        String[] arg = new String[]{localizedLabel};
        return MessageFormat.format(this.getModel().getLocalizedString("back.button"), arg);
    }

    protected String getCurrentRealm() {
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        if (curRealm == null) {
            curRealm = AMModelBase.getStartDN(this.getRequestContext().getRequest());
            this.setPageSessionAttribute("currentRealm", (Serializable)((Object)curRealm));
        }
        return curRealm;
    }

    public String getPath(String child) {
        AMModel model = this.getModel();
        StringBuffer path = new StringBuffer();
        path.append(AMFormatUtils.DNToName(model, model.getStartDSDN()));
        String startDN = model.getStartDN();
        if (startDN.charAt(0) != '/') {
            startDN = "/" + startDN;
        }
        if (child.charAt(0) != '/') {
            child = "/" + child;
        }
        if (!child.equals(startDN)) {
            int idx = child.indexOf(startDN);
            String subRealm = idx == 0 ? child.substring(startDN.length()) : child;
            StringTokenizer st = new StringTokenizer(subRealm, "/");
            while (st.hasMoreTokens()) {
                path.append(" > ").append(SMSSchema.unescapeName(st.nextToken()));
            }
        }
        return path.toString();
    }

    protected String getRequestURL() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        String uri = req.getRequestURI().toString();
        int idx = uri.indexOf(47, 1);
        uri = uri.substring(0, idx);
        return req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + uri;
    }

    private static class SessionStore {
        private static Map stores = new HashMap();
        private static SSOTokenListener listener = new SSOTokenListener(){

            public void ssoTokenChanged(SSOTokenEvent event) {
                try {
                    switch (event.getType()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            SSOToken token = event.getToken();
                            stores.remove(((Object)token.getTokenID()).toString());
                        }
                    }
                }
                catch (SSOException ssoe) {
                    debug.warning("SessionStore.ssoTokenChanged", (Throwable)((Object)ssoe));
                }
            }
        };

        private SessionStore() {
        }

        static Map getSessionStore(SSOToken ssoToken) {
            String storeKey = ((Object)ssoToken.getTokenID()).toString();
            HashMap store = SessionStore.getSessionStore(storeKey);
            if (store == null) {
                store = new HashMap();
                stores.put(storeKey, store);
                try {
                    ssoToken.addSSOTokenListener(listener);
                }
                catch (SSOException ssoe) {
                    debug.warning("SessionStore.getSessionStore", (Throwable)((Object)ssoe));
                }
            }
            return store;
        }

        static Map getSessionStore(String storeKey) {
            return (Map)stores.get(storeKey);
        }
    }
}

