/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.dm.UserViewBean;
import com.sun.identity.console.dm.model.UserModel;
import com.sun.identity.console.dm.model.UserModelImpl;
import com.sun.identity.console.realm.RMRealmOpViewBeanBase;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NewUserViewBean
extends RMRealmOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/NewUser.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String NAME = "tfName";
    private AMPropertySheetModel propertySheetModel;
    private UserModel model = null;

    public NewUserViewBean() {
        super("NewUser");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String location;
        if (!this.initialized && (location = (String)this.getPageSessionAttribute("currentOrganization")) != null) {
            super.initialize();
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name) : super.createChild(name)));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
        ps.init();
        super.beginDisplay(event);
        this.setPeopleContainerList();
    }

    private void setPeopleContainerList() {
        String location = (String)this.getPageSessionAttribute("currentOrganization");
        UserModel model = (UserModel)this.getModel();
        Set peopleContainers = model.getPeopleContainers(location);
        if (peopleContainers != null && peopleContainers.size() > 1 && !model.showPeopleContainers()) {
            OptionList containers = new OptionList();
            Iterator i = peopleContainers.iterator();
            while (i.hasNext()) {
                String entry = (String)i.next();
                containers.add(entry, entry);
            }
            CCDropDownMenu cb = (CCDropDownMenu)this.getChild("peopleContainer");
            cb.setOptions(containers);
        }
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.ok");
        this.ptModel.setValue("button2", (Object)"button.cancel");
    }

    private void createPropertyModel() {
        UserModel model = (UserModel)this.getModel();
        String location = (String)this.getPageSessionAttribute("currentOrganization");
        this.propertySheetModel = new AMPropertySheetModel(model.getCreateUserPropertyXML(location));
        this.propertySheetModel.clear();
    }

    protected AMModel getModelInternal() {
        if (this.model == null) {
            RequestContext rc = RequestManager.getRequestContext();
            this.model = new UserModelImpl(rc.getRequest(), this.getPageSessionAttributes());
        }
        return this.model;
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        String startDN;
        UserModel model = (UserModel)this.getModel();
        String location = (String)this.getPageSessionAttribute("CurrentProfileView");
        if (location.equalsIgnoreCase(startDN = model.getStartDN())) {
            location = (String)this.getPageSessionAttribute("currentOrganization");
        }
        try {
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            Map values = ps.getAttributeValues(model.getDataMap(), false, model);
            model.createUser(location, values);
            this.forwardToUserView(event);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardToUserView(event);
    }

    private void forwardToUserView(RequestInvocationEvent event) {
        String returnVB = (String)this.removePageSessionAttribute("returnToViewBean");
        if (returnVB == null) {
            debug.warning("viewbean not set returning to user view");
            UserViewBean vb = (UserViewBean)this.getViewBean(UserViewBean.class);
            this.backTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        } else {
            try {
                String tmp = (String)this.getPageSessionAttribute("currentOrganization");
                Class<?> clazz = Class.forName(returnVB);
                AMViewBeanBase vb = (AMViewBeanBase)this.getViewBean(clazz);
                this.backTrail();
                this.passPgSessionMap((ViewBean)vb);
                vb.forwardTo(this.getRequestContext());
            }
            catch (ClassNotFoundException cnfe) {
                this.forwardTo(this.getRequestContext());
            }
        }
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.directorymanager.user.add";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

