/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm.model;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.dm.model.DMModelBase;
import com.sun.identity.console.dm.model.GroupContainerModel;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class GroupContainerModelImpl
extends DMModelBase
implements GroupContainerModel {
    private Set containers = null;
    private static final String CREATE_PROPERTIES = "<section name=\"attributes\" defaultValue=\"\" ><property><label name=\"lblPcName\" defaultValue=\"label.name\" labelFor=\"tfPCName\" /><cc name=\"tfPCName\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" /></property></section>";

    public GroupContainerModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Set getGroupContainers(String location, String filter) {
        if (this.containers == null) {
            AMSearchResults results = null;
            AMSearchControl searchControl = new AMSearchControl();
            searchControl.setSearchScope(2);
            this.setSearchControlLimits(searchControl);
            this.setSearchControlAttributes(location, "GroupContainer", 4, searchControl, "groupContainers");
            boolean bOrganization = false;
            boolean bContainer = false;
            AMStoreConnection sc = this.getAMStoreConnection();
            try {
                String[] params = new String[]{location, filter};
                switch (this.getObjectType(location)) {
                    case 2: {
                        bOrganization = true;
                        this.logEvent("ATTEMPT_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_ORG", params);
                        AMOrganization org = sc.getOrganization(location);
                        results = org.searchGroupContainers(filter, null, searchControl);
                        this.logEvent("SUCCEED_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_ORG", params);
                        break;
                    }
                    case 3: {
                        bContainer = true;
                        this.logEvent("ATTEMPT_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_CONTAINER", params);
                        AMOrganizationalUnit orgUnit = sc.getOrganizationalUnit(location);
                        results = orgUnit.searchGroupContainers(filter, null, searchControl);
                        this.logEvent("SUCCEED_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_CONTAINER", params);
                        break;
                    }
                    case 4: {
                        this.logEvent("ATTEMPT_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_GRP_CONTAINER", params);
                        AMGroupContainer groupContainer = sc.getGroupContainer(location);
                        results = groupContainer.searchSubGroupContainers(filter, null, searchControl);
                        this.logEvent("SUCCEED_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_GRP_CONTAINER", params);
                        break;
                    }
                    default: {
                        if (debug.warningEnabled()) {
                            debug.warning("GroupContainerModelImpl.getGroupContainersinvalid location " + this.locationType);
                        }
                        break;
                    }
                }
            }
            catch (SSOException ssoe) {
                String[] paramsEx = new String[]{location, filter, this.getErrorString((Throwable)((Object)ssoe))};
                String msgId = null;
                msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_ORG" : (bContainer ? "SSO_EXCEPTION_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_CONTAINER" : "SSO_EXCEPTION_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_GRP_CONTAINER");
                this.logEvent(msgId, paramsEx);
                debug.warning("GroupContainerModelImpl.getGroupContainers", (Throwable)((Object)ssoe));
            }
            catch (AMException ame) {
                this.searchErrorMsg = this.getErrorString(ame);
                String[] paramsEx = new String[]{location, filter, this.searchErrorMsg};
                String msgId = null;
                msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_ORG" : (bContainer ? "AM_EXCEPTION_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_CONTAINER" : "AM_EXCEPTION_DIR_MGR_SEARCH_GROUP_CONTAINERS_UNDER_GRP_CONTAINER");
                this.logEvent(msgId, paramsEx);
                debug.warning("UMGCNavModelImpl.GroupContainerModelImpl", (Throwable)ame);
            }
            this.containers = this.setSearchResults(results);
        }
        return this.containers;
    }

    public void createGroupContainer(String location, Map data) throws AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("GroupContainerModel.createGroupContainer");
            debug.message("data = " + data);
            debug.message("parent = " + location);
        }
        if (data == null || data.isEmpty()) {
            throw new AMConsoleException(this.getLocalizedString("createFailure.message"));
        }
        Set tmp = (Set)data.remove("tfPCName");
        if (tmp == null || tmp.isEmpty()) {
            throw new AMConsoleException(this.getLocalizedString("message.missing.name"));
        }
        String name = (String)tmp.iterator().next();
        if (name == null || name.length() == 0) {
            throw new AMConsoleException(this.getLocalizedString("message.missing.name"));
        }
        this.validateRequiredAttributes(data);
        HashMap<String, Map> input = new HashMap<String, Map>(2);
        input.put(name, data);
        String[] params = new String[]{location, name};
        boolean bOrganization = false;
        boolean bContainer = false;
        AMStoreConnection sc = this.getAMStoreConnection();
        try {
            int locType = this.getObjectType(location);
            if (locType == 2) {
                bOrganization = true;
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_GROUP_CONTAINER_IN_ORG", params);
                AMOrganization parent = sc.getOrganization(location);
                parent.createGroupContainers(input);
                this.logEvent("SUCCEED_DIR_MGR_CREATE_GROUP_CONTAINER_IN_ORG", params);
            } else if (locType == 3) {
                bContainer = true;
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_GROUP_CONTAINER_IN_CONTAINER", params);
                AMOrganizationalUnit parent = sc.getOrganizationalUnit(location);
                parent.createGroupContainers(input);
                this.logEvent("SUCCEED_DIR_MGR_CREATE_GROUP_CONTAINER_IN_CONTAINER", params);
            } else {
                this.logEvent("ATTEMPT_DIR_MGR_CREATE_GROUP_CONTAINER_IN_GRP_CONTAINER", params);
                AMGroupContainer parent = sc.getGroupContainer(location);
                parent.createSubGroupContainers(input);
                this.logEvent("SUCCEED_DIR_MGR_CREATE_GROUP_CONTAINER_IN_GRP_CONTAINER", params);
            }
        }
        catch (AMException e) {
            String msgId = null;
            msgId = bOrganization ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_CONTAINER_IN_ORG" : (bContainer ? "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_CONTAINER_IN_CONTAINER" : "AM_EXCEPTION_DIR_MGR_CREATE_GROUP_CONTAINER_IN_GRP_CONTAINER");
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{location, name, strError};
            this.logEvent(msgId, paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String msgId = null;
            msgId = bOrganization ? "SSO_EXCEPTION_DIR_MGR_CREATE_GROUP_CONTAINER_IN_ORG" : (bContainer ? "SSO_EXCEPTION_DIR_MGR_CREATE_GROUP_CONTAINER_IN_CONTAINER" : "SSO_EXCEPTION_DIR_MGR_CREATE_GROUP_CONTAINER_IN_GRP_CONTAINER");
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{location, name, strError};
            this.logEvent(msgId, paramsEx);
            debug.error("GroupContainerModelImpl.createGroupContainer", (Throwable)((Object)e));
        }
    }

    public String getCreateGroupContainerXML() {
        StringBuffer buff = new StringBuffer(2000);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n").append(CREATE_PROPERTIES);
        this.getPropertyXML("iPlanetAMEntrySpecificService", "GroupContainer", SchemaType.GLOBAL, buff);
        buff.append("</propertysheet>\n");
        return buff.toString();
    }

    public Map getDataMap() {
        HashMap<String, Set> map = new HashMap<String, Set>();
        try {
            Set attrSchemas;
            ServiceSchema sub = this.getSubSchema("iPlanetAMEntrySpecificService", SchemaType.GLOBAL, "GroupContainer");
            if (sub != null && (attrSchemas = sub.getAttributeSchemas()) != null) {
                Iterator i = attrSchemas.iterator();
                while (i.hasNext()) {
                    AttributeSchema as = (AttributeSchema)i.next();
                    map.put(as.getName().toLowerCase(), Collections.EMPTY_SET);
                }
            }
            map.put("tfPCName", Collections.EMPTY_SET);
        }
        catch (SMSException e) {
            debug.error("GroupContainerModel.getDataMap", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("GroupContainerModel.getDataMap", (Throwable)((Object)e));
        }
        return map;
    }

    public boolean hasDisplayProperties() {
        Map tmp = this.getDataMap();
        tmp.remove("tfPCName");
        return !tmp.isEmpty();
    }
}

