/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm.model;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMSystemConfig;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.dm.model.DMModelBase;
import com.sun.identity.console.dm.model.UMOrganizationModel;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class UMOrganizationModelImpl
extends DMModelBase
implements UMOrganizationModel {
    private Map localizedAttrNames = null;
    private AMOrganization org = null;
    private ServiceSchemaManager entrySpecificSvcMgr = null;
    private static String ORGANIZATION = "Organization";
    private static final String PROPERTY_SECTION_CREATION_GENERAL = "<section name=\"general\" defaultValue=\"realm.sectionHeader.general\"><property required=\"true\"><label name=\"lblName\" defaultValue=\"authDomain.attribute.label.name\" labelFor=\"tfName\" /><cc name=\"tfName\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" ><attribute name=\"autoSubmit\" value=\"false\" /></cc></property></section>";

    public UMOrganizationModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Map getAssignableServiceNames(String location) throws AMConsoleException {
        HashMap<String, String> available = null;
        try {
            AMOrganization org = this.getAMStoreConnection().getOrganization(location);
            Set currentServices = org.getRegisteredServiceNames();
            Set parentServices = null;
            if (location.equals(AMSystemConfig.defaultOrg)) {
                parentServices = this.getAMStoreConnection().getServiceNames();
            } else {
                String parentDN = org.getParentDN();
                AMOrganization parent = this.getAMStoreConnection().getOrganization(parentDN);
                parentServices = parent.getRegisteredServiceNames();
            }
            parentServices.removeAll(currentServices);
            if (parentServices != null && !parentServices.isEmpty()) {
                available = new HashMap<String, String>(parentServices.size() * 2);
                AMViewConfig viewConfig = AMViewConfig.getInstance();
                Iterator i = parentServices.iterator();
                while (i.hasNext()) {
                    String displayName;
                    String name = (String)i.next();
                    if (!viewConfig.isServiceVisible(name) || name.equals(displayName = this.getLocalizedServiceName(name))) continue;
                    available.put(name, displayName);
                }
            }
        }
        catch (AMException e) {
            debug.warning("`OrganizationModel.getAssignableServices", (Throwable)e);
            throw new AMConsoleException(e.getMessage());
        }
        catch (SSOException e) {
            debug.warning("OrganizationModel.getAssignableServices", (Throwable)((Object)e));
        }
        return available == null ? Collections.EMPTY_MAP : available;
    }

    public Map getAssignedServices(String location) {
        HashMap<String, String> names = null;
        try {
            String[] param = new String[]{location};
            this.logEvent("ATTEMPT_DIR_MGR_GET_ASSIGNED_SERVICE_TO_ORG", param);
            AMOrganization org = this.getAMStoreConnection().getOrganization(location);
            Set tmp = org.getRegisteredServiceNames();
            if (tmp != null && !tmp.isEmpty()) {
                names = new HashMap<String, String>(tmp.size() * 2);
                AMViewConfig viewConfig = AMViewConfig.getInstance();
                Iterator iter = tmp.iterator();
                while (iter.hasNext()) {
                    String displayName;
                    String name = (String)iter.next();
                    if (!viewConfig.isServiceVisible(name) || name.equals(displayName = this.getLocalizedServiceName(name))) continue;
                    names.put(name, displayName);
                }
            }
            this.logEvent("SUCCEED_DIR_MGR_GET_ASSIGNED_SERVICE_TO_ORG", param);
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{location, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_ASSIGNED_SERVICE_TO_ORG", paramsEx);
            debug.warning("OrganizationModel.getAssignedServices", (Throwable)((Object)e));
        }
        catch (AMException e) {
            String[] paramsEx = new String[]{location, this.getErrorString(e)};
            this.logEvent("AM_EXCEPTION_DIR_MGR_GET_ASSIGNED_SERVICE_TO_ORG", paramsEx);
            debug.warning("OrganizationModel.getAssignedServices", (Throwable)e);
        }
        return names == null ? Collections.EMPTY_MAP : names;
    }

    public void removeServices(String location, Set services) throws AMConsoleException {
        if (services == null || services.isEmpty()) {
            throw new AMConsoleException("no.entries.selected");
        }
        if (location == null || location.length() == 0) {
            throw new AMConsoleException("system.error");
        }
        AMOrganization org = null;
        try {
            org = this.getAMStoreConnection().getOrganization(location);
        }
        catch (SSOException ssoe) {
            debug.warning("UMOrganizationModelImpl.removeServices", (Throwable)((Object)ssoe));
        }
        if (org == null) {
            throw new AMConsoleException("invalid.organization.entry");
        }
        String[] params = new String[2];
        params[0] = location;
        String currentName = "";
        Iterator i = services.iterator();
        while (i.hasNext()) {
            try {
                String name;
                currentName = name = (String)i.next();
                params[1] = name;
                this.logEvent("ATTEMPT_DIR_MGR_REMOVE_SERVICES_FROM_ORG", params);
                org.unregisterService(name);
                this.logEvent("SUCCEED_DIR_MGR_REMOVE_SERVICES_FROM_ORG", params);
            }
            catch (SSOException e) {
                String strError = this.getErrorString((Throwable)((Object)e));
                String[] paramsEx = new String[]{location, currentName, strError};
                this.logEvent("SSO_EXCEPTION_DIR_MGR_REMOVE_SERVICES_FROM_ORG", paramsEx);
                debug.warning("UMOrganizationModel.removeServices", (Throwable)((Object)e));
                throw new AMConsoleException(strError);
            }
            catch (AMException e) {
                String strError = this.getErrorString(e);
                String[] paramsEx = new String[]{location, currentName, strError};
                this.logEvent("AM_EXCEPTION_DIR_MGR_REMOVE_SERVICES_FROM_ORG", paramsEx);
                debug.warning("UMOrganizationModel.removeServices", (Throwable)e);
                throw new AMConsoleException(strError);
            }
        }
    }

    public Set getOrganizations(String location, String filter) {
        if (location == null) {
            location = this.getStartDSDN();
        }
        AMSearchResults results = null;
        AMSearchControl searchControl = new AMSearchControl();
        this.setSearchControlAttributes(location, "Organization", 2, searchControl, "organizations");
        this.setSearchControlLimits(searchControl);
        try {
            String[] params = new String[]{location, filter};
            this.logEvent("ATTEMPT_DIR_MGR_SEARCH_ORG_IN_ORG", params);
            AMOrganization org = this.getAMStoreConnection().getOrganization(location);
            results = this.getOrganizations(org, filter, searchControl);
            this.logEvent("SUCCEED_DIR_MGR_SEARCH_ORG_IN_ORG", params);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{location, filter, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_SEARCH_ORG_IN_ORG", paramsEx);
            debug.warning("UMOrganizationModelImpl.getOrganizations", (Throwable)((Object)e));
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{location, filter, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_SEARCH_ORG_IN_ORG", paramsEx);
            debug.warning("UMOrganizationModelImpl.getOrganizations", (Throwable)e);
        }
        return this.setSearchResults(results);
    }

    private AMSearchResults getOrganizations(AMOrganization parent, String wildcard, AMSearchControl searchControl) throws AMException, SSOException {
        searchControl.setSearchScope(2);
        String[] sortKeys = new String[]{AdminInterfaceUtils.getNamingAttribute(2, debug)};
        searchControl.setSortKeys(sortKeys);
        return parent.searchSubOrganizations(wildcard, searchControl);
    }

    public void updateOrganization(String name, Map raw) throws AMConsoleException {
        Map data = this.removeEmptyValueInMap(raw);
        this.validateRequiredAttributes(data);
        String[] param = new String[]{name};
        this.logEvent("ATTEMPT_DIR_MGR_MODIFY_ORGANIZATION", param);
        try {
            AMOrganization ao = this.getAMStoreConnection().getOrganization(name);
            ao.setAttributes(data);
            ao.store();
            this.logEvent("SUCCEED_DIR_MGR_MODIFY_ORGANIZATION", param);
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{name, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_MODIFY_ORGANIZATION", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{name, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_MODIFY_ORGANIZATION", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private Map removeEmptyValueInMap(Map raw) {
        HashMap<String, Set> data = new HashMap<String, Set>(raw.size() * 2);
        Iterator i = raw.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Set values = (Set)raw.get(key);
            if (values == null || values.isEmpty()) continue;
            if (values.size() == 1) {
                String val = (String)values.iterator().next();
                if (val.trim().length() == 0) {
                    data.put(key, Collections.EMPTY_SET);
                    continue;
                }
                data.put(key, values);
                continue;
            }
            data.put(key, values);
        }
        return data;
    }

    public void createOrganization(String location, String name, Map raw) throws AMConsoleException {
        if (raw == null || raw.isEmpty()) {
            debug.warning("null or missing data values");
            throw new AMConsoleException(this.getLocalizedString("createFailure.message"));
        }
        if (name == null || name.length() == 0) {
            throw new AMConsoleException(this.getLocalizedString("createFailure.message"));
        }
        if (location == null) {
            location = this.getStartDSDN();
        }
        if (debug.messageEnabled()) {
            debug.message("trying to create suborganization with " + raw);
        }
        Map data = this.removeEmptyValueInMap(raw);
        this.validateRequiredAttributes(data);
        HashMap<String, Map> input = new HashMap<String, Map>(2);
        input.put(name, data);
        String[] params = new String[]{location, name};
        this.logEvent("ATTEMPT_DIR_MGR_CREATE_ORG_IN_ORG", params);
        String createdObj = AdminInterfaceUtils.getNamingAttribute(2, AMModelBase.debug) + "=" + name + "," + location;
        try {
            int type = this.getObjectType(location);
            if (type == 2) {
                AMOrganization parent = this.getAMStoreConnection().getOrganization(location);
                parent.createSubOrganizations(input);
                this.logEvent("SUCCEED_DIR_MGR_CREATE_ORG_IN_ORG", params);
            } else if (type == 3) {
                AMOrganizationalUnit parent = this.getAMStoreConnection().getOrganizationalUnit(location);
                parent.createOrganizations(input);
                this.logEvent("SUCCEED_DIR_MGR_CREATE_ORG_IN_ORG", params);
            } else if (debug.warningEnabled()) {
                debug.warning("UMOrganizationModel.createOrganization: current location invalid for create, " + location);
            }
        }
        catch (AMException e) {
            if (debug.warningEnabled()) {
                debug.warning("UMCreateOrgModelImpl.createOrganization " + e.getMessage());
            }
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{location, name, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_CREATE_ORG_IN_ORG", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{location, name, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_CREATE_ORG_IN_ORG", paramsEx);
            debug.error("UMOrganizationModelImpl.createOrganization", (Throwable)((Object)e));
        }
    }

    public Map getValues(String name) throws AMConsoleException {
        Map map = null;
        try {
            String[] param = new String[]{name};
            this.logEvent("ATTEMPT_DIR_MGR_GET_ORG_ATTR_VALUES", param);
            AMOrganization ao = this.getAMStoreConnection().getOrganization(name);
            map = this.correctAttributeNameCase(ao.getAttributes());
            this.logEvent("SUCCEED_DIR_MGR_GET_ORG_ATTR_VALUES", param);
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{name, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_GET_ORG_ATTR_VALUES", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{name, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_GET_ORG_ATTR_VALUES", paramsEx);
            throw new AMConsoleException(strError);
        }
        return map == null ? Collections.EMPTY_MAP : map;
    }

    private Map correctAttributeNameCase(Map map) {
        HashMap corrected = null;
        if (map != null && !map.isEmpty()) {
            corrected = new HashMap(map.size() * 2);
            Map dataMap = this.getDataMap();
            Iterator i = dataMap.keySet().iterator();
            while (i.hasNext()) {
                String attrName = (String)i.next();
                Object values = map.get(attrName.toLowerCase());
                if (values == null) {
                    values = Collections.EMPTY_SET;
                }
                map.put(attrName, values);
                corrected.put(attrName, values);
            }
        }
        return corrected;
    }

    public Map getDataMap() {
        HashMap<String, Set> map = new HashMap<String, Set>();
        try {
            ServiceSchema sub = this.getSubSchema("iPlanetAMEntrySpecificService", SchemaType.GLOBAL, ORGANIZATION);
            Set attrSchemas = sub.getAttributeSchemas();
            Iterator iter = attrSchemas.iterator();
            while (iter.hasNext()) {
                AttributeSchema as = (AttributeSchema)iter.next();
                map.put(as.getName(), Collections.EMPTY_SET);
            }
        }
        catch (SMSException e) {
            debug.error("OrganizationModelImpl.getDataMap", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("OrganizationModelImpl.getDataMap", (Throwable)((Object)e));
        }
        return map;
    }

    public String getCreateOrganizationPropertyXML() throws AMConsoleException {
        StringBuffer buff = new StringBuffer(2000);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n").append(PROPERTY_SECTION_CREATION_GENERAL);
        this.getPropertyXML(buff, false);
        buff.append("</propertysheet>\n");
        return buff.toString();
    }

    public String getOrganizationProfileXML(String realmName, String viewbeanClassName) throws AMConsoleException {
        DelegationConfig dConfig = DelegationConfig.getInstance();
        boolean canModify = dConfig.hasPermission(realmName, null, "MODIFY", this, viewbeanClassName);
        StringBuffer buff = new StringBuffer(2000);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n");
        this.getPropertyXML(buff, !canModify);
        buff.append("</propertysheet>\n");
        return buff.toString();
    }

    private void getPropertyXML(StringBuffer buff, boolean readonly) throws AMConsoleException {
        try {
            ServiceSchema sub = this.getSubSchema("iPlanetAMEntrySpecificService", SchemaType.GLOBAL, "Organization");
            PropertyXMLBuilder xmlBuilder = new PropertyXMLBuilder(sub, this);
            xmlBuilder.setAllAttributeReadOnly(readonly);
            buff.append(xmlBuilder.getXML(false));
            this.setMandatoryAttributes(xmlBuilder.getAttributeSchemas());
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void registerService(String organization, String service) throws AMConsoleException {
        if (debug.messageEnabled()) {
            debug.message("OrganizationImpl:registerService");
            debug.message("registering " + service + " to " + organization);
        }
        String[] params = new String[]{organization, service};
        this.logEvent("ATTEMPT_DIR_MGR_ADD_SERVICE_TO_ORG", params);
        try {
            AMOrganization org = this.getAMStoreConnection().getOrganization(organization);
            org.registerService(service, true, true);
            this.logEvent("SUCCEED_DIR_MGR_ADD_SERVICE_TO_ORG", params);
        }
        catch (AMException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{organization, service, strError};
            this.logEvent("AM_EXCEPTION_DIR_MGR_ADD_SERVICE_TO_ORG", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{organization, service, strError};
            this.logEvent("SSO_EXCEPTION_DIR_MGR_ADD_SERVICE_TO_ORG", paramsEx);
            throw new AMConsoleException(strError);
        }
    }
}

