/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.policy.ConditionOpViewBeanBase;
import com.sun.web.ui.view.html.CCDropDownMenu;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class TimeConditionHelper {
    public static final String STARTDATE = "StartDate";
    public static final String ENDDATE = "EndDate";
    public static final String STARTHOUR = "StartHour";
    public static final String STARTMINUTE = "StartMinute";
    public static final String STARTSESSION = "StartSession";
    public static final String ENDHOUR = "EndHour";
    public static final String ENDMINUTE = "EndMinute";
    public static final String ENDSESSION = "EndSession";
    public static final String STARTDAY = "StartDay";
    public static final String ENDDAY = "EndDay";
    public static final String STANDARDTIMEZONE = "StandardTimeZone";
    public static final String CUSTOMTIMEZONE = "CustomTimeZone";
    public static final String RADIOTIMEZONE = "radioTimeZone";
    private static String DATE_FORMAT = "MM/dd/yyyy";
    private static final String PLUGIN_DATE_FORMAT = "yyyy:MM:dd";
    private static TimeConditionHelper instance = new TimeConditionHelper();

    private TimeConditionHelper() {
    }

    public static TimeConditionHelper getInstance() {
        return instance;
    }

    public String getConditionXML(boolean bCreate, boolean readonly) {
        String xml = null;
        xml = bCreate ? "com/sun/identity/console/propertyPMConditionTime.xml" : (readonly ? "com/sun/identity/console/propertyPMConditionTime_Readonly.xml" : "com/sun/identity/console/propertyPMConditionTime.xml");
        return AMAdminUtils.getStringFromInputStream(this.getClass().getClassLoader().getResourceAsStream(xml));
    }

    public String getMissingValuesMessage() {
        return "policy.condition.missing.time.condition.value";
    }

    public void setTimeZoneOptions(boolean canModify, ConditionOpViewBeanBase viewBean, AMModel model) {
        if (canModify) {
            CCDropDownMenu list = (CCDropDownMenu)viewBean.getChild(STANDARDTIMEZONE);
            OptionList optList = new OptionList();
            String[] ids = TimeZone.getAvailableIDs();
            HashSet<String> set = new HashSet<String>(ids.length * 2);
            HashMap<String, String> map = new HashMap<String, String>(ids.length * 2);
            for (int i = 0; i < ids.length; ++i) {
                String displayName = model.getLocalizedString(ids[i]);
                set.add(displayName);
                map.put(displayName, ids[i]);
            }
            List sorted = AMFormatUtils.sortItems(set, model.getUserLocale());
            Iterator iter = sorted.iterator();
            while (iter.hasNext()) {
                String displayName = (String)iter.next();
                optList.add(displayName, (String)map.get(displayName));
            }
            list.setOptions(optList);
        }
    }

    public Map getConditionValues(ConditionOpViewBeanBase viewBean, Map values) {
        HashMap map = new HashMap(values);
        if (this.getDateTime(viewBean, STARTDATE, true, map) && this.getDateTime(viewBean, ENDDATE, false, map)) {
            this.copyStartToEndIfEndIsMissing(map, STARTDATE, ENDDATE);
            if (this.getTime(viewBean, true, map) && this.getTime(viewBean, false, map)) {
                this.copyStartToEndIfEndIsMissing(map, "StartTime", "EndTime");
                this.getDay(viewBean, true, map);
                this.getDay(viewBean, false, map);
                this.copyStartToEndIfEndIsMissing(map, STARTDAY, ENDDAY);
                if (!this.getTimeZoneValue(viewBean, map)) {
                    map = null;
                }
            } else {
                map = null;
            }
        } else {
            map = null;
        }
        return map;
    }

    private void copyStartToEndIfEndIsMissing(Map map, String startAttrName, String endAttrName) {
        Set startSet = (Set)map.get(startAttrName);
        Set endSet = (Set)map.get(endAttrName);
        if (startSet != null && endSet == null) {
            map.put(endAttrName, startSet);
        } else if (endSet != null && startSet == null) {
            map.put(startAttrName, endSet);
        }
    }

    private boolean getDateTime(ConditionOpViewBeanBase viewBean, String childName, boolean bStart, Map values) {
        boolean valid = false;
        AMPropertySheetModel propModel = viewBean.getPropertySheetModel();
        String date = (String)propModel.getValue(childName);
        String formatedDate = this.getDateTime(viewBean, date, bStart);
        if (formatedDate != null) {
            if (formatedDate.length() > 0) {
                HashSet<String> set = new HashSet<String>(2);
                set.add(formatedDate);
                values.put(childName, set);
            }
            valid = true;
        }
        return valid;
    }

    private void getDay(ConditionOpViewBeanBase viewBean, boolean bStart, Map values) {
        String day;
        AMPropertySheetModel propModel = viewBean.getPropertySheetModel();
        String string = day = bStart ? (String)propModel.getValue(STARTDAY) : (String)propModel.getValue(ENDDAY);
        if (day.length() > 0) {
            HashSet<String> set = new HashSet<String>();
            set.add(day);
            values.put(bStart ? STARTDAY : ENDDAY, set);
        }
    }

    private boolean getTime(ConditionOpViewBeanBase viewBean, boolean bStart, Map values) {
        boolean valid;
        block6: {
            AMPropertySheetModel propModel = viewBean.getPropertySheetModel();
            valid = false;
            String hours = bStart ? (String)propModel.getValue(STARTHOUR) : (String)propModel.getValue(ENDHOUR);
            String minutes = bStart ? (String)propModel.getValue(STARTMINUTE) : (String)propModel.getValue(ENDMINUTE);
            String session = bStart ? (String)propModel.getValue(STARTSESSION) : (String)propModel.getValue(ENDSESSION);
            hours = hours.trim();
            minutes = minutes.trim();
            if (hours.length() > 0 && minutes.length() > 0) {
                try {
                    int hr = Integer.parseInt(hours);
                    int mm = Integer.parseInt(minutes);
                    if (session.equals("pm") && hr < 12) {
                        hr += 12;
                    }
                    if (hr >= 0 && hr <= 23 && mm >= 0 && mm <= 59) {
                        hours = hr < 10 ? "0" + hr : Integer.toString(hr);
                        minutes = mm < 10 ? "0" + mm : Integer.toString(mm);
                        HashSet<String> set = new HashSet<String>();
                        set.add(hours + ":" + minutes);
                        values.put(bStart ? "StartTime" : "EndTime", set);
                        valid = true;
                        break block6;
                    }
                    viewBean.setErrorMessage(bStart ? "policy.condition.time.invalid.starttime" : "policy.condition.time.invalid.endtime");
                }
                catch (NumberFormatException e) {
                    viewBean.setErrorMessage(bStart ? "policy.condition.time.invalid.starttime" : "policy.condition.time.invalid.endtime");
                }
            } else {
                valid = true;
            }
        }
        return valid;
    }

    private String formatDate(String strDate) {
        String formatedDate = "";
        if (strDate != null && strDate.trim().length() > 0) {
            SimpleDateFormat dff = new SimpleDateFormat(PLUGIN_DATE_FORMAT);
            dff.setLenient(false);
            try {
                Date date = dff.parse(strDate);
                SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                df.setLenient(false);
                formatedDate = df.format(date);
            }
            catch (ParseException e) {
                AMModelBase.debug.warning("TimeConditionHelper.formatDate", (Throwable)e);
            }
        }
        return formatedDate;
    }

    public String getDateTime(ConditionOpViewBeanBase viewBean, String strDate, boolean bStart) {
        String formatedDate = "";
        if (strDate != null && strDate.trim().length() > 0) {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            df.setLenient(false);
            try {
                Date date = df.parse(strDate);
                SimpleDateFormat dff = new SimpleDateFormat(PLUGIN_DATE_FORMAT);
                formatedDate = dff.format(date);
            }
            catch (ParseException e) {
                AMModelBase.debug.warning("TimeConditionHelper.getDateTime", (Throwable)e);
                viewBean.setErrorMessage(bStart ? "policy.condition.time.invalid.startdate" : "policy.condition.time.invalid.enddate");
                formatedDate = null;
            }
        }
        return formatedDate;
    }

    private boolean getTimeZoneValue(ConditionOpViewBeanBase viewBean, Map values) {
        boolean valid = false;
        AMPropertySheetModel propModel = viewBean.getPropertySheetModel();
        String radio = (String)propModel.getValue(RADIOTIMEZONE);
        if (radio != null && radio.length() > 0) {
            String tz = null;
            if (radio.equals("standard")) {
                tz = (String)propModel.getValue(STANDARDTIMEZONE);
                valid = true;
            } else {
                tz = (String)propModel.getValue(CUSTOMTIMEZONE);
                if (!this.isValidTimeZone(tz)) {
                    viewBean.setErrorMessage("policy.condition.time.invalid.timezone");
                } else {
                    valid = true;
                }
            }
            if (valid) {
                HashSet<String> set = new HashSet<String>();
                set.add(tz);
                values.put("EnforcementTimeZone", set);
            }
        } else {
            valid = true;
        }
        return valid;
    }

    public void setDay(ConditionOpViewBeanBase viewBean, boolean bStart, String strDay) {
        if (strDay != null && strDay.length() > 0) {
            AMPropertySheetModel propModel = viewBean.getPropertySheetModel();
            propModel.setValue(bStart ? STARTDAY : ENDDAY, strDay);
        }
    }

    public void setDate(ConditionOpViewBeanBase viewBean, boolean bStart, String strDate, AMModel model) {
        DATE_FORMAT = model.getLocalizedString("policy.condition.time.dateformat");
        if (DATE_FORMAT == null || DATE_FORMAT.length() == 0) {
            DATE_FORMAT = "MM/dd/yyyy";
        }
        AMPropertySheetModel propModel = viewBean.getPropertySheetModel();
        propModel.setValue(bStart ? STARTDATE : ENDDATE, this.formatDate(strDate));
    }

    public void setTime(ConditionOpViewBeanBase viewBean, boolean bStart, String strTime) {
        int idx = strTime.indexOf(":");
        if (idx != -1) {
            String hours = strTime.substring(0, idx);
            String minutes = strTime.substring(idx + 1);
            try {
                boolean ampm;
                int hr = Integer.parseInt(hours);
                int mm = Integer.parseInt(minutes);
                boolean bl = ampm = hr >= 12;
                if (ampm && hr > 12) {
                    hr -= 12;
                }
                AMPropertySheetModel propModel = viewBean.getPropertySheetModel();
                propModel.setValue(bStart ? STARTHOUR : ENDHOUR, Integer.toString(hr));
                propModel.setValue(bStart ? STARTMINUTE : ENDMINUTE, Integer.toString(mm));
                propModel.setValue(bStart ? STARTSESSION : ENDSESSION, ampm ? "pm" : "am");
            }
            catch (NumberFormatException e) {
                AMModelBase.debug.error("TimeConditionHelper.setTime", (Throwable)e);
            }
        }
    }

    public void setTimeZone(ConditionOpViewBeanBase viewBean, boolean canModify, String tz) {
        if (tz != null && tz.trim().length() > 0) {
            AMPropertySheetModel propModel = viewBean.getPropertySheetModel();
            if (canModify) {
                CCDropDownMenu list = (CCDropDownMenu)viewBean.getChild(STANDARDTIMEZONE);
                OptionList optList = list.getOptions();
                if (optList != null && optList.hasValue(tz)) {
                    propModel.setValue(STANDARDTIMEZONE, tz);
                    propModel.setValue(RADIOTIMEZONE, "standard");
                } else {
                    propModel.setValue(CUSTOMTIMEZONE, tz);
                    propModel.setValue(RADIOTIMEZONE, "custom");
                }
            } else {
                String[] ids = TimeZone.getAvailableIDs();
                boolean contains = false;
                for (int i = 0; i < ids.length && !contains; ++i) {
                    contains = ids[i].equals(tz);
                }
                if (contains) {
                    propModel.setValue(STANDARDTIMEZONE, tz);
                    propModel.setValue(RADIOTIMEZONE, "standard");
                } else {
                    propModel.setValue(CUSTOMTIMEZONE, tz);
                    propModel.setValue(RADIOTIMEZONE, "custom");
                }
            }
        }
    }

    private boolean isValidTimeZone(String tz) {
        TimeZone t;
        String id;
        boolean valid = false;
        valid = tz == null || tz.trim().length() == 0 ? true : (id = (t = TimeZone.getTimeZone(tz)).getID()).equals(tz) || id.equals(TimeZone.getTimeZone("GMT+10:00").getID());
        return valid;
    }
}

