/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.services.util.Crypt;
import com.sun.identity.common.configuration.ServerConfigXML;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.service.ServerConfigXMLAddServerViewBean;
import com.sun.identity.console.service.ServerSiteViewBean;
import com.sun.identity.console.service.model.ServerSiteModel;
import com.sun.identity.console.service.model.ServerSiteModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ServerConfigXMLViewBean
extends AMPrimaryMastHeadViewBean {
    private static final String DEFAULT_DISPLAY_URL = "/console/service/ServerConfigXML.jsp";
    private static final String PGTITLE_THREE_BTNS = "pgtitleThreeBtns";
    private static final String SZ_CACHE_SERVER = "szCache1";
    private static final String SZ_CACHE_USER = "szCache2";
    private static final String TBL_SERVERS = "tblServers";
    private static final String TF_SERVER_MIN_POOL = "tfserverminpool";
    private static final String TF_SERVER_MAX_POOL = "tfservermaxpool";
    private static final String TBL_SERVERS_COL_HOST = "tblServerConfigXMLServerColHost";
    private static final String TBL_SERVERS_COL_NAME = "tblServerConfigXMLServerColName";
    private static final String TBL_SERVERS_COL_PORT = "tblServerConfigXMLServerColPort";
    private static final String TBL_SERVERS_COL_TYPE = "tblServerConfigXMLServerColType";
    private static final String TBL_SERVERS_NAME_DATA = "tblServerConfigXMLNameDataServer";
    private static final String TBL_SERVERS_HOST_DATA = "tblServerConfigXMLHostDataServer";
    private static final String TBL_SERVERS_PORT_DATA = "tblServerConfigXMLServerDataPort";
    private static final String TBL_SERVERS_TYPE_DATA = "tblServerConfigXMLServerDataType";
    private static final String TBL_USERS = "tblUsers";
    private static final String TF_USER_MIN_POOL = "tfuserminpool";
    private static final String TF_USER_MAX_POOL = "tfusermaxpool";
    private static final String TBL_USERS_COL_NAME = "tblServerConfigXMLUserColName";
    private static final String TBL_USERS_COL_HOST = "tblServerConfigXMLUserColHost";
    private static final String TBL_USERS_COL_PORT = "tblServerConfigXMLUserColPort";
    private static final String TBL_USERS_COL_TYPE = "tblServerConfigXMLUserColType";
    private static final String TBL_USERS_NAME_DATA = "tblServerConfigXMLNameDataUser";
    private static final String TBL_USERS_HOST_DATA = "tblServerConfigXMLHostDataUser";
    private static final String TBL_USERS_PORT_DATA = "tblServerConfigXMLUserDataPort";
    private static final String TBL_USERS_TYPE_DATA = "tblServerConfigXMLUserDataType";
    private static final String TF_USERS_BIND_DN = "tfbinddn";
    private static final String TF_USERS_BIND_PWD = "tfbindpwd";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private CCPageTitleModel ptModel;
    private AMPropertySheetModel propertySheetModel;
    private CCActionTableModel tblServerModel;
    private CCActionTableModel tblUserModel;
    private boolean submitCycle;
    private boolean bAMSDKEnabled;

    public ServerConfigXMLViewBean() {
        super("ServerConfigXML");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String serverName;
        if (!this.initialized && (serverName = (String)this.getPageSessionAttribute("pgAttrServerName")) != null) {
            super.initialize();
            this.bAMSDKEnabled = this.getModel().isAMSDKEnabled();
            this.createPageTitleModel();
            this.createTabModel();
            this.createPropertyModel(serverName);
            this.createTableModel();
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(SZ_CACHE_SERVER, SerializedField.class);
        this.registerChild(SZ_CACHE_USER, SerializedField.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE_THREE_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.registerChild(TBL_SERVERS, CCActionTable.class);
        this.registerChild(TBL_USERS, CCActionTable.class);
        this.tblServerModel.registerChildren((ContainerViewBase)this);
        this.tblUserModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SERVERS)) {
            SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_SERVER);
            this.populateServerTableModel((List)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblServerModel, name);
        } else if (name.equals(TBL_USERS)) {
            SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_USER);
            this.populateUserTableModel((List)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblUserModel, name);
        } else {
            view = name.equals(PGTITLE_THREE_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (this.tblServerModel.isChildSupported(name) ? this.tblServerModel.createChild((View)this, name) : (this.tblUserModel.isChildSupported(name) ? this.tblUserModel.createChild((View)this, name) : super.createChild(name))))));
        }
        return view;
    }

    private void createTableModel() {
        this.tblServerModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblServerConfigXMLServers.xml"));
        this.tblServerModel.setTitleLabel("label.items");
        this.tblServerModel.setActionValue(TBL_SERVERS_COL_NAME, (Object)"amconfig.serverconfig.xml.server.table.column.name");
        this.tblServerModel.setActionValue(TBL_SERVERS_COL_HOST, (Object)"amconfig.serverconfig.xml.server.table.column.host");
        this.tblServerModel.setActionValue(TBL_SERVERS_COL_PORT, (Object)"amconfig.serverconfig.xml.server.table.column.port");
        this.tblServerModel.setActionValue(TBL_SERVERS_COL_TYPE, (Object)"amconfig.serverconfig.xml.server.table.column.type");
        this.propertySheetModel.setModel(TBL_SERVERS, this.tblServerModel);
        this.tblUserModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblServerConfigXMLUsers.xml"));
        this.tblUserModel.setTitleLabel("label.items");
        this.tblUserModel.setActionValue(TBL_USERS_COL_NAME, (Object)"amconfig.serverconfig.xml.user.table.column.name");
        this.tblUserModel.setActionValue(TBL_USERS_COL_HOST, (Object)"amconfig.serverconfig.xml.user.table.column.host");
        this.tblUserModel.setActionValue(TBL_USERS_COL_PORT, (Object)"amconfig.serverconfig.xml.user.table.column.port");
        this.tblUserModel.setActionValue(TBL_USERS_COL_TYPE, (Object)"amconfig.serverconfig.xml.user.table.column.type");
        this.propertySheetModel.setModel(TBL_USERS, this.tblUserModel);
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new ServerSiteModelImpl(req, this.getPageSessionAttributes());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        this.ptModel.setPageTitleText(model.getEditServerPageTitle(serverName));
        try {
            this.setConfigProperties(serverName, model);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void setConfigProperties(String serverName, ServerSiteModel model) throws AMConsoleException {
        if (!this.submitCycle) {
            ServerConfigXML xmlObj = model.getServerConfigObject(serverName);
            ServerConfigXML.ServerGroup defaultServerGroup = xmlObj.getDefaultServerGroup();
            ServerConfigXML.ServerGroup smsServerGroup = xmlObj.getSMSServerGroup();
            this.propertySheetModel.setValue(TF_SERVER_MIN_POOL, Integer.toString(defaultServerGroup.minPool));
            this.propertySheetModel.setValue(TF_SERVER_MAX_POOL, Integer.toString(defaultServerGroup.maxPool));
            this.propertySheetModel.setValue(TF_USER_MIN_POOL, Integer.toString(smsServerGroup.minPool));
            this.propertySheetModel.setValue(TF_USER_MAX_POOL, Integer.toString(smsServerGroup.maxPool));
            List bindInfo = smsServerGroup.dsUsers;
            if (!bindInfo.isEmpty()) {
                ServerConfigXML.DirUserObject bind = (ServerConfigXML.DirUserObject)bindInfo.iterator().next();
                this.propertySheetModel.setValue(TF_USERS_BIND_DN, bind.dn);
                this.propertySheetModel.setValue(TF_USERS_BIND_PWD, Crypt.decrypt((String)bind.password));
            }
            this.populateServerTableModel(defaultServerGroup.hosts);
            this.populateUserTableModel(smsServerGroup.hosts);
        }
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    protected void createTabModel() {
        if (this.tabModel == null) {
            AMViewConfig amconfig = AMViewConfig.getInstance();
            this.tabModel = amconfig.getTabsModel("cscGeneral", "/", this.getRequestContext().getRequest());
            this.registerChild("tabCommon", CCTabs.class);
        }
    }

    private void createPropertyModel(String serverName) {
        String fileName = this.bAMSDKEnabled ? "com/sun/identity/console/propertyServerConfigXMLWithAMSDK.xml" : "com/sun/identity/console/propertyServerConfigXML.xml";
        String xml = AMAdminUtils.getStringFromInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName));
        this.propertySheetModel = new AMPropertySheetModel(xml);
        this.propertySheetModel.clear();
    }

    private void populateServerTableModel(List entries) {
        if (this.bAMSDKEnabled) {
            this.tblServerModel.clearAll();
            SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_SERVER);
            int counter = 0;
            if (entries != null && !entries.isEmpty()) {
                Iterator i = entries.iterator();
                while (i.hasNext()) {
                    if (counter > 0) {
                        this.tblServerModel.appendRow();
                    }
                    ServerConfigXML.ServerObject entry = (ServerConfigXML.ServerObject)i.next();
                    this.tblServerModel.setValue(TBL_SERVERS_NAME_DATA, (Object)entry.name);
                    this.tblServerModel.setValue(TBL_SERVERS_HOST_DATA, (Object)entry.host);
                    this.tblServerModel.setValue(TBL_SERVERS_PORT_DATA, (Object)entry.port);
                    this.tblServerModel.setValue(TBL_SERVERS_TYPE_DATA, (Object)entry.type);
                    this.tblServerModel.setSelectionVisible(counter, true);
                    ++counter;
                }
            }
            szCache.setValue(entries);
        }
    }

    private void populateUserTableModel(List entries) {
        this.tblUserModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild(SZ_CACHE_USER);
        int counter = 0;
        if (entries != null && !entries.isEmpty()) {
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                if (counter > 0) {
                    this.tblUserModel.appendRow();
                }
                ServerConfigXML.ServerObject entry = (ServerConfigXML.ServerObject)i.next();
                this.tblUserModel.setValue(TBL_USERS_NAME_DATA, (Object)entry.name);
                this.tblUserModel.setValue(TBL_USERS_HOST_DATA, (Object)entry.host);
                this.tblUserModel.setValue(TBL_USERS_PORT_DATA, (Object)entry.port);
                this.tblUserModel.setValue(TBL_USERS_TYPE_DATA, (Object)entry.type);
                this.tblUserModel.setSelectionVisible(counter, true);
                ++counter;
            }
        }
        szCache.setValue(entries);
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        this.submitCycle = true;
        String userMinPool = (String)this.getDisplayFieldValue(TF_USER_MIN_POOL);
        String userMaxPool = (String)this.getDisplayFieldValue(TF_USER_MAX_POOL);
        String bindDN = (String)this.getDisplayFieldValue(TF_USERS_BIND_DN);
        String bindPwd = (String)this.getDisplayFieldValue(TF_USERS_BIND_PWD);
        String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        try {
            ServerConfigXML xmlObj = model.getServerConfigObject(serverName);
            ServerConfigXML.ServerGroup smsServerGroup = xmlObj.getSMSServerGroup();
            if (this.bAMSDKEnabled) {
                String serverMinPool = (String)this.getDisplayFieldValue(TF_SERVER_MIN_POOL);
                String serverMaxPool = (String)this.getDisplayFieldValue(TF_SERVER_MAX_POOL);
                ServerConfigXML.ServerGroup defaultServerGroup = xmlObj.getDefaultServerGroup();
                defaultServerGroup.minPool = Integer.parseInt(serverMinPool);
                defaultServerGroup.maxPool = Integer.parseInt(serverMaxPool);
            }
            smsServerGroup.minPool = Integer.parseInt(userMinPool);
            smsServerGroup.maxPool = Integer.parseInt(userMaxPool);
            List userGroup = smsServerGroup.dsUsers;
            ServerConfigXML.DirUserObject bind = (ServerConfigXML.DirUserObject)userGroup.iterator().next();
            bind.dn = bindDN;
            bind.password = Crypt.encode((String)bindPwd);
            model.setServerConfigXML(serverName, xmlObj.toXML());
            this.setInlineAlertMessage("info", "message.information", model.getLocalizedString("serverconfig.updated"));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        catch (NumberFormatException e) {
            this.setInlineAlertMessage("error", "message.error", model.getLocalizedString("exception.thread.pool.no.integer"));
        }
        this.forwardTo();
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleTblServerConfigXMLUserButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        try {
            ServerConfigXML xmlObj = model.getServerConfigObject(serverName);
            ServerConfigXML.ServerGroup smsServerGroup = xmlObj.getSMSServerGroup();
            CCActionTable table = (CCActionTable)this.getChild(TBL_USERS);
            table.restoreStateData();
            Integer[] selected = this.tblUserModel.getSelectedRows();
            if (selected.length >= smsServerGroup.hosts.size()) {
                this.setInlineAlertMessage("error", "message.error", model.getLocalizedString("exception.cannot,delete.all.servers"));
            } else {
                for (int i = selected.length - 1; i >= 0; --i) {
                    smsServerGroup.hosts.remove(selected[i]);
                }
                model.setServerConfigXML(serverName, xmlObj.toXML());
                this.setInlineAlertMessage("info", "message.information", "serverconfig.updated");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleTblServerConfigXMLServerButtonAddRequest(RequestInvocationEvent event) throws ModelControlException {
        ServerConfigXMLAddServerViewBean vb = (ServerConfigXMLAddServerViewBean)this.getViewBean(ServerConfigXMLAddServerViewBean.class);
        this.unlockPageTrail();
        vb.setPageSessionAttribute("pgAttrServerGroupType", (Serializable)((Object)"default"));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblServerConfigXMLUserButtonAddRequest(RequestInvocationEvent event) throws ModelControlException {
        ServerConfigXMLAddServerViewBean vb = (ServerConfigXMLAddServerViewBean)this.getViewBean(ServerConfigXMLAddServerViewBean.class);
        this.unlockPageTrail();
        vb.setPageSessionAttribute("pgAttrServerGroupType", (Serializable)((Object)"sms"));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblServerConfigXMLServerButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        try {
            ServerConfigXML xmlObj = model.getServerConfigObject(serverName);
            ServerConfigXML.ServerGroup defaultServerGroup = xmlObj.getDefaultServerGroup();
            CCActionTable table = (CCActionTable)this.getChild(TBL_SERVERS);
            table.restoreStateData();
            Integer[] selected = this.tblServerModel.getSelectedRows();
            if (selected.length >= defaultServerGroup.hosts.size()) {
                this.setInlineAlertMessage("error", "message.error", model.getLocalizedString("exception.cannot,delete.all.servers"));
            } else {
                for (int i = selected.length - 1; i >= 0; --i) {
                    defaultServerGroup.hosts.remove(selected[i]);
                }
                model.setServerConfigXML(serverName, xmlObj.toXML());
                this.setInlineAlertMessage("info", "message.information", "serverconfig.updated");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) throws ModelControlException {
        this.returnToHomePage();
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
        try {
            AMViewBeanBase vb = this.getTabNodeAssociatedViewBean("cscGeneral", nodeID);
            String tmp = (String)this.getPageSessionAttribute("PreviousTabID");
            vb.setPageSessionAttribute("PreviousTabID", (Serializable)((Object)tmp));
            this.unlockPageTrailForSwapping();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            debug.error("ServerEditGeneralViewBean.nodeClicked", (Throwable)e);
            this.forwardTo();
        }
    }

    private void returnToHomePage() {
        this.backTrail();
        ServerSiteViewBean vb = (ServerSiteViewBean)this.getViewBean(ServerSiteViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.editserver";
    }

    protected boolean startPageTrail() {
        return false;
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("page.title.serversite.config");
    }

    protected String removeParentSiteBlob(String xml) {
        return xml;
    }

    protected String getTrackingTabIDName() {
        return "CCTabs.serverConfig";
    }
}

