/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service.model;

import com.iplanet.sso.SSOException;
import com.sun.identity.common.configuration.ISubConfigNames;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.SubConfigMeta;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.property.SubConfigPropertyXMLBuilder;
import com.sun.identity.console.service.model.SubConfigModel;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class SubConfigModelImpl
extends AMModelBase
implements SubConfigModel {
    private SubConfigMeta subConfigMeta;
    private String serviceName;
    private String parentId;
    private SubConfigPropertyXMLBuilder xmlBuilder;
    private static Set SCHEMA_TYPE = new HashSet();

    public SubConfigModelImpl(HttpServletRequest req, String serviceName, String parentId, Map map) throws AMConsoleException {
        super(req, map);
        this.serviceName = serviceName;
        this.parentId = parentId;
        this.subConfigMeta = new SubConfigMeta(serviceName, this);
        this.subConfigMeta.setParentId(parentId);
    }

    public String getAddConfigPropertyXML(String name) throws AMConsoleException {
        try {
            this.xmlBuilder = new SubConfigPropertyXMLBuilder(this.serviceName, this.subConfigMeta.getServiceSchema(name), this);
            String xml = this.xmlBuilder.getXML();
            String attributeNameXML = this.getSelectableSubConfigNamesPlugin(name) != null ? AMAdminUtils.getStringFromInputStream(this.getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertySubConfigSelectableName.xml")) : AMAdminUtils.getStringFromInputStream(this.getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertySubConfigName.xml"));
            xml = SubConfigPropertyXMLBuilder.prependXMLProperty(xml, attributeNameXML);
            return xml;
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public String getEditConfigPropertyXML(String viewbeanClassName) throws AMConsoleException {
        DelegationConfig dConfig = DelegationConfig.getInstance();
        boolean canModify = dConfig.hasPermission("/", null, "MODIFY", this.getUserSSOToken(), viewbeanClassName);
        try {
            this.xmlBuilder = new SubConfigPropertyXMLBuilder(this.serviceName, this.subConfigMeta.getServiceSchema(), this);
            this.xmlBuilder.setSupportSubConfig(this.subConfigMeta.hasGlobalSubSchema());
            this.xmlBuilder.setViewBeanName("SubConfigEdit");
            if (!canModify) {
                this.xmlBuilder.setAllAttributeReadOnly(true);
            }
            return this.xmlBuilder.getXML();
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public Map getCreateableSubSchemaNames() {
        return this.subConfigMeta.getCreateableSubSchemaNames();
    }

    public Set getAttributeNames(String schemaName) {
        HashSet<String> names = null;
        Set attributeSchemas = this.xmlBuilder.getAttributeSchemas();
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            names = new HashSet<String>(attributeSchemas.size() * 2);
            Iterator i = attributeSchemas.iterator();
            while (i.hasNext()) {
                AttributeSchema as = (AttributeSchema)i.next();
                names.add(as.getName());
            }
        }
        return names != null ? names : Collections.EMPTY_SET;
    }

    public void createSubConfig(String name, String schemaName, Map values) throws AMConsoleException {
        if (name == null || name.trim().length() == 0) {
            throw new AMConsoleException("subconfig.missing.subconfiguration.name.message");
        }
        this.subConfigMeta.createSubConfig(name, schemaName, values);
    }

    public Map getSubConfigAttributeValues() throws AMConsoleException {
        return this.subConfigMeta.getSubConfigAttributeValues();
    }

    public void setSubConfigAttributeValues(Map values) throws AMConsoleException {
        this.subConfigMeta.setSubConfigAttributeValues(values);
    }

    public Map getServiceSchemaDefaultValues(String name) throws AMConsoleException {
        try {
            return this.subConfigMeta.getServiceSchemaDefaultValues(name);
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public boolean hasGlobalSubSchema() {
        return this.subConfigMeta.hasGlobalSubSchema();
    }

    public List getSubConfigurations() {
        return this.subConfigMeta.getSubConfigurations();
    }

    public void deleteSubConfigurations(Set names) throws AMConsoleException {
        this.subConfigMeta.deleteSubConfigurations(names);
    }

    public String getSelectableSubConfigNamesPlugin(String subSchemaName) {
        String plugin = null;
        ResourceBundle rb = ResourceBundle.getBundle("subConfigNamesPlugin");
        try {
            plugin = rb.getString(this.serviceName + "." + subSchemaName);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return plugin;
    }

    public Set getSelectableConfigNames(String subSchemaName) {
        TreeSet names = null;
        String plugin = this.getSelectableSubConfigNamesPlugin(subSchemaName);
        if (plugin != null) {
            try {
                Class<?> clazz = Class.forName(plugin);
                ISubConfigNames instance = (ISubConfigNames)clazz.newInstance();
                names = new TreeSet();
                names.addAll(instance.getNames());
            }
            catch (InstantiationException ex) {
                debug.error("SubConfigModelImpl.getSelectableConfigNames", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                debug.error("SubConfigModelImpl.getSelectableConfigNames", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                debug.error("SubConfigModelImpl.getSelectableConfigNames", (Throwable)ex);
            }
        }
        return names;
    }

    static {
        SCHEMA_TYPE.add(SchemaType.GLOBAL);
    }
}

