/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.ha.jmqdb.client;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sun.identity.ha.jmqdb.ConnectionFactoryProvider;
import com.sun.identity.ha.jmqdb.ConnectionFactoryProviderFactory;
import com.sun.identity.ha.jmqdb.client.BaseRecord;
import com.sun.identity.ha.jmqdb.client.CryptUtil;
import com.sun.identity.ha.jmqdb.client.DataAccessor;
import com.sun.identity.ha.jmqdb.client.FAMSFOPassword;
import com.sun.identity.ha.jmqdb.client.HaDBEnv;
import com.sun.messaging.ConnectionFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class FAMHaDB
implements Runnable {
    static FAMHaDB dbs;
    static boolean debug;
    public static final String READ = "READ";
    public static final String WRITE = "WRITE";
    public static final String DELETE = "DELETE";
    public static final String DELETEBYDATE = "DELETEBYDATE";
    public static final String SHUTDOWN = "SHUTDOWN";
    public static final String GET_RECORD_COUNT = "GET_RECORD_COUNT";
    public static final String NOT_FOUND = "notfound";
    public static final String OP_STATUS = "opstatus";
    public static final String DBREQUEST = "AM_DBREQUEST";
    public static final String DBRESPONSE = "AM_DRESPONSE";
    public static final String DBNODESTATUS = "AM_DBNODE_STATUS";
    public static final String SESSIONID = "SessionId";
    public static final String EXPIRYDATE = "ExpiryDate";
    public static final String DATA = "Data";
    public static final String RANDOM = "RANDOM";
    public static final String ID = "ID";
    private String _id;
    TopicConnectionFactory tFactory = null;
    TopicConnection tConn = null;
    TopicSession tSession = null;
    TopicSession tNodeSubSession = null;
    TopicSession tNodePubSession = null;
    Topic reqTopic = null;
    Topic resTopic = null;
    TopicSubscriber reqSub = null;
    TopicPublisher resPub = null;
    Topic dbNodeStatusSubTopic = null;
    Topic dbNodeStatusPubTopic = null;
    TopicSubscriber dbNodeStatusSub = null;
    TopicPublisher dbNodeStatusPub = null;
    private static long localStartTime;
    private static boolean isMasterNode;
    private static long localNodeID;
    private static Map serverStatusMap;
    private Thread nodeStatusSender;
    private Thread nodeStatusReceiver;
    private static long nodeUpdateInterval;
    private static long nodeUpdateGraceperiod;
    private DataAccessor da;
    private static HaDBEnv haDbEnv;
    private static File sessDbEnvPath;
    private int MAX_RESPONSE_QUEUES = 1;
    private String databaseFileName = "amsessions.db";
    private int flags = 0;
    private String userName = "guest";
    private String userPassword = "guest";
    private int cacheSize = 32;
    private String clusterAddress = null;
    private String dbDirectory = "sessiondb";
    private int numCleanSessions = 1000;
    private boolean verbose = false;
    private long statsInterval = 60000L;
    private boolean statsEnabled = false;
    private boolean deleteDatabase = true;
    private static Map arguments;
    private static final int INVALID = 0;
    private static final int USER_NAME = 1;
    private static final int PASSWORD = 2;
    private static final int PASSWORD_FILE = 3;
    private static final int CACHE_SIZE = 4;
    private static final int DIRECTORY = 5;
    private static final int CLUSTER_ADDRESS = 6;
    private static final int NUM_CLEAN_SESSIONS = 7;
    private static final int DELETE_DATABASE = 8;
    private static final int VERBOSE = 9;
    private static final int STATS_INTERVAL = 10;
    private static final int HELP = 11;
    private static final int VERSION = 12;
    private static final int NODE_STATUS_UPDATE_INTERVAL = 13;
    private static final int PROPERTIES_FILE = 14;
    private static ResourceBundle bundle;
    private static final String RESOURCE_BUNDLE = "amSessionDB";
    private static boolean isServerUp;
    private int sleepTime = 60000;
    private static int readCount;
    private static int writeCount;
    private static int deleteCount;
    private static int totalTrans;
    private static int scReadCount;
    private static final int SESSION_VALID = 1;
    private static PrintWriter statsWriter;
    private Thread processThread;
    private String propertiesfile = null;

    public FAMHaDB(String id) throws Exception {
        this._id = id;
    }

    private void initDB() throws Exception {
        block2: {
            try {
                haDbEnv.setup(sessDbEnvPath, false);
                this.da = new DataAccessor(haDbEnv.getEntityStore(), this.propertiesfile);
            }
            catch (DatabaseException dbe) {
                System.err.println("Error in creating session data accessor");
                System.err.println(dbe.getMessage());
                if (!this.verbose) break block2;
                dbe.printStackTrace();
            }
        }
    }

    private void initJMQ() throws Exception {
        ConnectionFactoryProvider provider = ConnectionFactoryProviderFactory.getProvider();
        this.tFactory = provider.newTopicConnectionFactory(this.clusterAddress, true, true, this.userName, this.userPassword);
        this.tConn = this.tFactory.createTopicConnection();
        this.tSession = this.tConn.createTopicSession(false, 3);
        this.reqTopic = this.tSession.createTopic(DBREQUEST);
        this.resTopic = this.tSession.createTopic(DBRESPONSE);
        this.reqSub = this.tSession.createSubscriber(this.reqTopic);
        this.resPub = this.tSession.createPublisher(this.resTopic);
        this.tNodeSubSession = this.tConn.createTopicSession(false, 3);
        this.tNodePubSession = this.tConn.createTopicSession(false, 3);
        this.dbNodeStatusSubTopic = this.tNodeSubSession.createTopic(DBNODESTATUS);
        this.dbNodeStatusSub = this.tNodeSubSession.createSubscriber(this.dbNodeStatusSubTopic);
        this.dbNodeStatusPubTopic = this.tNodePubSession.createTopic(DBNODESTATUS);
        this.dbNodeStatusPub = this.tNodePubSession.createPublisher(this.dbNodeStatusPubTopic);
        this.tConn.start();
        isMasterNode = false;
        localStartTime = System.currentTimeMillis();
        isServerUp = true;
    }

    private void initialize(String[] args) throws Exception {
        this.parseCommandLine(args);
        System.out.println(bundle.getString("initializing"));
        this.initDB();
        this.initJMQ();
        this.initMasterDBNodeChecker();
        this.processThread = new Thread(this);
        this.processThread.setName(this._id);
        this.processThread.start();
        System.out.println(bundle.getString("startsuccess"));
    }

    private void initMasterDBNodeChecker() {
        block3: {
            localNodeID = new SecureRandom().nextLong();
            localStartTime = System.currentTimeMillis();
            this.nodeStatusSender = new Thread(new NodeStatusSender());
            this.nodeStatusSender.start();
            this.nodeStatusReceiver = new Thread(new NodeStatusReceiver());
            this.nodeStatusReceiver.start();
            if (this.verbose) {
                System.out.println(bundle.getString("waitfornodechecking"));
            }
            try {
                Thread.sleep(nodeUpdateInterval + nodeUpdateGraceperiod);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                if (!this.verbose) break block3;
                e.printStackTrace();
            }
        }
        FAMHaDB.determineMasterDBNode();
    }

    private void Shutdown() {
        try {
            haDbEnv.close();
        }
        catch (Exception e) {
            System.out.println("e.getMessage");
        }
    }

    public int process() throws Exception {
        BytesMessage message = (BytesMessage)this.reqSub.receive();
        String id = message.getStringProperty(ID);
        String op = message.getStringProperty("op");
        String svc = message.getStringProperty("service");
        if (this.verbose) {
            System.out.println("OP=" + op);
            System.out.println("service=" + svc);
        }
        PrimaryIndex recordByPrimaryKey = this.da.getPrimaryIndex(svc);
        if (op.indexOf(READ) >= 0) {
            if (this.verbose) {
                System.out.println(bundle.getString("readmsgrecv"));
            }
            if (this.statsEnabled) {
                ++readCount;
            }
            String pKey = this.getLenString((Message)message);
            long random = message.readLong();
            if (this.verbose) {
                System.out.println(">>>>>>>>>>>>>> Read by Primary Key : " + pKey);
            }
            BaseRecord baseRecord = null;
            try {
                baseRecord = (BaseRecord)recordByPrimaryKey.get((Object)pKey);
            }
            catch (DatabaseException ex) {
                ex.printStackTrace();
                System.out.println("READ exc: " + (Object)((Object)ex));
            }
            if (this.verbose) {
                if (baseRecord != null) {
                    System.out.println(">>>>>>>>>>>>>> Found record !");
                } else {
                    System.out.println(">>>>>>>>>>>>>> Not found record !");
                }
            }
            if (baseRecord != null) {
                BytesMessage resmsg = this.tSession.createBytesMessage();
                resmsg.setStringProperty(ID, id);
                resmsg.writeLong(random);
                byte[] blob = baseRecord.getBlob();
                resmsg.writeLong((long)blob.length);
                resmsg.writeBytes(blob);
                this.resPub.publish((Message)resmsg);
            } else if (isMasterNode) {
                BytesMessage resmsg = this.tSession.createBytesMessage();
                resmsg.setStringProperty(ID, id);
                resmsg.setStringProperty(OP_STATUS, NOT_FOUND);
                resmsg.writeLong(random);
                this.resPub.publish((Message)resmsg);
            }
        } else if (op.indexOf(WRITE) >= 0) {
            if (this.verbose) {
                System.out.println(bundle.getString("writemsgrecv"));
            }
            if (this.statsEnabled) {
                ++writeCount;
            }
            String pKey = this.getLenString((Message)message);
            long expdate = message.readLong();
            byte[] secondKey = this.getLenBytes((Message)message);
            byte[] auxdata = this.getLenBytes((Message)message);
            int state = message.readInt();
            byte[] stuff = this.getLenBytes((Message)message);
            if (this.verbose) {
                System.out.println(">>>>>>>>>>>>>> Write by Primary Key : " + pKey);
            }
            BaseRecord record = (BaseRecord)this.da.classes.get(svc).newInstance();
            record.setPrimaryKey(pKey);
            record.setExpDate(expdate);
            if (secondKey != null) {
                record.setSecondaryKey(new String(secondKey, "utf8"));
            }
            if (auxdata != null) {
                record.setAuxData(new String(auxdata, "utf8"));
            }
            record.setState(state);
            record.setBlob(stuff);
            recordByPrimaryKey.put((Object)record);
        } else if (op.indexOf(DELETEBYDATE) >= 0) {
            if (this.verbose) {
                System.out.println(bundle.getString("datemsgrecv"));
            }
            long expDate = message.readLong();
            if (this.verbose) {
                System.out.println(">>>>>>>>>>>>>> Delete by Date : " + expDate);
            }
            this.deleteByDate(expDate, this.numCleanSessions, svc);
        } else if (op.indexOf(DELETE) >= 0) {
            if (this.verbose) {
                System.out.println(bundle.getString("deletemsgrecv"));
            }
            if (this.statsEnabled) {
                ++deleteCount;
            }
            String pKey = this.getLenString((Message)message);
            if (this.verbose) {
                System.out.println(">>>>>>>>>>>>>> Delete by Primary Key : " + pKey);
            }
            Transaction txn = null;
            try {
                txn = haDbEnv.getEnv().beginTransaction(null, null);
                recordByPrimaryKey.delete(txn, (Object)pKey);
                txn.commit();
            }
            catch (Exception e) {
                txn.abort();
                System.out.println("Aborted txn: " + e.toString());
                e.printStackTrace();
            }
        } else {
            if (op.indexOf(SHUTDOWN) >= 0) {
                this.Shutdown();
                return 1;
            }
            if (op.indexOf(GET_RECORD_COUNT) >= 0) {
                if (this.verbose) {
                    System.out.println(bundle.getString("getsessioncount"));
                }
                if (this.statsEnabled) {
                    ++scReadCount;
                }
                this.getRecordsBySecondaryKey(message, id, svc);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRecordsBySecondaryKey(BytesMessage message, String id, String service) throws Exception {
        if (!isMasterNode) {
            if (this.verbose) {
                System.out.println(bundle.getString("notmasterdbnode"));
            }
            return;
        }
        String secondKey = this.getLenString((Message)message);
        if (this.verbose) {
            System.out.println("SEC" + secondKey);
        }
        long random = message.readLong();
        int nrows = 0;
        Vector<RecordExpTimeInfo> rows = new Vector<RecordExpTimeInfo>();
        EntityCursor records = null;
        try {
            SecondaryIndex recordBySecondaryIndx = this.da.getSecondaryIndex2(service);
            records = recordBySecondaryIndx.subIndex((Object)secondKey).entities();
            for (BaseRecord record : records) {
                long currentTime = System.currentTimeMillis() / 1000L;
                Long expdate = record.getExpDate();
                if (record.getState() != 1 || currentTime >= expdate) continue;
                ++nrows;
                RecordExpTimeInfo info = new RecordExpTimeInfo();
                info.auxDataLen = record.getAuxData().length();
                info.auxyData = record.getAuxData().getBytes("utf8");
                info.expTime = expdate;
                rows.add(info);
            }
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace();
            }
        }
        finally {
            records.close();
        }
        BytesMessage resmsg = this.tSession.createBytesMessage();
        resmsg.setStringProperty(ID, id);
        resmsg.writeLong(random);
        resmsg.writeInt(nrows);
        for (int i = 0; i < rows.size(); ++i) {
            RecordExpTimeInfo info = (RecordExpTimeInfo)rows.get(i);
            resmsg.writeInt(info.auxDataLen);
            resmsg.writeBytes(info.auxyData);
            resmsg.writeLong(info.expTime);
        }
        this.resPub.publish((Message)resmsg);
    }

    public void deleteByDate(long expTime, int cleanCount, String svc) throws Exception {
        block6: {
            Transaction txn = haDbEnv.getEnv().beginTransaction(null, null);
            EntityCursor records = this.da.getSecondaryIndex1(svc).entities(txn, null);
            int count = 0;
            if (this.verbose) {
                System.out.println("expTime : " + expTime);
                System.out.println("cleanCount : " + cleanCount);
                System.out.println("svc : " + svc);
            }
            try {
                BaseRecord record;
                Long expdate;
                Iterator i$ = records.iterator();
                while (i$.hasNext() && (expdate = (record = (BaseRecord)i$.next()).getExpDate()) <= expTime) {
                    records.delete();
                    if (this.verbose) {
                        System.out.println(">>>>> Delete the " + count + "th record has " + expdate);
                    }
                    if (count++ < cleanCount) continue;
                    break;
                }
                records.close();
                records = null;
                txn.commit();
                txn = null;
            }
            catch (Exception e) {
                System.out.println("Exception for delete record by cursor : " + e.toString());
                e.printStackTrace();
                if (records != null) {
                    records.close();
                    records = null;
                }
                if (txn == null) break block6;
                txn.abort();
                txn = null;
            }
        }
    }

    public void deleteByDate(long expTime, int cleanCount) throws Exception {
        this.deleteByDate(expTime, cleanCount, "session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAllSessionRecords(String service) throws DatabaseException {
        EntityCursor records = this.da.getSecondaryIndex1(service).entities();
        try {
            for (BaseRecord record : records) {
                this.displaySessionRecord(record);
            }
        }
        catch (DatabaseException de) {
            System.err.println(de.getMessage());
            if (this.verbose) {
                de.printStackTrace();
            }
        }
        finally {
            records.close();
        }
    }

    private void displaySessionRecord(BaseRecord theSession) throws DatabaseException {
        assert (theSession != null);
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println("Primary Key :\t " + theSession.getPrimaryKey());
        System.out.println("Expiration Date :\t " + theSession.getExpDate());
        System.out.println("Aux Data :\t " + theSession.getAuxData());
        System.out.println("State :\t " + theSession.getState());
        System.out.println("Secondary Key :\t " + theSession.getSecondaryKey());
    }

    String getLenString(Message msg) throws Exception {
        BytesMessage message = (BytesMessage)msg;
        long pKeylen = message.readLong();
        byte[] pKeybytes = new byte[(int)pKeylen];
        message.readBytes(pKeybytes);
        return new String(pKeybytes, "utf8");
    }

    byte[] getLenBytes(Message msg) throws Exception {
        BytesMessage message = (BytesMessage)msg;
        long keylen = message.readLong();
        byte[] keybytes = null;
        if (keylen > 0L) {
            keybytes = new byte[(int)keylen];
            message.readBytes(keybytes);
        }
        return keybytes;
    }

    public void run() {
        long startTime;
        long epoch = startTime = System.currentTimeMillis();
        totalTrans = 0;
        while (true) {
            try {
                while (true) {
                    if (isServerUp) {
                        int ret = this.process();
                        ++totalTrans;
                        if (!this.statsEnabled || System.currentTimeMillis() - startTime < this.statsInterval) continue;
                        this.printStats();
                        startTime = System.currentTimeMillis();
                        totalTrans = 0;
                        readCount = 0;
                        writeCount = 0;
                        deleteCount = 0;
                        scReadCount = 0;
                        continue;
                    }
                    long curTime = System.currentTimeMillis() / 1000L;
                    int cleanCount = this.numCleanSessions * 5;
                    this.deleteByDate(curTime, cleanCount);
                    Thread.sleep(this.sleepTime);
                    if (this.verbose) {
                        System.out.println(bundle.getString("reconnecttobroker"));
                    }
                    this.initJMQ();
                    if (!this.verbose) continue;
                    System.out.println(bundle.getString("reconnectsuccessfull"));
                }
            }
            catch (Exception ex) {
                isServerUp = false;
                System.err.println(bundle.getString("brokerdown"));
                if (!this.verbose) continue;
                ex.printStackTrace();
                continue;
            }
            catch (Throwable t) {
                if (!this.verbose) continue;
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void sunSpecificConfig(TopicConnectionFactory tFactory) throws Exception {
        ConnectionFactory cf = (ConnectionFactory)tFactory;
        cf.setProperty("imqAddressList", this.clusterAddress);
        cf.setProperty("imqAddressListBehavior", RANDOM);
        cf.setProperty("imqReconnectEnabled", "true");
        cf.setProperty("imqConnectionFlowLimitEnabled", "true");
        cf.setProperty("imqDefaultUsername", this.userName);
        cf.setProperty("imqDefaultPassword", this.userPassword);
    }

    public static void main(String[] args) {
        try {
            dbs = new FAMHaDB("FAMHaDB");
            dbs.initialize(args);
            AMDBShutdown shutDownHook = new AMDBShutdown();
            Runtime.getRuntime().addShutdownHook(shutDownHook);
        }
        catch (Exception ex) {
            System.out.println("Exception main()");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void printCommandError(String errorMessage, String command) {
        System.err.println(bundle.getString(errorMessage) + " " + command);
        System.err.println(bundle.getString("usage"));
        System.exit(1);
    }

    private void printUsage() {
        System.err.println(bundle.getString("usage"));
        System.exit(1);
    }

    private void printStats() {
        statsWriter.println(bundle.getString("printingstats"));
        statsWriter.println(bundle.getString("totalreq") + " " + totalTrans);
        statsWriter.println(bundle.getString("totalread") + " " + readCount);
        statsWriter.println(bundle.getString("totalwrite") + " " + writeCount);
        statsWriter.println(bundle.getString("totaldelete") + " " + deleteCount);
        statsWriter.println(bundle.getString("totalreadsessioncount") + " " + scReadCount);
        statsWriter.flush();
    }

    private void parseCommandLine(String[] argv) throws Exception {
        if (!FAMHaDB.validateArguments(argv, bundle)) {
            this.printUsage();
        }
        block23: for (int i = 0; i < argv.length; ++i) {
            int opt = this.getToken(argv[i]);
            switch (opt) {
                case 1: {
                    if (++i >= argv.length) {
                        this.printUsage();
                    }
                    this.userName = argv[i];
                    if (this.getToken(this.userName.toLowerCase()) == 0) continue block23;
                    this.printCommandError("nousername", argv[i - 1]);
                    continue block23;
                }
                case 2: {
                    if (++i >= argv.length) {
                        this.printUsage();
                    }
                    this.userPassword = argv[i];
                    if (this.getToken(this.userPassword.toLowerCase()) == 0) continue block23;
                    this.printCommandError("nopassword", argv[i - 1]);
                    this.printCommandError("nopassword", argv[i - 1]);
                    this.printCommandError("nopassword", argv[i - 1]);
                    continue block23;
                }
                case 3: {
                    String pwd;
                    String passwordfile;
                    if (++i >= argv.length) {
                        this.printUsage();
                    }
                    if (this.getToken((passwordfile = argv[i]).toLowerCase()) != 0) {
                        this.printCommandError("nopasswordfile", argv[i - 1]);
                    }
                    if ((pwd = CryptUtil.decrypt("KmhUnWR1MYWDYW4xuqdF5nbm+CXIyOVt", FAMSFOPassword.readEncPasswordFromFile(passwordfile))) == null) {
                        this.printCommandError("nopwdinfile", argv[i]);
                    }
                    this.userPassword = pwd.trim();
                    continue block23;
                }
                case 4: {
                    String cache;
                    if (++i >= argv.length) {
                        this.printUsage();
                    }
                    if (this.getToken(cache = argv[i]) != 0) {
                        this.printCommandError("nocachesize", argv[i - 1]);
                    }
                    try {
                        this.cacheSize = Integer.parseInt(cache);
                    }
                    catch (NumberFormatException e) {
                        this.printCommandError("invalidvalue", argv[i - 1]);
                    }
                    continue block23;
                }
                case 5: {
                    if (++i >= argv.length) {
                        this.printUsage();
                    }
                    this.dbDirectory = argv[i];
                    if (this.getToken(this.dbDirectory.toLowerCase()) != 0) {
                        this.printCommandError("nodbdirectory", argv[i - 1]);
                    }
                    sessDbEnvPath = new File(this.dbDirectory);
                    continue block23;
                }
                case 6: {
                    if (++i >= argv.length) {
                        this.printUsage();
                    }
                    this.clusterAddress = argv[i];
                    if (this.getToken(this.clusterAddress.toLowerCase()) == 0) continue block23;
                    this.printCommandError("noclusteraddress", argv[i - 1]);
                    continue block23;
                }
                case 7: {
                    String nCleanSessions;
                    if (++i >= argv.length) {
                        this.printUsage();
                    }
                    if (this.getToken(nCleanSessions = argv[i]) != 0) {
                        this.printCommandError("nonumcleansessions", argv[i - 1]);
                    }
                    try {
                        this.numCleanSessions = Integer.parseInt(nCleanSessions);
                    }
                    catch (NumberFormatException e) {
                        this.printCommandError("invalidvalue", argv[i - 1]);
                    }
                    continue block23;
                }
                case 9: {
                    this.verbose = true;
                    continue block23;
                }
                case 10: {
                    String sInterval;
                    if (++i >= argv.length) {
                        this.printUsage();
                    }
                    if (this.getToken(sInterval = argv[i]) != 0) {
                        this.printCommandError("nostatsinterval", argv[i - 1]);
                    }
                    try {
                        this.statsInterval = Long.parseLong(sInterval);
                    }
                    catch (NumberFormatException e) {
                        this.printCommandError("invalidvalue", argv[i - 1]);
                    }
                    if (this.statsInterval <= 0L) {
                        this.statsInterval = 60L;
                    }
                    this.statsInterval *= 1000L;
                    this.statsEnabled = true;
                    continue block23;
                }
                case 11: {
                    System.err.println(bundle.getString("usage"));
                    System.exit(0);
                    continue block23;
                }
                case 12: {
                    System.out.println("\n" + bundle.getString("version"));
                    System.exit(0);
                    continue block23;
                }
                case 13: {
                    String interval;
                    if (++i >= argv.length) {
                        this.printUsage();
                    }
                    if (this.getToken(interval = argv[i]) != 0) {
                        this.printCommandError("nonodestatusupdateinterval", argv[i - 1]);
                    }
                    try {
                        nodeUpdateInterval = Long.parseLong(interval);
                    }
                    catch (NumberFormatException e) {
                        this.printCommandError("invalidvalue", argv[i - 1]);
                    }
                    if (nodeUpdateInterval > 0L) continue block23;
                    nodeUpdateInterval = 5000L;
                    continue block23;
                }
                case 14: {
                    if (++i >= argv.length) {
                        this.printUsage();
                    }
                    this.propertiesfile = argv[i];
                    continue block23;
                }
                default: {
                    System.err.println(bundle.getString("usage"));
                    System.err.println(bundle.getString("invalid-option") + argv[i]);
                    System.exit(1);
                }
            }
        }
    }

    static boolean validateArguments(String[] argv, ResourceBundle bundle) {
        int len = argv.length;
        boolean hasClusterAddress = false;
        boolean retValue = true;
        boolean hasPassword = false;
        boolean hasPwdFile = false;
        if (len == 0) {
            retValue = false;
        } else if (len == 1) {
            String arg = argv[0].toLowerCase();
            if (!(arg.equals("--help") || arg.equals("-h") || arg.equals("--version") || arg.equals("-n"))) {
                System.err.println(bundle.getString("invalid-option") + arg);
                retValue = false;
            }
        } else {
            for (int i = 0; i < len - 1; ++i) {
                String arg = argv[i].toLowerCase();
                if (arg.equals("--clusteraddress") || arg.equals("-a")) {
                    hasClusterAddress = true;
                }
                if (arg.equals("--password") || arg.equals("-w")) {
                    hasPassword = true;
                }
                if (!arg.equals("--passwordfile") && !arg.equals("-f")) continue;
                hasPwdFile = true;
            }
            if (hasPassword && hasPwdFile) {
                retValue = false;
            }
            if (!hasClusterAddress) {
                retValue = false;
            }
        }
        return retValue;
    }

    int getToken(String arg) {
        try {
            return (Integer)arguments.get(arg);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void deleteDirectory(String fileName) {
        File dir = new File(fileName);
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        } else {
            dir.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void determineMasterDBNode() {
        Map map = serverStatusMap;
        synchronized (map) {
            Set s = serverStatusMap.keySet();
            Iterator iter = s.iterator();
            boolean masterDB = true;
            while (iter.hasNext()) {
                String key = (String)iter.next();
                NodeInfo info = (NodeInfo)serverStatusMap.get(key);
                if (info.startTime >= localStartTime) continue;
                masterDB = false;
                break;
            }
            isMasterNode = masterDB;
        }
    }

    static void debugMessage(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    static void pendRunning() {
        InputStreamReader reader = new InputStreamReader(System.in);
        BufferedReader buf_in = new BufferedReader(reader);
        String str = "q";
        try {
            System.out.print("Please press the return key to continue.");
            do {
                if ((str = buf_in.readLine()) == null) {
                    FAMHaDB.debugMessage("------------>str is null !");
                    continue;
                }
                FAMHaDB.debugMessage("------------>str is not null !");
            } while (!str.equals("q"));
        }
        catch (Exception e) {
            FAMHaDB.debugMessage("Exception in pendRunning : " + e);
            e.printStackTrace();
        }
    }

    static {
        debug = true;
        isMasterNode = false;
        serverStatusMap = new HashMap();
        nodeUpdateInterval = 5000L;
        nodeUpdateGraceperiod = 1000L;
        haDbEnv = new HaDBEnv();
        sessDbEnvPath = null;
        arguments = new HashMap();
        bundle = null;
        isServerUp = false;
        readCount = 0;
        writeCount = 0;
        deleteCount = 0;
        totalTrans = 0;
        scReadCount = 0;
        statsWriter = null;
        arguments.put("--username", new Integer(1));
        arguments.put("-u", new Integer(1));
        arguments.put("--password", new Integer(2));
        arguments.put("-w", new Integer(2));
        arguments.put("--passwordfile", new Integer(3));
        arguments.put("-f", new Integer(3));
        arguments.put("--cachesize", new Integer(4));
        arguments.put("-c", new Integer(4));
        arguments.put("--dbdirectory", new Integer(5));
        arguments.put("-b", new Integer(5));
        arguments.put("--clusteraddress", new Integer(6));
        arguments.put("-a", new Integer(6));
        arguments.put("--numcleansessions", new Integer(7));
        arguments.put("-s", new Integer(7));
        arguments.put("--deletedatabase", new Integer(8));
        arguments.put("-r", new Integer(8));
        arguments.put("--verbose", new Integer(9));
        arguments.put("-v", new Integer(9));
        arguments.put("--statsInterval", new Integer(10));
        arguments.put("-i", new Integer(10));
        arguments.put("--help", new Integer(11));
        arguments.put("-h", new Integer(11));
        arguments.put("--version", new Integer(12));
        arguments.put("-n", new Integer(12));
        arguments.put("--nodestatusupdateinterval", new Integer(13));
        arguments.put("-p", new Integer(13));
        arguments.put("-m", new Integer(14));
        arguments.put("--propertiesfile", new Integer(14));
        try {
            bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("Cannot get the resource bundle.");
            System.exit(1);
        }
        statsWriter = new PrintWriter(System.out);
    }

    class NodeStatusReceiver
    implements Runnable {
        NodeStatusReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: while (true) {
                try {
                    while (true) {
                        if (isServerUp) {
                            BytesMessage msg = (BytesMessage)FAMHaDB.this.dbNodeStatusSub.receive();
                            long nodeID = msg.readLong();
                            long startTime = msg.readLong();
                            if (nodeID == localNodeID) continue;
                            NodeInfo info = new NodeInfo();
                            info.nodeID = nodeID;
                            info.startTime = startTime;
                            info.lastUpdateTime = System.currentTimeMillis();
                            Map map = serverStatusMap;
                            synchronized (map) {
                                serverStatusMap.put(String.valueOf(nodeID), info);
                                continue block6;
                            }
                        }
                        Thread.sleep(nodeUpdateInterval);
                    }
                }
                catch (Exception e) {
                    isServerUp = false;
                    System.err.println(bundle.getString("brokerdown"));
                    if (!FAMHaDB.this.verbose) continue;
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable t) {
                    if (!FAMHaDB.this.verbose) continue;
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class NodeStatusSender
    implements Runnable {
        NodeStatusSender() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (isServerUp) {
                            long nextRun = System.currentTimeMillis() + nodeUpdateInterval;
                            BytesMessage msg = FAMHaDB.this.tSession.createBytesMessage();
                            msg.writeLong(localNodeID);
                            msg.writeLong(localStartTime);
                            FAMHaDB.this.dbNodeStatusPub.publish((Message)msg);
                            long sleeptime = nextRun - System.currentTimeMillis();
                            if (sleeptime > 0L) {
                                Thread.sleep(sleeptime);
                            }
                            this.RemoveOutdatedNodeInfo();
                            FAMHaDB.determineMasterDBNode();
                            continue;
                        }
                        Thread.sleep(nodeUpdateInterval);
                    }
                }
                catch (Exception e) {
                    isServerUp = false;
                    System.err.println(bundle.getString("brokerdown"));
                    if (!FAMHaDB.this.verbose) continue;
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable t) {
                    if (!FAMHaDB.this.verbose) continue;
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void RemoveOutdatedNodeInfo() {
            Map map = serverStatusMap;
            synchronized (map) {
                Set s = serverStatusMap.keySet();
                Iterator iter = s.iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    NodeInfo info = (NodeInfo)serverStatusMap.get(key);
                    long currentTime = System.currentTimeMillis();
                    if (currentTime <= info.lastUpdateTime + nodeUpdateInterval + nodeUpdateGraceperiod) continue;
                    iter.remove();
                }
            }
        }
    }

    private class NodeInfo {
        long nodeID;
        long startTime;
        long lastUpdateTime;

        private NodeInfo() {
        }
    }

    static class AMDBShutdown
    extends Thread {
        AMDBShutdown() {
        }

        public void run() {
            dbs.Shutdown();
        }
    }

    private class RecordExpTimeInfo {
        int auxDataLen;
        byte[] auxyData;
        long expTime;

        private RecordExpTimeInfo() {
        }
    }
}

