/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.remote;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.jaxrpc.SMSJAXRPCObject;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;

public class IdRemoteServicesImpl
implements IdServices {
    protected static final String SDK_SERVICE = "DirectoryManagerIF";
    protected static final String AMSR_COUNT = "__count";
    protected static final String AMSR_RESULTS = "__results";
    protected static final String AMSR_CODE = "__errorCode";
    protected static final String AMSR_ATTRS = "__attrs";
    private SOAPClient client = new SOAPClient("DirectoryManagerIF");
    private static Debug debug = Debug.getInstance((String)"amIdmClient");
    private static boolean sendRestrictionContext;
    private static IdServices instance;

    protected static Debug getDebug() {
        return debug;
    }

    protected static synchronized IdServices getInstance() {
        if (instance == null) {
            IdRemoteServicesImpl.getDebug().message("IdRemoteServicesImpl.getInstance(): Creating new Instance of IdRemoteServicesImpl()");
            instance = new IdRemoteServicesImpl();
        }
        return instance;
    }

    protected IdRemoteServicesImpl() {
    }

    protected void processException(Exception exception) throws SSOException, IdRepoException {
        if (exception instanceof SSOException) {
            throw (SSOException)((Object)exception);
        }
        if (exception instanceof IdRepoException) {
            throw (IdRepoException)exception;
        }
        if (debug.errorEnabled()) {
            IdRemoteServicesImpl.getDebug().error("IdRemoteServicesImpl.processException(): caught remote/un-known exception - ", (Throwable)exception);
        }
        throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
    }

    public boolean authenticate(String orgName, Callback[] credentials) {
        if (IdRemoteServicesImpl.getDebug().messageEnabled()) {
            IdRemoteServicesImpl.getDebug().message("IdRemoteServicesImpl.authenticate():  Not supported for remote clients");
        }
        return false;
    }

    public AMIdentity create(SSOToken token, IdType type, String name, Map attrMap, String amOrgName) throws IdRepoException, SSOException {
        String univid = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, attrMap, amOrgName};
            univid = (String)this.client.send(this.client.encodeMessage("create_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return IdUtils.getIdentity(token, univid);
    }

    public void delete(SSOToken token, IdType type, String name, String orgName, String amsdkDN) throws IdRepoException, SSOException {
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, orgName, amsdkDN};
            this.client.send(this.client.encodeMessage("delete_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames, String amOrgName, String amsdkDN, boolean isString) throws IdRepoException, SSOException {
        Map res = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, attrNames, amOrgName, amsdkDN};
            res = (Map)this.client.send(this.client.encodeMessage("getAttributes1_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
            if (res != null) {
                AMHashMap res2 = new AMHashMap();
                Iterator it = res.keySet().iterator();
                while (it.hasNext()) {
                    Object attr = it.next();
                    res2.put(attr, res.get(attr));
                }
                res = res2;
            }
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return res;
    }

    public Map getAttributes(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        Map res = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, amOrgName, amsdkDN};
            res = (Map)this.client.send(this.client.encodeMessage("getAttributes2_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
            if (res != null) {
                AMHashMap res2 = new AMHashMap();
                Iterator it = res.keySet().iterator();
                while (it.hasNext()) {
                    Object attr = it.next();
                    res2.put(attr, res.get(attr));
                }
                res = res2;
            }
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return res;
    }

    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, attrNames, amOrgName, amsdkDN};
            this.client.send(this.client.encodeMessage("removeAttributes_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
    }

    public IdSearchResults search(SSOToken token, IdType type, String pattern, IdSearchControl ctrl, String amOrgName) throws IdRepoException, SSOException {
        IdSearchOpModifier modifier = ctrl.getSearchModifier();
        Map avMap = ctrl.getSearchModifierMap();
        int filterOp = modifier.equals(IdSearchOpModifier.AND) ? 1 : 0;
        Map idResults = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), pattern, new Integer(ctrl.getTimeOut()), new Integer(ctrl.getMaxResults()), ctrl.getReturnAttributes(), ctrl.isGetAllReturnAttributesEnabled(), new Integer(filterOp), avMap, ctrl.isRecursive(), amOrgName};
            idResults = (Map)this.client.send(this.client.encodeMessage("search2_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return this.mapToIdSearchResults(token, type, amOrgName, idResults);
    }

    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd, String amOrgName, String amsdkDN, boolean isString) throws IdRepoException, SSOException {
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, attributes, isAdd, amOrgName, amsdkDN, isString};
            this.client.send(this.client.encodeMessage("setAttributes2_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
    }

    public void assignService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, serviceName, stype.getType(), attrMap, amOrgName, amsdkDN};
            this.client.send(this.client.encodeMessage("assignService_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
    }

    public Set getAssignedServices(SSOToken token, IdType type, String name, Map mapOfServiceNamesAndOCs, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        Set resultSet = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, mapOfServiceNamesAndOCs, amOrgName, amsdkDN};
            resultSet = (Set)this.client.send(this.client.encodeMessage("getAssignedServices_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return resultSet;
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        Map resultMap = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("IdRemoteServicesImpl.getServiceAttributes  type=" + type + ";  name=" + name + ";  serviceName=" + serviceName + ";  attrNames=" + attrNames + ";  amOrgName=" + amOrgName + ";  amsdkDN=" + amsdkDN);
            }
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, serviceName, attrNames, amOrgName, amsdkDN};
            resultMap = (Map)this.client.send(this.client.encodeMessage("getServiceAttributes_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return resultMap;
    }

    public Map getBinaryServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        Map resultMap = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("IdRemoteServicesImpl.getBinaryServiceAttributes  type=" + type + ";  name=" + name + ";  serviceName=" + serviceName + ";  attrNames=" + attrNames + ";  amOrgName=" + amOrgName + ";  amsdkDN=" + amsdkDN);
            }
            Object[] objs = new Object[]{((Object)token.getTokenID()).toString(), type.getName(), name, serviceName, attrNames, amOrgName, amsdkDN};
            resultMap = (Map)this.client.send(this.client.encodeMessage("getBinaryServiceAttributes_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (RemoteException rex) {
            IdRemoteServicesImpl.getDebug().error("IdRemoteServicesImpl.getBinaryServiceAttributes_idrepo: caught exception=", (Throwable)rex);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return resultMap;
    }

    public Map getServiceAttributesAscending(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        Map resultMap = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("IdRemoteServicesImpl.getServiceAttributesAscending type=" + type + ";  name=" + name + ";  serviceName=" + serviceName + ";  attrNames=" + attrNames + ";  amOrgName=" + amOrgName + ";  amsdkDN=" + amsdkDN);
            }
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, serviceName, attrNames, amOrgName, amsdkDN};
            resultMap = (Map)this.client.send(this.client.encodeMessage("getServiceAttributesAscending_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return resultMap;
    }

    public void unassignService(SSOToken token, IdType type, String name, String serviceName, Map attrMap, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, serviceName, attrMap, amOrgName, amsdkDN};
            this.client.send(this.client.encodeMessage("unassignService_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
    }

    public void modifyService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        try {
            if (IdRemoteServicesImpl.getDebug().messageEnabled()) {
                IdRemoteServicesImpl.getDebug().message("IdRemoteServicesImpl.modifyService_idrepo: name =" + name + ";  type=" + type + ";  serviceName=" + serviceName + ";  stype=" + stype + ";  attrMap=" + attrMap + ";  amOrgName=" + amOrgName + ";  amsdkDN=" + amsdkDN);
            }
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, serviceName, stype.getType(), attrMap, amOrgName, amsdkDN};
            this.client.send(this.client.encodeMessage("modifyService_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
    }

    public Set getMembers(SSOToken token, IdType type, String name, String amOrgName, IdType membersType, String amsdkDN) throws IdRepoException, SSOException {
        HashSet<AMIdentity> idResults = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, amOrgName, membersType.getName(), amsdkDN};
            Set res = (Set)this.client.send(this.client.encodeMessage("getMembers_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
            idResults = new HashSet<AMIdentity>();
            if (res != null) {
                Iterator it = res.iterator();
                while (it.hasNext()) {
                    String univid = (String)it.next();
                    AMIdentity id = IdUtils.getIdentity(token, univid);
                    idResults.add(id);
                }
            }
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return idResults;
    }

    public Set getMemberships(SSOToken token, IdType type, String name, IdType membershipType, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        HashSet<AMIdentity> idResults = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, membershipType.getName(), amOrgName, amsdkDN};
            Set res = (Set)this.client.send(this.client.encodeMessage("getMemberships_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
            idResults = new HashSet<AMIdentity>();
            if (res != null) {
                Iterator it = res.iterator();
                while (it.hasNext()) {
                    String univid = (String)it.next();
                    AMIdentity id = IdUtils.getIdentity(token, univid);
                    idResults.add(id);
                }
            }
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return idResults;
    }

    public void modifyMemberShip(SSOToken token, IdType type, String name, Set members, IdType membersType, int operation, String amOrgName) throws IdRepoException, SSOException {
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, members, membersType.getName(), new Integer(operation), amOrgName};
            this.client.send(this.client.encodeMessage("modifyMemberShip_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
    }

    public Set getSupportedOperations(SSOToken token, IdType type, String amOrgName) throws IdRepoException, SSOException {
        HashSet<IdOperation> results = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), amOrgName};
            Set ops = (Set)this.client.send(this.client.encodeMessage("getSupportedOperations_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
            results = new HashSet<IdOperation>();
            if (ops != null) {
                Iterator it = ops.iterator();
                while (it.hasNext()) {
                    String op = (String)it.next();
                    IdOperation idop = new IdOperation(op);
                    results.add(idop);
                }
            }
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return results;
    }

    public Set getSupportedTypes(SSOToken token, String amOrgName) throws IdRepoException, SSOException {
        HashSet<IdType> results = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), amOrgName};
            Set types = (Set)this.client.send(this.client.encodeMessage("getSupportedTypes_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
            results = new HashSet<IdType>();
            if (types != null) {
                Iterator it = types.iterator();
                while (it.hasNext()) {
                    String currType = (String)it.next();
                    IdType thisType = IdUtils.getType(currType);
                    results.add(thisType);
                }
            }
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return results;
    }

    public boolean isExists(SSOToken token, IdType type, String name, String amOrgName) throws SSOException, IdRepoException {
        Boolean isExists = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, amOrgName};
            isExists = (Boolean)this.client.send(this.client.encodeMessage("isExists_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return isExists;
    }

    public boolean isActive(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN) throws SSOException, IdRepoException {
        Boolean isActive = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, amOrgName, amsdkDN};
            isActive = (Boolean)this.client.send(this.client.encodeMessage("isActive_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
        return isActive;
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN, boolean active) throws SSOException, IdRepoException {
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, amOrgName, amsdkDN, active};
            this.client.send(this.client.encodeMessage("setActiveStatus_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
        }
        catch (Exception ex) {
            this.processException(ex);
        }
    }

    public void clearIdRepoPlugins(String orgName, String serviceComponent, int type) {
    }

    public void clearIdRepoPlugins() {
    }

    public void reloadIdRepoServiceSchema() {
    }

    public void reinitialize() {
    }

    public Set getFullyQualifiedNames(SSOToken token, IdType type, String name, String org) throws IdRepoException, SSOException {
        CaseInsensitiveHashSet answer = null;
        try {
            Object[] objs = new Object[]{this.getTokenString(token), type.getName(), name, org};
            Set set = (Set)this.client.send(this.client.encodeMessage("getFullyQualifiedNames_idrepo", objs), Session.getLBCookie(((Object)token.getTokenID()).toString()), null);
            if (set != null) {
                answer = new CaseInsensitiveHashSet((Collection)set);
            }
        }
        catch (Exception ex) {
            if (debug.warningEnabled()) {
                IdRemoteServicesImpl.getDebug().warning("IdRemoteServicesImpl.getFullyQualifiedNames_idrepo: caught exception=", (Throwable)ex);
            }
            if (ex instanceof IdRepoException) {
                throw (IdRepoException)ex;
            }
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        return answer;
    }

    private IdSearchResults mapToIdSearchResults(SSOToken token, IdType type, String orgName, Map m) throws IdRepoException {
        IdSearchResults results = new IdSearchResults(type, orgName);
        Set idSet = (Set)m.get(AMSR_RESULTS);
        Map attrMaps = (Map)m.get(AMSR_ATTRS);
        Integer err = (Integer)m.get(AMSR_CODE);
        if (idSet != null) {
            Iterator it = idSet.iterator();
            while (it.hasNext()) {
                String idStr = (String)it.next();
                AMIdentity id = IdUtils.getIdentity(token, idStr);
                CaseInsensitiveHashMap attrMap = new CaseInsensitiveHashMap((Map)attrMaps.get(idStr));
                results.addResult(id, attrMap);
            }
        }
        if (err != null) {
            results.setErrorCode(err);
        }
        return results;
    }

    private String getTokenString(SSOToken token) {
        if (!sendRestrictionContext) {
            return ((Object)token.getTokenID()).toString();
        }
        SSOToken appToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        return ((Object)token.getTokenID()).toString() + " " + ((Object)appToken.getTokenID()).toString();
    }

    static {
        String euc = SystemProperties.get("com.sun.identity.enableUniqueSSOTokenCookie");
        if (euc != null && euc.length() > 0) {
            sendRestrictionContext = Boolean.valueOf(euc);
            if (debug.messageEnabled()) {
                debug.message("IdRemoteServicesImpl.<init>: com.sun.identity.enableUniqueSSOTokenCookie = " + sendRestrictionContext);
            }
        }
        if (sendRestrictionContext) {
            SMSJAXRPCObject smsObj = new SMSJAXRPCObject();
            SSOToken appToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                Map map = smsObj.read(appToken, "o=AM_JAXRPC_VERSION");
                euc = (String)map.get("AM_JAXRPC_VERSION");
                if (euc != null && euc.length() > 0) {
                    int version = Integer.valueOf(euc);
                    sendRestrictionContext = version > 9;
                }
            }
            catch (NumberFormatException e) {
                debug.warning("IdRemoteServicesImpl.<init>.", (Throwable)e);
            }
            catch (SSOException e) {
                debug.warning("IdRemoteServicesImpl.<init>.", (Throwable)((Object)e));
            }
            catch (SMSException e) {
                debug.warning("IdRemoteServicesImpl.<init>.", (Throwable)e);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("IdRemoteServicesImpl.<init>: sendRestrictionContext = " + sendRestrictionContext);
        }
    }
}

