/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.policy.plugins.PrefixResourceName;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

class PolicyProperties {
    private static final String SERVER_LOG = "com.sun.identity.agents.server.log.file.name";
    private static final String DEFAULT_SERVER_LOG = "amRemotePolicyLog";
    private static final String LOGGING_LEVEL = "com.sun.identity.agents.logging.level";
    private static final String CACHE_TTL = "com.sun.identity.agents.polling.interval";
    private static final int CACHE_TTL_DEFAULT = 3;
    private static final String NOTIFICATION_ENABLED = "com.sun.identity.agents.notification.enabled";
    private static final String BOOLEAN_ACTION_VALUES = "com.sun.identity.policy.client.booleanActionValues";
    private static final String RESOURCE_COMPARATORS = "com.sun.identity.policy.client.resourceComparators";
    private static final String HEADER_ATTRIBUTES = "com.sun.identity.agents.header.attributes";
    private static final String CACHE_MODE = "com.sun.identity.policy.client.cacheMode";
    private static final String USE_PRE22_BOOLEAN_VALUES = "com.sun.identity.policy.client.usePre22BooleanValues";
    private static final String USE_PRE22_BOOLEAN_VALUES_DEFAULT = "true";
    private static final String PRE22_TRUE_VALUE_DEFAULT = "allow";
    private static final String PRE22_FALSE_VALUE = "deny";
    private static final String NOTIFICATION_ENABLED_DEFAULT = "false";
    private static final String COLON = ":";
    private static final String PIPE = "|";
    static final String ALLOW = "ALLOW";
    static final String DENY = "DENY";
    static final String BOTH = "BOTH";
    static final String DEFAULT_LOGGING_LEVEL = "BOTH";
    static final String DECISION = "DECISION";
    static final String NONE = "NONE";
    static final String SUBTREE = "subtree";
    static final String SELF = "self";
    private static final String CACHE_MODE_DEFAULT = "subtree";
    private Set responseAttributeNames;
    private String logName;
    private String notificationURL;
    private int cacheTtl;
    private String cacheMode;
    private int cleanupInterval;
    private boolean notificationEnabledFlag;
    private Map resourceComparators;
    private Map booleanActionValues;
    private boolean usePre22BooleanValues;
    private String pre22TrueValue;
    private String pre22FalseValue;
    private ResourceName prefixResourceName;
    private static long clientClockSkew = 0L;
    private static boolean previousNotificationEnabledFlag = false;
    private static String previousNotificationURL = null;
    private static String logActions = "NONE";
    private static Debug debug = PolicyEvaluator.debug;
    public static final String CLIENT_CLOCK_SKEW = "com.sun.identity.policy.client.clockSkew";

    PolicyProperties() throws PolicyException {
        block48: {
            String clientClockSkewString;
            String attrs;
            String resourceComparatorsString;
            String booleanActionValuesString;
            String interval;
            this.responseAttributeNames = Collections.EMPTY_SET;
            this.notificationEnabledFlag = false;
            this.resourceComparators = new HashMap(10);
            this.booleanActionValues = new HashMap(10);
            this.usePre22BooleanValues = true;
            this.pre22TrueValue = PRE22_TRUE_VALUE_DEFAULT;
            this.pre22FalseValue = PRE22_FALSE_VALUE;
            this.prefixResourceName = new PrefixResourceName();
            this.logName = SystemProperties.get(SERVER_LOG);
            if (this.logName == null || this.logName.length() == 0) {
                this.logName = DEFAULT_SERVER_LOG;
                if (debug.messageEnabled()) {
                    debug.message("PolicyProperties:property com.sun.identity.agents.server.log.file.name is not specified, use default value amRemotePolicyLog");
                }
            } else if (debug.messageEnabled()) {
                debug.message("PolicyProperties:logName=" + this.logName);
            }
            if ((interval = SystemProperties.get(CACHE_TTL)) == null || interval.length() == 0) {
                throw new PolicyException("amPolicy", "invalid_cache_ttl", null, null);
            }
            try {
                this.cacheTtl = Integer.parseInt(interval);
                this.cleanupInterval = this.cacheTtl = this.cacheTtl * 60 * 1000;
            }
            catch (NumberFormatException nfe) {
                throw new PolicyException("amPolicy", "invalid_cache_ttl", null, nfe);
            }
            if (this.cacheTtl <= 0) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyProperties():configured cacheTtl" + this.cacheTtl + " seconds too small");
                    debug.warning("PolicyProperties():setting cacheTtl as3 minutes");
                }
                this.cleanupInterval = this.cacheTtl = 180000;
            } else if (debug.messageEnabled()) {
                debug.message("PolicyProperties:cacheTtl=" + this.cacheTtl / 60 / 1000 + "minutes");
            }
            previousNotificationEnabledFlag = this.notificationEnabledFlag;
            previousNotificationURL = this.notificationURL;
            String isEnabled = SystemProperties.get(NOTIFICATION_ENABLED);
            if ((isEnabled == null || isEnabled.length() == 0) && debug.warningEnabled()) {
                debug.warning("PolicyProperties:invalid value for poperty:com.sun.identity.agents.notification.enabled:defaulting to:false");
            }
            this.notificationEnabledFlag = Boolean.valueOf(isEnabled);
            if (debug.messageEnabled()) {
                debug.message("PolicyProperties:notificationEnabledFlag=" + this.notificationEnabledFlag);
            }
            if (this.notificationEnabledFlag) {
                block47: {
                    try {
                        this.notificationURL = WebtopNaming.getNotificationURL().toString();
                    }
                    catch (URLNotFoundException e) {
                        if (!debug.messageEnabled()) break block47;
                        debug.message("PolicyProperties:notificationURL not found", (Throwable)e);
                    }
                }
                if (this.notificationURL == null || this.notificationURL.length() == 0) {
                    throw new PolicyException("amPolicy", "invalid.notificationurl", null, null);
                }
                if (debug.messageEnabled()) {
                    debug.message("PolicyProperties:notificationURL=" + this.notificationURL);
                }
            }
            this.cacheMode = SystemProperties.get(CACHE_MODE);
            if (this.cacheMode == null || !this.cacheMode.equals("subtree") && !this.cacheMode.equals(SELF)) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyProperties.init():com.sun.identity.policy.client.cacheMode:not defined, or invalid, defaulting to:subtree");
                }
                this.cacheMode = "subtree";
            } else if (debug.messageEnabled()) {
                debug.message("PolicyProperties.init():cacheMode=" + this.cacheMode);
            }
            String status = SystemProperties.get(LOGGING_LEVEL);
            if (status == null || status.length() == 0) {
                status = "BOTH";
                if (debug.messageEnabled()) {
                    debug.message("PolicyProperties:property com.sun.identity.agents.logging.level is not specified, use default value BOTH");
                }
            }
            if (status != null) {
                logActions = status.equalsIgnoreCase(ALLOW) ? ALLOW : (status.equalsIgnoreCase(DENY) ? DENY : (status.equalsIgnoreCase("BOTH") ? "BOTH" : (status.equalsIgnoreCase(DECISION) ? DECISION : NONE)));
                if (debug.messageEnabled()) {
                    debug.message("PolicyProperties():property:" + logActions + "=logActions");
                }
            }
            if ((booleanActionValuesString = SystemProperties.get(BOOLEAN_ACTION_VALUES)) != null) {
                StringTokenizer st1 = new StringTokenizer(booleanActionValuesString, COLON);
                while (st1.hasMoreTokens()) {
                    String str = st1.nextToken();
                    StringTokenizer st2 = new StringTokenizer(str, PIPE);
                    int tokenCount = st2.countTokens();
                    if (tokenCount != 4) {
                        debug.error("PolicyProperties():booleanActionValues not well formed:" + booleanActionValuesString);
                        Object[] args = new Object[]{str};
                        throw new PolicyException("amPolicy", "invalid_boolean_action_values", args, null);
                    }
                    String serviceName = st2.nextToken();
                    String actionName = st2.nextToken();
                    String trueValue = st2.nextToken();
                    String falseValue = st2.nextToken();
                    this.setBooleanActionValues(serviceName, actionName, trueValue, falseValue);
                }
            } else if (debug.warningEnabled()) {
                debug.warning("PolicyProperties():property:com.sun.identity.policy.client.booleanActionValues:not defined");
            }
            String usePre22BooleanValuesString = SystemProperties.get(USE_PRE22_BOOLEAN_VALUES, USE_PRE22_BOOLEAN_VALUES_DEFAULT);
            this.usePre22BooleanValues = Boolean.valueOf(usePre22BooleanValuesString);
            if (debug.messageEnabled()) {
                debug.message("PolicyProperries:usePre22BooleanValues=" + this.usePre22BooleanValues);
            }
            if (this.usePre22BooleanValues) {
                this.pre22TrueValue = SystemProperties.get("com.sun.identity.agents.true.value", PRE22_TRUE_VALUE_DEFAULT);
                if (debug.messageEnabled()) {
                    debug.message("PolicyProperries:pre22TrueValue=" + this.pre22TrueValue);
                    debug.message("PolicyProperries:pre22FalseValue=" + this.pre22FalseValue);
                }
            }
            if ((resourceComparatorsString = SystemProperties.get(RESOURCE_COMPARATORS)) != null) {
                StringTokenizer st1 = new StringTokenizer(resourceComparatorsString, COLON);
                while (st1.hasMoreTokens()) {
                    String str = st1.nextToken();
                    this.setResourceComparator(str);
                }
            } else if (debug.warningEnabled()) {
                debug.warning("PolicyProperties():property:com.sun.identity.policy.client.resourceComparators:not defined");
            }
            if ((attrs = SystemProperties.get(HEADER_ATTRIBUTES)) != null && attrs.length() > 0) {
                StringTokenizer st = new StringTokenizer(attrs, PIPE);
                this.responseAttributeNames = new HashSet(st.countTokens());
                while (st.hasMoreTokens()) {
                    this.responseAttributeNames.add(st.nextToken());
                }
            }
            if ((clientClockSkewString = SystemProperties.get(CLIENT_CLOCK_SKEW)) == null) {
                if (debug.messageEnabled()) {
                    debug.message("PolicyProperties.getClientClockSkew():com.sun.identity.policy.client.clockSkew Property not defined : defaulting to 0");
                }
            } else {
                try {
                    clientClockSkew = Long.valueOf(clientClockSkewString) * 1000L;
                    if (debug.messageEnabled()) {
                        debug.message("PolicyProperties.constructor():com.sun.identity.policy.client.clockSkew = " + clientClockSkewString);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (!debug.messageEnabled()) break block48;
                    debug.message("PolicyProperties.constructor():com.sun.identity.policy.client.clockSkew not a long number: defaulting to 0", (Throwable)nfe);
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties():constructed");
        }
    }

    String getLogName() throws PolicyException {
        return this.logName;
    }

    String getLogActions() throws PolicyException {
        return logActions;
    }

    int getCacheTtl() throws PolicyException {
        return this.cacheTtl;
    }

    String getCacheMode() throws PolicyException {
        return this.cacheMode;
    }

    int getCleanupInterval() throws PolicyException {
        return this.cleanupInterval;
    }

    long getClientClockSkew() {
        return clientClockSkew;
    }

    boolean notificationEnabled() {
        return this.notificationEnabledFlag;
    }

    static boolean previouslyNotificationEnabled() {
        return previousNotificationEnabledFlag;
    }

    String getNotificationURL() {
        return this.notificationURL;
    }

    static String getPreviousNotificationURL() {
        return previousNotificationURL;
    }

    String getTrueValue(String serviceName, String actionName) {
        String trueValue = null;
        Map serviceEntry = (Map)this.booleanActionValues.get(serviceName);
        if (serviceEntry != null) {
            String[] actionEntry = (String[])serviceEntry.get(actionName);
            if (actionEntry != null) {
                trueValue = actionEntry[0];
            }
        } else if (this.usePre22BooleanValues) {
            trueValue = this.pre22TrueValue;
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties.getTrueValue():servcieName=" + serviceName + ",actionName=" + actionName + " " + ":returning:" + trueValue);
        }
        return trueValue;
    }

    String getFalseValue(String serviceName, String actionName) {
        String falseValue = null;
        Map serviceEntry = (Map)this.booleanActionValues.get(serviceName);
        if (serviceEntry != null) {
            String[] actionEntry = (String[])serviceEntry.get(actionName);
            if (actionEntry != null) {
                falseValue = actionEntry[1];
            }
        } else if (this.usePre22BooleanValues) {
            falseValue = this.pre22FalseValue;
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties.getFalseValue():servcieName=" + serviceName + ",actionName=" + actionName + ":returning:" + falseValue);
        }
        return falseValue;
    }

    private Map getResourceComparators() {
        return this.resourceComparators;
    }

    ResourceName getResourceComparator(String serviceName) {
        ResourceName resourceComparator = (ResourceName)this.resourceComparators.get(serviceName);
        if (resourceComparator == null) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyProperties.getResourceComparator():ResourceName not configured for service:" + serviceName + ":defaulting to PrefixResourceName");
            }
            resourceComparator = this.prefixResourceName;
        }
        return resourceComparator;
    }

    Set getResponseAttributeNames() {
        return this.responseAttributeNames;
    }

    private void setBooleanActionValues(String serviceName, String actionName, String trueValue, String falseValue) {
        String[] actionEntry;
        HashMap<String, String[]> serviceEntry;
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties.setBooleanActionValues():servcieName=" + serviceName + ",actionName=" + actionName + ",trueValue=" + trueValue + ",falseValue=" + falseValue);
        }
        if ((serviceEntry = (HashMap<String, String[]>)this.booleanActionValues.get(serviceName)) == null) {
            serviceEntry = new HashMap<String, String[]>(4);
            this.booleanActionValues.put(serviceName, serviceEntry);
        }
        if ((actionEntry = (String[])serviceEntry.get(actionName)) == null) {
            actionEntry = new String[2];
            serviceEntry.put(actionName, actionEntry);
        }
        actionEntry[0] = trueValue;
        actionEntry[1] = falseValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResourceComparator(String str) throws PolicyException {
        if (debug.messageEnabled()) {
            debug.message("PolicyProperties.setResourceComparator():entering with str value=" + str);
        }
        ResourceName resourceComparator = null;
        String[] tokens = new String[5];
        String serviceName = null;
        String className = null;
        String delimiter = null;
        String wildCard = null;
        String caseSensitive = null;
        int count = 0;
        HashMap<String, String> configMap = new HashMap<String, String>(4);
        StringTokenizer st = new StringTokenizer(str, PIPE);
        while (st.hasMoreTokens()) {
            tokens[count++] = st.nextToken();
            if (count <= 4) continue;
        }
        for (int i = 0; i < count; ++i) {
            int equal = tokens[i].indexOf("=");
            String name = tokens[i].substring(0, equal);
            String value = tokens[i].substring(equal + 1);
            if (name == null) {
                debug.error("PolicyProperties.setResourceComparator():Resource comapartaor: name is null");
                continue;
            }
            if (value == null) {
                debug.error("PolicyProperties.setResourceComparator():Resource comapartaor: value is null");
                continue;
            }
            if (debug.messageEnabled()) {
                debug.message("PolicyProperties.setResourceComparator():Attr Name= " + name + ":Attr Value=" + value);
            }
            if (name.equalsIgnoreCase("serviceType")) {
                serviceName = value;
                continue;
            }
            if (name.equalsIgnoreCase("class")) {
                configMap.put("class", className);
                className = value;
                continue;
            }
            if (name.equalsIgnoreCase("delimiter")) {
                delimiter = value;
                configMap.put("delimiter", delimiter);
                continue;
            }
            if (name.equalsIgnoreCase("wildcard")) {
                wildCard = value;
                configMap.put("wildcard", wildCard);
                continue;
            }
            if (!name.equalsIgnoreCase("caseSensitive")) continue;
            caseSensitive = value;
            configMap.put("caseSensitive", caseSensitive);
        }
        if (serviceName == null) {
            debug.error("PolicyProperties().setResourceComparator():ResourceComparator definition not well formed" + str);
            Object[] args = new Object[]{str};
            throw new PolicyException("amPolicy", "invalid_resource_comparator", args, null);
        }
        try {
            if (className != null) {
                Class<?> resourceClass = Class.forName(className);
                resourceComparator = (ResourceName)resourceClass.newInstance();
                resourceComparator.initialize(configMap);
            }
        }
        catch (ClassNotFoundException e) {
            debug.error("PolicyProperties.setResourceComparator():Illegal exception ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            debug.error("PolicyProperties.setResourceComparator():Illegal exception ", (Throwable)e);
        }
        catch (InstantiationException e) {
            debug.error("PolicyProperties.setResourceComparator():InstantiationException  exception ", (Throwable)e);
        }
        finally {
            if (resourceComparator == null) {
                debug.error("PolicyProperties.setResourceCompartor():invalid configuration:" + str + ":defaulting to PrefixResourceName");
                resourceComparator = new PrefixResourceName();
            }
        }
        this.resourceComparators.put(serviceName, resourceComparator);
    }
}

