/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class DSAMERole
implements Subject {
    private boolean initialized;
    private String organizationDN;
    private Set subjectRoles = Collections.EMPTY_SET;
    private int timeLimit;
    private int maxResults;
    private int roleSearchScope;
    private String ldapServer;
    private static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    private static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map configParams) throws PolicyException {
        this.organizationDN = (String)configParams.get("iplanet-am-policy-config-is-roles-base-dn");
        String scope = (String)configParams.get("iplanet-am-policy-config-is-roles-search-scope");
        this.roleSearchScope = scope.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (scope.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.ldapServer = PolicyUtils.getISDSHostName().toLowerCase();
        try {
            this.timeLimit = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-search-limit"));
        }
        catch (NumberFormatException nfe) {
            debug.error("Can not parse search parameters in DSAMERole", (Throwable)nfe);
            this.timeLimit = 5;
            this.maxResults = 100;
        }
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken token) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken token) throws SSOException, PolicyException {
        return this.getValidValues(token, "*");
    }

    public ValidValues getValidValues(SSOToken token, String pattern) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "role_subject_not_yet_initialized", null, null);
        }
        try {
            int status;
            AMStoreConnection amConnection = new AMStoreConnection(token);
            AMOrganization orgObject = amConnection.getOrganization(this.organizationDN);
            AMSearchControl sc = new AMSearchControl();
            sc.setMaxResults(this.maxResults);
            sc.setTimeOut(this.timeLimit);
            sc.setSearchScope(this.roleSearchScope);
            AMSearchResults results = orgObject.searchAllRoles(pattern, sc);
            switch (results.getErrorCode()) {
                case 0: {
                    status = 0;
                    break;
                }
                case 1: {
                    status = 1;
                    break;
                }
                case 2: {
                    status = 2;
                    break;
                }
                default: {
                    status = 0;
                }
            }
            return new ValidValues(status, results.getSearchResults());
        }
        catch (AMException e) {
            LDAPException lde = e.getLDAPException();
            if (lde != null) {
                int ldapErrorCode = lde.getLDAPResultCode();
                if (ldapErrorCode == 49) {
                    throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                }
                if (ldapErrorCode == 32) {
                    Object[] objs = new String[]{this.organizationDN};
                    throw new PolicyException("amPolicy", "no_such_am_roles_base_dn", objs, null);
                }
                String errorMsg = lde.getLDAPErrorMessage();
                String additionalMsg = lde.errorCodeToString();
                if (additionalMsg != null) {
                    throw new PolicyException(errorMsg + ": " + additionalMsg);
                }
                throw new PolicyException(errorMsg);
            }
            throw new PolicyException(e);
        }
    }

    public String getDisplayNameForValue(String value, Locale locale) throws NameNotFoundException {
        return PolicyUtils.getDNDisplayString(value);
    }

    public Set getValues() {
        if (this.subjectRoles == null) {
            return Collections.EMPTY_SET;
        }
        return this.subjectRoles;
    }

    public void setValues(Set names) throws InvalidNameException {
        if (names == null) {
            throw new InvalidNameException("amPolicy", "role_subject_invalid_role_names", null, null, 5);
        }
        if (names.isEmpty()) {
            this.subjectRoles = names;
        } else {
            this.subjectRoles = new HashSet();
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                String role = (String)iter.next();
                if (role == null) continue;
                this.subjectRoles.add(new DN(role).toRFCString().toLowerCase());
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Set subjectRoles to: " + this.subjectRoles);
        }
    }

    public boolean isMember(SSOToken token) throws SSOException, PolicyException {
        String tokenID = ((Object)token.getTokenID()).toString();
        String userDN = token.getPrincipal().getName();
        boolean listenerAdded = false;
        boolean roleMatch = false;
        Set roleSet = null;
        if (this.subjectRoles.size() > 0) {
            Iterator roleIter = this.subjectRoles.iterator();
            while (roleIter.hasNext()) {
                Boolean matchFound = null;
                String valueDN = (String)roleIter.next();
                matchFound = SubjectEvaluationCache.isMember(tokenID, this.ldapServer, valueDN);
                if (matchFound != null) {
                    boolean result;
                    if (debug.messageEnabled()) {
                        debug.message("DSAMERole.isMember():Got membership from cache of " + token.getPrincipal().getName() + " in DSAME role " + valueDN + " :" + matchFound);
                    }
                    if (!(result = matchFound.booleanValue())) continue;
                    return result;
                }
                if (!listenerAdded && !PolicyEvaluator.ssoListenerRegistry.containsKey(tokenID)) {
                    token.addSSOTokenListener(PolicyEvaluator.ssoListener);
                    PolicyEvaluator.ssoListenerRegistry.put(tokenID, PolicyEvaluator.ssoListener);
                    if (debug.messageEnabled()) {
                        debug.message("DSAMERole.isMember(): sso listener added .\n");
                    }
                    listenerAdded = true;
                }
                if (debug.messageEnabled()) {
                    debug.message("DSAMERole:isMember():entry for " + valueDN + " not in subject evaluation cache, fetching " + "from NS User Cache.");
                }
                if (roleSet == null) {
                    roleSet = PolicyEvaluator.getUserNSRoleValues(token);
                }
                if (roleSet != null && !roleSet.isEmpty()) {
                    if (debug.messageEnabled()) {
                        debug.message("DSAMERole.isMember():\n  user roles: " + roleSet + "\n  subject roles: " + this.subjectRoles);
                    }
                    if (roleSet.contains(valueDN)) {
                        roleMatch = true;
                    }
                }
                if (debug.messageEnabled()) {
                    debug.message("DSAMERole.isMember:adding entry " + tokenID + " " + this.ldapServer + " " + valueDN + " " + roleMatch + " in subject evaluation cache.");
                }
                SubjectEvaluationCache.addEntry(tokenID, this.ldapServer, valueDN, roleMatch);
                if (!roleMatch) continue;
                break;
            }
        }
        if (debug.messageEnabled()) {
            if (!roleMatch) {
                debug.message("DSAMERole.isMember(): User " + userDN + " is not a member of this DSAMERole object");
            } else {
                debug.message("DSAMERole.isMember(): User " + userDN + " is a member of this DSAMERole object");
            }
        }
        return roleMatch;
    }

    public int hashCode() {
        return ((Object)this.subjectRoles).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DSAMERole) {
            DSAMERole role = (DSAMERole)o;
            return ((Object)this.subjectRoles).equals(role.subjectRoles);
        }
        return false;
    }

    public Object clone() {
        DSAMERole theClone = null;
        try {
            theClone = (DSAMERole)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.subjectRoles != null) {
            theClone.subjectRoles = new HashSet();
            theClone.subjectRoles.addAll(this.subjectRoles);
        }
        return theClone;
    }
}

