/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.Crypt;
import com.sun.identity.setup.EmbeddedOpenDS;
import com.sun.identity.setup.SetupProgress;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class BootstrapData {
    private List data = new ArrayList();
    static final String BOOTSTRAP = "bootstrap";
    static final String PROTOCOL = "protocol";
    static final String SERVER_INSTANCE = "serverinstance";
    static final String FF_BASE_DIR = "ffbasedir";
    static final String BASE_DIR = "basedir";
    public static final String DS_HOST = "dshost";
    public static final String DS_PORT = "dsport";
    public static final String DS_PROTOCOL = "dsprotocol";
    public static final String DS_PWD = "dspwd";
    public static final String DS_MGR = "dsmgr";
    public static final String DS_BASE_DN = "dsbasedn";
    public static final String DS_REPLICATIONPORT = "dsreplport";
    public static final String DS_REPLICATIONPORT_AVAILABLE = "dsreplportavailable";
    public static final String DS_ISEMBEDDED = "dsisembedded";
    public static final String ENCKEY = "enckey";
    static final String DS_PROTO_TYPE = "dsprototype";
    static final String PWD = "pwd";
    static final String PROT_FILE = "file";
    static final String PROT_LDAP = "ldap";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_LDAP = "ldap://";
    static final String PROTOCOL_LDAPS = "ldaps://";
    static final String DS_PROTO_LDAPS = "SSL";
    static final String DS_PROTO_LDAP = "SIMPLE";
    private static final String BOOTSTRAPCONFIG = "bootstrapConfig.properties";
    private String basedir;
    private String dsbasedn;
    private String dsameUserPwd;
    private String instanceName;
    private static final String BOOTSTRAP_SERVER_START_TAG = "<iPlanetDataAccessLayer>";
    private static final String BOOTSTRAP_SERVER_END_TAG = "</iPlanetDataAccessLayer>";
    private static final String BOOTSTRAP_SERVER_CONFIG_USER = "<ServerGroup name=\"default\" minConnPool=\"1\" maxConnPool=\"1\"><Server name=\"Server1\" host=\"@dshost@\" port=\"@dsport@\" type=\"@dsprototype@\" /><User name=\"User1\" type=\"admin\"><DirDN>cn=dsameuser,ou=DSAME Users,@dsbasedn@</DirDN><DirPassword>@pwd@</DirPassword></User><BaseDN>@dsbasedn@</BaseDN></ServerGroup>";
    private static final String BOOTSTRAP_SERVER_CONFIG_LDAP_SVR = "<ServerGroup name=\"sms\" minConnPool=\"1\" maxConnPool=\"10\">@SERVER_ENTRY@<User name=\"User2\" type=\"admin\"><DirDN>@dsmgr@</DirDN><DirPassword>@dspwd@</DirPassword></User><BaseDN>@dsbasedn@</BaseDN></ServerGroup>";
    private static final String BOOTSTRAP_SERVER_CONFIG_LDAP_SVR_ENTRY = "<Server name=\"Server@counter@\" host=\"@dshost@\" port=\"@dsport@\" type=\"@dsprototype@\" />";

    public BootstrapData(String basedir) throws IOException {
        this.basedir = basedir;
        this.readFile(basedir + "/" + BOOTSTRAP);
    }

    public BootstrapData(Map mapConfig) throws UnsupportedEncodingException {
        this.data.add(BootstrapData.createBootstrapResource(mapConfig, false));
    }

    public List getData() {
        return this.data;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getBaseDN() {
        return this.dsbasedn;
    }

    public String getDsameUserPassword() {
        return this.dsameUserPwd;
    }

    public Map getDataAsMap(int idx) throws MalformedURLException, UnsupportedEncodingException {
        String info = (String)this.data.get(idx);
        String dsprotocol = "unknown";
        if (info.startsWith(PROTOCOL_LDAPS)) {
            info = "http://" + info.substring(8);
            dsprotocol = "ldaps";
        } else if (info.startsWith(PROTOCOL_LDAP)) {
            info = "http://" + info.substring(7);
            dsprotocol = PROT_LDAP;
        }
        URL url = new URL(info);
        Map mapQuery = BootstrapData.queryStringToMap(url.getQuery());
        String dshost = url.getHost();
        mapQuery.put(DS_HOST, dshost);
        String dsport = Integer.toString(url.getPort());
        mapQuery.put(DS_PORT, dsport);
        mapQuery.put(DS_PROTOCOL, dsprotocol);
        return mapQuery;
    }

    public void initSMS(boolean startDS) throws UnsupportedEncodingException, LDAPServiceException, MalformedURLException {
        String serverConfigXML = this.getServerConfigXML(false);
        Properties prop = this.getBootstrapProperties();
        SystemProperties.initializeProperties(prop, true);
        Crypt.reinitialize();
        BootstrapData.loadServerConfigXML(serverConfigXML);
        if (startDS) {
            BootstrapData.startEmbeddedDS(this.basedir + "/opends");
        }
    }

    private Properties getBootstrapProperties() {
        Properties prop = new Properties();
        try {
            prop.load(this.getClass().getClassLoader().getResourceAsStream(BOOTSTRAPCONFIG));
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String property = prop.getProperty(name);
                property = property.replaceAll("@DS_BASE_DN@", this.dsbasedn);
                prop.setProperty(name, property);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return prop;
    }

    private static void startEmbeddedDS(String odsDir) {
        File odsDirFile = new File(odsDir);
        if (odsDirFile.exists() && !EmbeddedOpenDS.isStarted()) {
            try {
                SetupProgress.reportStart("emb.startemb", null);
                EmbeddedOpenDS.startServer(odsDir);
                SetupProgress.reportEnd("emb.success", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadServerConfigXML(String xml) throws LDAPServiceException {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(xml.getBytes());
            DSConfigMgr.initInstance(bis);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getServerConfigXML(boolean bCrypt) throws UnsupportedEncodingException, MalformedURLException {
        boolean first = true;
        StringBuffer buff = new StringBuffer();
        buff.append(BOOTSTRAP_SERVER_START_TAG);
        String serverBlob = null;
        StringBuffer serverBuff = new StringBuffer();
        int counter = 1;
        Iterator i = this.data.iterator();
        while (i.hasNext()) {
            String info = (String)i.next();
            boolean ldaps = false;
            if (info.startsWith(PROTOCOL_LDAPS)) {
                info = "http://" + info.substring(8);
                ldaps = true;
            } else if (info.startsWith(PROTOCOL_LDAP)) {
                info = "http://" + info.substring(7);
            }
            URL url = new URL(info);
            if (first) {
                buff.append(this.getServerConfigXMLUserBlob(url, ldaps, bCrypt));
                serverBlob = this.getServerConfigXMLServerBlob(url, ldaps, bCrypt);
                first = false;
            }
            serverBuff.append(this.getServerEntryXMLBlob(url, ldaps, counter++));
        }
        String servers = serverBlob.replaceAll("@SERVER_ENTRY@", serverBuff.toString());
        buff.append(servers);
        buff.append(BOOTSTRAP_SERVER_END_TAG);
        return buff.toString();
    }

    private String getServerConfigXMLUserBlob(URL url, boolean ldaps, boolean bCrypt) throws UnsupportedEncodingException {
        Map mapQuery = BootstrapData.queryStringToMap(url.getQuery());
        String dshost = url.getHost();
        String dsport = Integer.toString(url.getPort());
        String dsmgr = (String)mapQuery.get(DS_MGR);
        String dspwd = (String)mapQuery.get(DS_PWD);
        String pwd = (String)mapQuery.get(PWD);
        this.dsbasedn = (String)mapQuery.get(DS_BASE_DN);
        this.instanceName = URLDecoder.decode(url.getPath(), "UTF-8");
        this.dsameUserPwd = (String)mapQuery.get(PWD);
        if (bCrypt) {
            pwd = Crypt.decode((String)pwd, (AMEncryption)Crypt.getHardcodedKeyEncryptor());
            pwd = Crypt.encode((String)pwd);
            dspwd = Crypt.decode((String)dspwd, (AMEncryption)Crypt.getHardcodedKeyEncryptor());
            dspwd = Crypt.encode((String)dspwd);
        }
        if (this.instanceName.startsWith("/")) {
            this.instanceName = this.instanceName.substring(1);
        }
        String template = BOOTSTRAP_SERVER_CONFIG_USER;
        template = ldaps ? template.replaceAll("@dsprototype@", DS_PROTO_LDAPS) : template.replaceAll("@dsprototype@", DS_PROTO_LDAP);
        template = template.replaceAll("@dshost@", dshost);
        template = template.replaceAll("@dsport@", dsport);
        template = template.replaceAll("@dsmgr@", dsmgr);
        template = template.replaceAll("@dsbasedn@", this.dsbasedn);
        template = template.replaceAll("@dspwd@", dspwd);
        template = template.replaceAll("@pwd@", pwd);
        return template;
    }

    public static Map queryStringToMap(String str) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(str, "&");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int idx = s.indexOf(61);
            map.put(s.substring(0, idx), URLDecoder.decode(s.substring(idx + 1), "UTF-8"));
        }
        return map;
    }

    private String getServerConfigXMLServerBlob(URL url, boolean ldaps, boolean bCrypt) throws UnsupportedEncodingException {
        Map mapQuery = BootstrapData.queryStringToMap(url.getQuery());
        String pwd = (String)mapQuery.get(PWD);
        String dshost = url.getHost();
        String dsport = Integer.toString(url.getPort());
        this.dsbasedn = (String)mapQuery.get(DS_BASE_DN);
        String dsmgr = (String)mapQuery.get(DS_MGR);
        String dspwd = (String)mapQuery.get(DS_PWD);
        String template = BOOTSTRAP_SERVER_CONFIG_LDAP_SVR;
        if (bCrypt) {
            pwd = Crypt.decode((String)pwd, (AMEncryption)Crypt.getHardcodedKeyEncryptor());
            pwd = Crypt.encode((String)pwd);
            dspwd = Crypt.decode((String)dspwd, (AMEncryption)Crypt.getHardcodedKeyEncryptor());
            dspwd = Crypt.encode((String)dspwd);
        }
        template = ldaps ? template.replaceAll("@dsprototype@", DS_PROTO_LDAPS) : template.replaceAll("@dsprototype@", DS_PROTO_LDAP);
        template = template.replaceAll("@dshost@", dshost);
        template = template.replaceAll("@dsport@", dsport);
        template = template.replaceAll("@dsmgr@", dsmgr);
        template = template.replaceAll("@dsbasedn@", this.dsbasedn);
        template = template.replaceAll("@dspwd@", dspwd);
        template = template.replaceAll("@pwd@", pwd);
        return template;
    }

    private String getServerEntryXMLBlob(URL url, boolean ldaps, int counter) throws UnsupportedEncodingException {
        Map mapQuery = BootstrapData.queryStringToMap(url.getQuery());
        String dshost = url.getHost();
        String dsport = Integer.toString(url.getPort());
        String template = BOOTSTRAP_SERVER_CONFIG_LDAP_SVR_ENTRY;
        template = ldaps ? template.replaceAll("@dsprototype@", DS_PROTO_LDAPS) : template.replaceAll("@dsprototype@", DS_PROTO_LDAP);
        template = template.replaceAll("@dshost@", dshost);
        template = template.replaceAll("@dsport@", dsport);
        template = template.replaceAll("@counter@", Integer.toString(counter));
        return template;
    }

    static String create(String bootstrapFile, Map configuration, boolean legacy) throws IOException {
        File btsFile = new File(bootstrapFile);
        if (!btsFile.getParentFile().exists()) {
            btsFile.getParentFile().mkdirs();
        }
        return BootstrapData.createBootstrapResource(configuration, legacy);
    }

    static String createBootstrapResource(Map configuration, boolean legacy) throws UnsupportedEncodingException {
        if (legacy) {
            return (String)configuration.get(FF_BASE_DIR);
        }
        String protocol = (String)configuration.get(PROTOCOL);
        protocol = protocol.substring(0, protocol.length() - 3);
        String pwd = Crypt.encode((String)((String)configuration.get(PWD)), (AMEncryption)Crypt.getHardcodedKeyEncryptor());
        String serverInstance = (String)configuration.get(SERVER_INSTANCE);
        String url = "@DS_PROTO@://@DS_HOST@/@INSTANCE_NAME@?pwd=@DSAMEUSER_PWD@&dsbasedn=@BASE_DN@&dsmgr=@BIND_DN@&dspwd=@BIND_PWD@&ver=1.0";
        url = url.replaceAll("@DS_PROTO@", protocol);
        String dsHost = (String)configuration.get(DS_HOST) + ":" + (String)configuration.get(DS_PORT);
        url = url.replaceAll("@DS_HOST@", dsHost);
        url = url.replaceAll("@INSTANCE_NAME@", URLEncoder.encode(serverInstance, "UTF-8"));
        url = url.replaceAll("@DSAMEUSER_PWD@", URLEncoder.encode(pwd, "UTF-8"));
        url = url.replaceAll("@BASE_DN@", URLEncoder.encode((String)configuration.get(DS_BASE_DN), "UTF-8"));
        url = url.replaceAll("@BIND_DN@", URLEncoder.encode((String)configuration.get(DS_MGR), "UTF-8"));
        url = url.replaceAll("@BIND_PWD@", URLEncoder.encode(Crypt.encode((String)((String)configuration.get(DS_PWD)), (AMEncryption)Crypt.getHardcodedKeyEncryptor()), "UTF-8"));
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(String file) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            if (in.ready()) {
                String str = in.readLine();
                while (str != null) {
                    if ((str = str.trim()).length() > 0 && !str.startsWith("#")) {
                        this.data.add(str);
                    }
                    str = in.readLine();
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

