/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.flatfile;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.flatfile.FileObserver;
import com.sun.identity.sm.flatfile.SMSEnhancedFlatFileObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FlatFileEventManager {
    private static Debug debug = Debug.getInstance((String)"amSMSEvent");
    private Map listeners = new HashMap();
    private FileObserver fObserver;
    private SMSEnhancedFlatFileObject flatFileInstance;

    public FlatFileEventManager(SMSEnhancedFlatFileObject flatFileInstance) {
        this.flatFileInstance = flatFileInstance;
    }

    synchronized String addObjectChangeListener(SMSObjectListener changeListener) {
        String id = SMSUtils.getUniqueID();
        this.listeners.put(id, changeListener);
        if (this.fObserver == null) {
            this.fObserver = new FileObserver(this);
            this.fObserver.start();
        } else if (!this.fObserver.isRunning()) {
            this.fObserver.start();
        }
        return id;
    }

    synchronized void removeObjectChangeListener(String id) {
        this.listeners.remove(id);
        if (this.listeners.isEmpty() && this.fObserver != null) {
            this.fObserver.stopThread();
        }
    }

    void notify(String dn, int eventType) {
        if (dn != null) {
            Iterator i = this.listeners.values().iterator();
            while (i.hasNext()) {
                SMSObjectListener l = (SMSObjectListener)i.next();
                l.objectChanged(dn, eventType);
            }
        }
    }

    void reloadRootNode() {
        try {
            this.flatFileInstance.loadMapper();
        }
        catch (SMSException e) {
            debug.error("FlatFileEventManager.reloadRootNode", (Throwable)e);
        }
    }
}

