/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.flatfile;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.CaseInsensitiveTreeSet;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SchemaException;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.flatfile.FileNameDecoder;
import com.sun.identity.sm.flatfile.FlatFileEventManager;
import com.sun.identity.sm.flatfile.NodeNameFilter;
import com.sun.identity.sm.flatfile.SMSFlatFileObjectBase;
import com.sun.identity.sm.flatfile.SMSFlatFileTreeNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.directory.ModificationItem;

public class SMSEnhancedFlatFileObject
extends SMSFlatFileObjectBase {
    private SMSFlatFileTreeNode root = null;
    static final String DIR_TREE_FILENAME = "DirectoryTree.xml";
    private FlatFileEventManager eventManager;

    public SMSEnhancedFlatFileObject() throws SMSException {
        this.initialize();
        this.eventManager = new FlatFileEventManager(this);
    }

    synchronized void loadMapper() throws SMSException {
        String fileName = this.mRootDir + File.separator + DIR_TREE_FILENAME;
        File fileHandle = new File(fileName);
        if (fileHandle.isFile()) {
            if (!fileHandle.canRead()) {
                String errmsg = "SMSEnhancedFlatFileObject.initialize: cannot read file " + fileName;
                this.mDebug.error(errmsg);
                throw new SMSException(errmsg);
            }
            this.parseDirectoryTreeXML(fileName);
        } else {
            try {
                fileHandle.createNewFile();
            }
            catch (IOException e) {
                String errmsg = "SMSEnhancedFlatFileObject.initialize: cannot create file, " + fileName + ". Exception " + e.getMessage();
                this.mDebug.error("SMSEnhancedFlatFileObject.initialize", (Throwable)e);
                throw new SMSException(errmsg);
            }
            catch (SecurityException e) {
                String errmsg = "SMSEnhancedFlatFileObject.initialize: cannot create file, " + fileName + ". Exception " + e.getMessage();
                this.mDebug.error("SMSEnhancedFlatFileObject.initialize", (Throwable)e);
                throw new SMSException(errmsg);
            }
            this.root = new SMSFlatFileTreeNode(this.mRootDN);
            try {
                HashMap map = new HashMap(2);
                HashSet<String> set = new HashSet<String>(4);
                set.add("top");
                set.add("organizationalunit");
                map.put("objectclass", set);
                this.create(null, "ou=services," + this.mRootDN, map);
                this.saveDirectoryTree();
            }
            catch (SSOException e) {
            }
            catch (ServiceAlreadyExistsException e) {
                this.mDebug.message("SMSEnhancedFlatFileObject.initialize", (Throwable)e);
            }
        }
    }

    private void parseDirectoryTreeXML(String filename) throws SMSException {
        FileReader in = null;
        BufferedReader buff = null;
        try {
            in = new FileReader(filename);
            buff = new BufferedReader(in);
            StringBuffer sb = new StringBuffer();
            String line = buff.readLine();
            while (line != null) {
                sb.append(line);
                line = buff.readLine();
            }
            this.root = SMSFlatFileTreeNode.createTree(sb.toString(), this.mDebug);
        }
        catch (IOException e) {
            throw new SMSException("SMSEnhancedFlatFileObject.parseDirectoryTreeXML, Exception" + e.getMessage());
        }
        catch (Exception e) {
            throw new SMSException("SMSEnhancedFlatFileObject.parseDirectoryTreeXML, Exception" + e.getMessage());
        }
        finally {
            if (buff != null) {
                try {
                    buff.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void saveDirectoryTree() throws SMSException {
        String fileName = this.mRootDir + File.separator + DIR_TREE_FILENAME;
        FileOutputStream fout = null;
        OutputStreamWriter writer = null;
        try {
            fout = new FileOutputStream(fileName, false);
            writer = new OutputStreamWriter(fout);
            writer.write(this.root.toXML());
            writer.flush();
        }
        catch (FileNotFoundException ex) {
            throw new SMSException("SMSEnhancedFlatFileObject.saveDirectoryTree, Exception" + ex.getMessage());
        }
        catch (IOException ex) {
            throw new SMSException("SMSEnhancedFlatFileObject.saveDirectoryTree, Exception" + ex.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {}
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getSubEntries(String objName, String filter, String sidFilter, boolean isSubConfig, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException {
        String objKey = objName.toLowerCase();
        AbstractSet subentries = null;
        this.mRWLock.readRequest();
        try {
            SMSFlatFileTreeNode node = this.root.getChild(objKey);
            if (node == null) {
                String errmsg = "SMSEnhancedFlatFileObject.getSubEntries: " + objName + " : not found in objects map.";
                this.mDebug.warning(errmsg);
                throw new ServiceNotFoundException(errmsg);
            }
            NodeNameFilter subEntNodeFilter = new NodeNameFilter(filter);
            NodeNameFilter sidNameFilter = this.getSidNodeFilter(sidFilter, isSubConfig);
            subentries = sortResults ? new CaseInsensitiveTreeSet(ascendingOrder) : new CaseInsensitiveHashSet();
            Set subEntries = node.searchChildren(subEntNodeFilter, false);
            int numEntriesAdded = 0;
            int sz = subEntries.size();
            boolean done = false;
            Iterator i = subEntries.iterator();
            while (i.hasNext() && !done) {
                boolean accept;
                SMSFlatFileTreeNode n = (SMSFlatFileTreeNode)i.next();
                String nodeDN = n.getName();
                boolean bl = accept = sidNameFilter == null;
                if (!accept) {
                    Set sids = n.searchChildren(sidNameFilter, false);
                    boolean bl2 = accept = sids != null && !sids.isEmpty();
                }
                if (!accept) continue;
                int idx = nodeDN.indexOf(61);
                if (idx == -1 || idx == nodeDN.length() - 1) {
                    String errmsg = "SMSEnhancedFlatFileObject.getSubEntries: Invalid sub entry name found: " + nodeDN;
                    this.mDebug.error(errmsg);
                    throw new SchemaException(errmsg);
                }
                String subentryname = FileNameDecoder.decode(nodeDN.substring(idx + 1));
                subentries.add(subentryname);
                done = !sortResults && numOfEntries > 0 && ++numEntriesAdded == numOfEntries;
            }
            if (sortResults && numOfEntries > 0) {
                while (numEntriesAdded - numOfEntries > 0) {
                    Object l = ((CaseInsensitiveTreeSet)subentries).last();
                    subentries.remove(l);
                    --numEntriesAdded;
                }
            }
        }
        finally {
            this.mRWLock.readDone();
        }
        return subentries;
    }

    private NodeNameFilter getSidNodeFilter(String sidFilter, boolean isSubConfig) {
        NodeNameFilter sidNodeFilter = null;
        if (sidFilter != null && sidFilter.length() > 0) {
            sidNodeFilter = isSubConfig ? new NodeNameFilter("sunserviceID=" + sidFilter.toLowerCase()) : new NodeNameFilter("sunxmlKeyValue=" + sidFilter.toLowerCase());
        }
        return sidNodeFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map read(SSOToken token, String objName) throws SMSException, SSOException {
        Map attrMap;
        block11: {
            if (objName == null || objName.length() == 0) {
                throw new IllegalArgumentException("SMSEnhancedFlatFileObject.read: object name is null or empty.");
            }
            attrMap = null;
            this.mRWLock.readRequest();
            try {
                String filepath = this.root.getAttributeFilename(objName, this.mRootDir);
                if (filepath == null) {
                    if (this.mDebug.messageEnabled()) {
                        this.mDebug.message("SMSEnhancedFlatFileObject.read: object " + objName + " not found.");
                    }
                    break block11;
                }
                attrMap = Collections.EMPTY_MAP;
                File filehandle = new File(filepath);
                Properties props = null;
                if (filehandle.exists()) {
                    try {
                        props = this.loadProperties(filehandle, objName);
                    }
                    catch (ServiceNotFoundException e) {
                        // empty catch block
                    }
                }
                if (props != null) {
                    attrMap = new CaseInsensitiveHashMap();
                    Enumeration<?> keys = props.propertyNames();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String vals = props.getProperty(key);
                        if (vals == null || vals.length() <= 0) continue;
                        attrMap.put(key, this.toValSet(key, vals));
                    }
                }
            }
            finally {
                this.mRWLock.readDone();
            }
        }
        return attrMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(SSOToken token, String objName, Map attrs) throws SMSException, SSOException {
        if (objName == null || objName.length() == 0 || attrs == null) {
            throw new IllegalArgumentException("SMSEnhancedFlatFileObject.create: One or more arguments is null or empty");
        }
        Object attributeFileName = null;
        this.mRWLock.readRequest();
        try {
            if (this.root.isExists(this.mRootDir, objName)) {
                String errmsg = "SMSEnhancedFlatFileObject.create: object " + objName;
                this.mDebug.error(errmsg);
                throw new ServiceAlreadyExistsException(errmsg);
            }
        }
        finally {
            this.mRWLock.readDone();
        }
        this.mRWLock.writeRequest();
        if (this.root.isExists(this.mRootDir, objName)) {
            String errmsg = "SMSEnhancedFlatFileObject.create: object " + objName;
            this.mDebug.error(errmsg);
            throw new ServiceAlreadyExistsException(errmsg);
        }
        SMSFlatFileTreeNode node = new SMSFlatFileTreeNode(objName);
        String filepath = node.getAttributeFilename(this.mRootDir);
        try {
            Set sunserviceids = null;
            Set sunxmlkeyvals = null;
            Properties props = new Properties();
            Set keys = attrs.keySet();
            if (keys != null) {
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    Set vals = (Set)attrs.get(key);
                    if (key.equalsIgnoreCase("sunserviceID")) {
                        sunserviceids = vals;
                    } else if (key.equalsIgnoreCase("sunxmlKeyValue")) {
                        sunxmlkeyvals = vals;
                    }
                    props.put(key, this.toValString(vals));
                }
            }
            try {
                File attrFile = new File(filepath);
                try {
                    if (!attrFile.createNewFile()) {
                        String errmsg = "SMSEnhancedFlatFileObject.create: object " + objName + ": Could not create file " + filepath;
                        this.mDebug.error(errmsg);
                        throw new SMSException(errmsg);
                    }
                }
                catch (IOException e) {
                    String errmsg = "SMSEnhancedFlatFileObject.create: object " + objName + " IOException encountered when creating file " + filepath + ". Exception: " + e.getMessage();
                    this.mDebug.error("SMSEnhancedFlatFileObject.create", (Throwable)e);
                    throw new SMSException(errmsg);
                }
                this.saveProperties(props, attrFile, objName);
                this.createSunServiceIdFiles(node, sunserviceids);
                this.createSunXmlKeyValFiles(node, sunxmlkeyvals);
                if (!this.root.addChild(node)) {
                    throw new SMSException("parent not found for node name=" + objName);
                }
                this.saveDirectoryTree();
            }
            catch (SMSException e) {
                File attrFile = new File(filepath);
                try {
                    attrFile.delete();
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                throw e;
            }
        }
        finally {
            this.mRWLock.writeDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(SSOToken token, String objName, ModificationItem[] mods) throws SMSException, SSOException {
        if (objName == null || objName.length() == 0 || mods == null || mods.length == 0) {
            throw new IllegalArgumentException("SMSEnhancedFlatFileObject.modify: One or more arguments is null or empty");
        }
        this.mRWLock.readRequest();
        try {
            if (!this.root.isExists(this.mRootDir, objName)) {
                String errmsg = "SMSEnhancedFlatFileObject.modify: object " + objName + " not found.";
                this.mDebug.error(errmsg);
                throw new ServiceNotFoundException(errmsg);
            }
        }
        finally {
            this.mRWLock.readDone();
        }
        this.mRWLock.writeRequest();
        try {
            SMSFlatFileTreeNode node = this.root.getChild(objName);
            if (node == null) {
                String errmsg = "SMSEnhancedFlatFileObject.modify: object " + objName + " not found.";
                this.mDebug.error(errmsg);
                throw new ServiceNotFoundException(errmsg);
            }
            String filepath = node.getAttributeFilename(this.mRootDir);
            if (filepath == null) {
                String errmsg = "SMSEnhancedFlatFileObject.modify: object " + objName + " not found.";
                this.mDebug.error(errmsg);
                throw new ServiceNotFoundException(errmsg);
            }
            File filehandle = new File(filepath);
            if (!filehandle.isFile()) {
                String errmsg = "SMSEnhancedFlatFileObject.modify: Attributes file for object " + objName + " not found.";
                this.mDebug.error(errmsg);
                throw new ServiceNotFoundException(errmsg);
            }
            Properties props = this.loadProperties(filehandle, objName);
            boolean hasSunXmlKeyValue = props.getProperty("sunxmlKeyValue") != null;
            for (int i = 0; i < mods.length; ++i) {
                this.modifyValues(objName, mods[i], props);
            }
            this.saveProperties(props, filehandle, objName);
            String newSunXMLKeyValue = props.getProperty("sunxmlKeyValue");
            if (newSunXMLKeyValue != null) {
                Set xmlKeyVals = this.toValSet("sunxmlKeyValue", newSunXMLKeyValue);
                if (!hasSunXmlKeyValue) {
                    this.deleteSunXmlKeyValFiles(node);
                }
                this.createSunXmlKeyValFiles(node, xmlKeyVals);
                this.saveDirectoryTree();
            }
        }
        finally {
            this.mRWLock.writeDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(SSOToken token, String objName) throws SMSException, SSOException {
        if (objName == null || objName.length() == 0) {
            throw new IllegalArgumentException("SMSEnhancedFlatFileObject.delete: object name is null or empty.");
        }
        this.mRWLock.writeRequest();
        try {
            SMSFlatFileTreeNode node = this.root.getChild(objName);
            if (node != null) {
                node.getParentNode().removeChild(node, this.mRootDir);
                this.saveDirectoryTree();
            }
        }
        finally {
            this.mRWLock.writeDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryExists(SSOToken token, String objName) {
        boolean exists = false;
        if (objName == null || objName.length() == 0) {
            throw new IllegalArgumentException("SMSEnhancedFlatFileObject.entryExists: One or more arguments is null or empty.");
        }
        this.mRWLock.readRequest();
        try {
            exists = this.root.isExists(this.mRootDir, objName);
        }
        finally {
            this.mRWLock.readDone();
        }
        return exists;
    }

    public String toString() {
        return "SMSEnhancedFlatFileObject";
    }

    protected void deleteSunXmlKeyValFiles(SMSFlatFileTreeNode node) throws SMSException {
        NodeNameFilter filter = new NodeNameFilter("sunxmlKeyValue=*");
        Set toDelete = node.searchChildren(filter, false);
        Iterator i = toDelete.iterator();
        while (i.hasNext()) {
            SMSFlatFileTreeNode c = (SMSFlatFileTreeNode)i.next();
            node.removeChild(c, this.mRootDir);
        }
    }

    private void createSunXmlKeyValFiles(SMSFlatFileTreeNode node, Set sunxmlkeyvals) throws SMSException {
        if (sunxmlkeyvals != null && !sunxmlkeyvals.isEmpty()) {
            this.createLookupFiles(node, "sunxmlKeyValue", sunxmlkeyvals);
        }
    }

    private void createSunServiceIdFiles(SMSFlatFileTreeNode node, Set sunserviceids) throws SMSException {
        if (sunserviceids != null && !sunserviceids.isEmpty()) {
            this.createLookupFiles(node, "sunserviceID", sunserviceids);
        }
    }

    private void createLookupFiles(SMSFlatFileTreeNode node, String attr, Set sunserviceids) throws SMSException {
        Iterator i = sunserviceids.iterator();
        while (i.hasNext()) {
            String id = ((String)i.next()).toLowerCase();
            SMSFlatFileTreeNode child = new SMSFlatFileTreeNode(attr + "=" + id + "," + node.getDN());
            node.addChild(child);
        }
    }

    public String registerCallbackHandler(SSOToken token, SMSObjectListener changeListener) throws SMSException, SSOException {
        return this.eventManager.addObjectChangeListener(changeListener);
    }

    public void deregisterCallbackHandler(String id) {
        this.eventManager.removeObjectChangeListener(id);
    }
}

