/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.config;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.constants.DSConstants;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class DSConfigInfo
implements DSConstants {
    private String dsDirMgrPassword;
    private String dsInstanceDir;
    private String dsHost;
    private String dsPort;
    private String rootSuffix;
    private String dirMgrUid;
    private String dsVersion;
    private String dsToolsDir;
    private String perlBinDir;
    private AMTuneLogger pLogger = AMTuneLogger.getLoggerInst();
    private MessageWriter mWriter = MessageWriter.getInstance();
    private boolean isRemoteDS;

    public DSConfigInfo(ResourceBundle confBundle, boolean isSM) throws AMTuneException {
        if (!isSM) {
            this.setDsHost(confBundle.getString("DS_HOST"));
            this.checkIsDSHostRemote();
            this.setDsPort(confBundle.getString("DS_PORT"));
            this.setRootSuffix(confBundle.getString("ROOT_SUFFIX"));
            this.setDirMgrUid(confBundle.getString("DIRMGR_UID"));
            this.setDsDirMgrPassword(confBundle.getString("DIRMGR_PASSWORD"));
            this.setDsVersion(confBundle.getString("DS_VERSION"));
            if (!this.isRemoteDS) {
                this.setDsInstanceDir(confBundle.getString("DS_INSTANCE_DIR"));
                if (this.getDsVersion().indexOf("5.") != -1) {
                    this.setPerlBinDir(confBundle.getString("PERL_BIN_DIR"));
                }
                if (this.getDsVersion().indexOf("6.3") != -1) {
                    this.setDSToolsBinDir(confBundle.getString("DS_TOOLS_DIR"));
                }
            }
        } else {
            this.setSMDSHost(confBundle.getString("SM_DS_HOST"));
            this.checkIsDSHostRemote();
            this.setSMDSVersion(confBundle.getString("SM_DS_VERSION"));
            this.setSMDSPort(confBundle.getString("SM_DS_PORT"));
            this.setSMRootSuffix(confBundle.getString("SM_ROOT_SUFFIX"));
            this.setSMDirMgrUid(confBundle.getString("SM_DS_DIRMGR_UID"));
            this.setSMDSDirMgrPassword(confBundle.getString("SM_DIRMGR_PASSWORD"));
            if (!this.isRemoteDS && this.getDsVersion().indexOf("6.3") != -1) {
                this.setSMDSInstanceDir(confBundle.getString("SM_DS_INSTANCE_DIR"));
                this.setSMDSToolsBinDir(confBundle.getString("SM_DS_TOOLS_DIR"));
            }
        }
    }

    private void checkIsDSHostRemote() {
        this.pLogger.log(Level.FINEST, "checkIsDSHostRemote", "DS host is " + this.getDsHost());
        this.pLogger.log(Level.FINEST, "checkIsDSHostRemote", "Local host is " + AMTuneUtil.getHostName());
        this.isRemoteDS = !AMTuneUtil.getHostName().equalsIgnoreCase(this.getDsHost());
    }

    private void setDsDirMgrPassword(String dsDirMgrPassword) throws AMTuneException {
        if (dsDirMgrPassword == null || dsDirMgrPassword.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DIRMGR_PASSWORD");
            this.pLogger.log(Level.SEVERE, "setDsDirMgrPassword", "Error setting Directory Server Manager Password. Please check the value for the property DIRMGR_PASSWORD");
            throw new AMTuneException("Invalid value for DIRMGR_PASSWORD");
        }
        this.dsDirMgrPassword = dsDirMgrPassword.trim();
    }

    public String getDsDirMgrPassword() {
        return this.dsDirMgrPassword;
    }

    private void setDsInstanceDir(String dsInstanceDir) throws AMTuneException {
        if (dsInstanceDir != null && dsInstanceDir.trim().length() > 0) {
            File dirTest = new File(dsInstanceDir);
            if (!dirTest.isDirectory()) {
                this.mWriter.writelnLocaleMsg("pt-not-valid-dir");
                AMTuneUtil.printErrorMsg("DS_INSTANCE_DIR");
                this.pLogger.log(Level.SEVERE, "setDsInstanceDir", "Directory instance path is not valid directory");
                throw new AMTuneException("Invalid Directory Path.");
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DS_INSTANCE_DIR");
            this.pLogger.log(Level.SEVERE, "setDsInstanceDir", "Error setting Directory Instance Path. Please check the value for DS_INSTANCE_DIR");
            throw new AMTuneException("Invalid Directory Path.");
        }
        this.dsInstanceDir = dsInstanceDir.trim();
    }

    public String getDsInstanceDir() {
        return this.dsInstanceDir;
    }

    private void setDsHost(String dsHost) throws AMTuneException {
        if (dsHost == null || dsHost.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DS_HOST");
            this.pLogger.log(Level.SEVERE, "setDsHost", "Error setting Directory Server Host Name. Please check the value for the property DS_HOST");
            throw new AMTuneException("Invalid value for DS_HOST");
        }
        this.dsHost = dsHost.trim();
    }

    public String getDsHost() {
        return this.dsHost;
    }

    private void setDsPort(String dsPort) throws AMTuneException {
        if (dsPort == null || dsPort.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DS_PORT");
            this.pLogger.log(Level.SEVERE, "setDsPort", "Error setting Directory Server Port. Please check the value for the property DS_PORT");
            throw new AMTuneException("Invalid value for DS_PORT");
        }
        this.dsPort = dsPort.trim();
    }

    public String getDsPort() {
        return this.dsPort;
    }

    private void setRootSuffix(String rootSuffix) throws AMTuneException {
        if (rootSuffix == null || rootSuffix.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("ROOT_SUFFIX");
            this.pLogger.log(Level.SEVERE, "setRootSuffix", "Error setting Root Suffix. Please check the value for the property ROOT_SUFFIX");
            throw new AMTuneException("Invalid value for ROOT_SUFFIX");
        }
        this.rootSuffix = rootSuffix.trim();
    }

    public String getRootSuffix() {
        return this.rootSuffix;
    }

    private void setDirMgrUid(String dirMgrUid) throws AMTuneException {
        if (dirMgrUid == null || dirMgrUid.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DIRMGR_UID");
            this.pLogger.log(Level.SEVERE, "setDirMgrUid", "Error setting Directory Managre UID. Please check the value for the property DIRMGR_UID");
            throw new AMTuneException("Invalid value for DIRMGR_UID");
        }
        this.dirMgrUid = dirMgrUid.trim();
    }

    public String getDirMgrUid() {
        return this.dirMgrUid;
    }

    private void setDsVersion(String dsVersion) throws AMTuneException {
        if (dsVersion == null || dsVersion.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DS_VERSION");
            this.pLogger.log(Level.SEVERE, "setDsVersion", "Error setting Directory server version Please check the value for DS_VERSION");
            throw new AMTuneException("Invalid value for DS_VERSION");
        }
        this.dsVersion = dsVersion.trim();
    }

    public String getDsVersion() {
        return this.dsVersion;
    }

    private void setSMDSVersion(String dsVersion) throws AMTuneException {
        if (dsVersion != null && dsVersion.trim().length() > 0) {
            this.dsVersion = dsVersion.trim();
            if (!AMTuneUtil.isSupportedSMDSVersion(dsVersion)) {
                throw new AMTuneException("Unsupported SM DS VersionSM_DS_VERSION");
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("SM_DS_VERSION");
            this.pLogger.log(Level.SEVERE, "setSMDSVersion", "Error setting Directory server version Please check the value for SM_DS_VERSION");
            throw new AMTuneException("Invalid value for SM_DS_VERSION");
        }
    }

    private void setSMDirMgrUid(String dirMgrUid) throws AMTuneException {
        if (dirMgrUid == null || dirMgrUid.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("SM_DS_DIRMGR_UID");
            this.pLogger.log(Level.SEVERE, "setSMDirMgrUid", "Error setting Directory Managre UID. Please check the value for the property SM_DS_DIRMGR_UID");
            throw new AMTuneException("Invalid value for SM_DS_DIRMGR_UID");
        }
        this.dirMgrUid = dirMgrUid.trim();
    }

    private void setSMRootSuffix(String rootSuffix) throws AMTuneException {
        if (rootSuffix == null || rootSuffix.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("SM_ROOT_SUFFIX");
            this.pLogger.log(Level.SEVERE, "setSMRootSuffix", "Error setting Root Suffix. Please check the value for the property SM_ROOT_SUFFIX");
            throw new AMTuneException("Invalid value for SM_ROOT_SUFFIX");
        }
        this.rootSuffix = rootSuffix.trim();
    }

    private void setSMDSDirMgrPassword(String dsDirMgrPassword) throws AMTuneException {
        if (dsDirMgrPassword == null || dsDirMgrPassword.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("SM_DIRMGR_PASSWORD");
            this.pLogger.log(Level.SEVERE, "setDsDirMgrPassword", "Error setting Directory Server Manager Password. Please check the value for the property SM_DIRMGR_PASSWORD");
            throw new AMTuneException("Invalid value for SM_DIRMGR_PASSWORD");
        }
        this.dsDirMgrPassword = dsDirMgrPassword.trim();
    }

    private void setSMDSInstanceDir(String dsInstanceDir) throws AMTuneException {
        if (dsInstanceDir != null && dsInstanceDir.trim().length() > 0) {
            File dirTest = new File(dsInstanceDir);
            if (!dirTest.isDirectory()) {
                this.mWriter.writelnLocaleMsg("pt-not-valid-dir");
                AMTuneUtil.printErrorMsg("SM_DS_INSTANCE_DIR");
                this.pLogger.log(Level.SEVERE, "setSMDSInstanceDir", "Directory instance path is not valid directory");
                throw new AMTuneException("Invalid Directory Path.");
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("SM_DS_INSTANCE_DIR");
            this.pLogger.log(Level.SEVERE, "setSMDSInstanceDir", "Error setting Directory Instance Path. Please check the value for SM_DS_INSTANCE_DIR");
            throw new AMTuneException("Invalid Directory Path.");
        }
        this.dsInstanceDir = dsInstanceDir.trim();
    }

    private void setSMDSHost(String dsHost) throws AMTuneException {
        if (dsHost == null || dsHost.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("SM_DS_HOST");
            this.pLogger.log(Level.SEVERE, "setSMDSHost", "Error setting Directory Server Host Name. Please check the value for the property SM_DS_HOST");
            throw new AMTuneException("Invalid value for SM_DS_HOST");
        }
        this.dsHost = dsHost.trim();
    }

    private void setSMDSPort(String dsPort) throws AMTuneException {
        if (dsPort == null || dsPort.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("SM_DS_PORT");
            this.pLogger.log(Level.SEVERE, "setSMDSPort", "Error setting Directory Server Port. Please check the value for the property SM_DS_PORT");
            throw new AMTuneException("Invalid value for SM_DS_PORT");
        }
        this.dsPort = dsPort.trim();
    }

    private void setDSToolsBinDir(String dsToolsDir) throws AMTuneException {
        if (dsToolsDir != null && dsToolsDir.trim().length() > 0) {
            this.dsToolsDir = dsToolsDir.trim();
            File dir = new File(dsToolsDir);
            if (!dir.isDirectory()) {
                this.mWriter.writelnLocaleMsg("pt-not-valid-dir");
                AMTuneUtil.printErrorMsg("DS_TOOLS_DIR");
                this.pLogger.log(Level.SEVERE, "setDS6BinDir", "Invalid Bin Directory Path. Please check the value for DS_TOOLS_DIR");
                throw new AMTuneException("Invalid directory path for DS_TOOLS_DIR");
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("DS_TOOLS_DIR");
            this.pLogger.log(Level.SEVERE, "setDS6BinDir", "Error setting Directory 6 bin directory Please check the value for DS_TOOLS_DIR");
            throw new AMTuneException("Invalid value for DS_TOOLS_DIR");
        }
    }

    public String getDSToolsBinDir() {
        return this.dsToolsDir;
    }

    private void setSMDSToolsBinDir(String dsToolsDir) throws AMTuneException {
        if (dsToolsDir != null && dsToolsDir.trim().length() > 0) {
            this.dsToolsDir = dsToolsDir.trim();
            File dir = new File(dsToolsDir);
            if (!dir.isDirectory()) {
                this.mWriter.writelnLocaleMsg("pt-not-valid-dir");
                AMTuneUtil.printErrorMsg("SM_DS_TOOLS_DIR");
                this.pLogger.log(Level.SEVERE, "setSMDSToolsBinDir", "Invalid Bin Directory Path. Please check the value for SM_DS_TOOLS_DIR");
                throw new AMTuneException("Invalid directory path for SM_DS_TOOLS_DIR");
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("SM_DS_TOOLS_DIR");
            this.pLogger.log(Level.SEVERE, "setDS6BinDir", "Error setting Directory 6 bin directory Please check the value for SM_DS_TOOLS_DIR");
            throw new AMTuneException("Invalid value for SM_DS_TOOLS_DIR");
        }
    }

    private void setPerlBinDir(String perlBinDir) {
        this.perlBinDir = perlBinDir;
    }

    public String getPerlBinDir() {
        return this.perlBinDir;
    }

    public boolean isRemoteDS() {
        return this.isRemoteDS;
    }
}

