/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.config;

import com.sun.identity.tune.base.WebContainerConfigInfoBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class WS7ContainerConfigInfo
extends WebContainerConfigInfoBase {
    private String wsAdminDir;
    private String wsAdminCmd;
    private String wsAdminHost;
    private String wsAdminUser;
    private String wsAdminPort;
    private boolean isAdminPortSecure;
    private String wsAdminConfig;
    private String wsAdminHttpListener;
    private String adminPassFile;
    private String wsadmCommonParamsNoConfig;
    private String wsAdminCommonParams;
    private Map cfgMap;
    private String tempFile;

    public WS7ContainerConfigInfo(ResourceBundle confRbl) throws AMTuneException {
        try {
            this.setWebContainer("WS7");
            this.adminPassFile = AMTuneUtil.TMP_DIR + "wsadminpass";
            this.tempFile = AMTuneUtil.TMP_DIR + "cmdoutput";
            this.setContainerBaseDir(confRbl.getString("CONTAINER_BASE_DIR"));
            this.setContainerInstanceName(confRbl.getString("WEB_CONTAINER_INSTANCE_NAME"));
            this.setContainerInstanceDir(confRbl.getString("CONTAINER_INSTANCE_DIR"));
            this.setWSAdminDir(confRbl.getString("WSADMIN_DIR"));
            this.setWSAdminCmd();
            this.setWSAdminUser(confRbl.getString("WSADMIN_USER"));
            this.writePasswordToFile(confRbl.getString("WSADMIN_PASSWORD"));
            this.setWSAdminHost(confRbl.getString("WSADMIN_HOST"));
            this.setWSAdminPort(confRbl.getString("WSADMIN_PORT"));
            this.setWSAdminSecure(confRbl.getString("WSADMIN_SECURE"));
            this.setWSAdminConfig(confRbl.getString("WSADMIN_CONFIG"));
            this.setWSAdminHTTPListener(confRbl.getString("WSADMIN_HTTPLISTENER"));
            this.wsadmCommonParamsNoConfig = " --user=" + this.getWSAdminUser() + " --password-file=" + this.adminPassFile + " --host=" + this.getWSAdminHost() + " --port=" + this.getWSAdminPort() + " --ssl=" + this.isAdminPortSecure;
            this.wsAdminCommonParams = this.wsadmCommonParamsNoConfig + " --config=" + this.getWSAdminConfig();
            this.validateWSConfig();
            this.validateWSHttpListener();
            this.checkWebContainer64BitEnabled();
            this.fillCfgMap();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "WS7ContainerConfigInfo", "Failed to set webserver configuration information. ");
            throw new AMTuneException(ex.getMessage());
        }
        finally {
            File tempF = new File(this.tempFile);
            if (tempF.isFile()) {
                tempF.delete();
            }
        }
    }

    protected void writePasswordToFile(String password) throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "writePasswordToFile", "Creating WS7 password file.");
            if (password == null || password.trim().length() <= 0) {
                this.mWriter.writeLocaleMsg("pt-not-configured");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
                this.mWriter.writeln("WSADMIN_PASSWORD");
                throw new AMTuneException("Webserver admin password not set.");
            }
            File passFile = new File(this.adminPassFile);
            BufferedWriter pOut = new BufferedWriter(new FileWriter(passFile));
            pOut.write("wadm_password=");
            pOut.write(password);
            pOut.flush();
            pOut.close();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "writePassWordToFile", "Couldn't write password to file. ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public String getWSAdminPassFilePath() {
        return this.adminPassFile;
    }

    protected void setContainerInstanceName(String containerInstanceName) {
        if (containerInstanceName == null || containerInstanceName != null && containerInstanceName.trim().length() == 0) {
            super.setContainerInstanceName(AMTuneUtil.getHostName());
        } else {
            super.setContainerInstanceName(containerInstanceName.trim());
        }
    }

    protected void setContainerInstanceDir(String containerInstanceDir) throws AMTuneException {
        if (containerInstanceDir == null) {
            super.setContainerInstanceDir(this.getContainerBaseDir() + "/" + "https-" + this.getContainerInstanceName());
        } else {
            super.setContainerInstanceDir(containerInstanceDir);
        }
    }

    private void setWSAdminDir(String wsAdminDir) throws AMTuneException {
        File wsDir = new File(wsAdminDir);
        if (wsAdminDir == null || !wsDir.isDirectory()) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
            this.mWriter.writeln("WSADMIN_DIR");
            throw new AMTuneException("WS7 installation location is wrong.");
        }
        this.wsAdminDir = wsAdminDir.trim();
    }

    public String getWSAdminDir() {
        return this.wsAdminDir;
    }

    private void setWSAdminCmd() throws AMTuneException {
        this.wsAdminCmd = AMTuneUtil.isWindows2003() ? this.wsAdminDir + "/" + "wadm.bat " : this.wsAdminDir + "/" + "wadm ";
        File cmdFile = new File(this.wsAdminCmd.trim());
        if (cmdFile != null && !cmdFile.isFile()) {
            this.mWriter.write(this.wsAdminCmd);
            this.mWriter.writeLocaleMsg("pt-tool-not-found");
            this.mWriter.writeLocaleMsg("pt-cannot-proceed");
            throw new AMTuneException("Couldn't find wadm file.");
        }
    }

    public String getWSAdminCmd() {
        return this.wsAdminCmd;
    }

    private void setWSAdminHost(String wsAdminHost) {
        this.wsAdminHost = wsAdminHost != null ? wsAdminHost.trim() : AMTuneUtil.getHostName();
    }

    public String getWSAdminHost() {
        return this.wsAdminHost;
    }

    private void setWSAdminSecure(String wsAdminSecure) {
        this.isAdminPortSecure = wsAdminSecure != null && wsAdminSecure.indexOf("--ssl=true") != -1;
    }

    public boolean isAdminPortSecure() {
        return this.isAdminPortSecure;
    }

    private void setWSAdminConfig(String wsAdminConfig) {
        this.wsAdminConfig = wsAdminConfig == null ? this.getContainerInstanceName() : wsAdminConfig;
    }

    public String getWSAdminConfig() {
        return this.wsAdminConfig;
    }

    private void setWSAdminHTTPListener(String wsAdminHTTPListener) throws AMTuneException {
        if (wsAdminHTTPListener == null || wsAdminHTTPListener.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
            this.mWriter.writeln("WSADMIN_HTTPLISTENER ");
            throw new AMTuneException("WebServer http Listener is null.");
        }
        this.wsAdminHttpListener = wsAdminHTTPListener;
    }

    public String getWSAdminHttpListener() {
        return this.wsAdminHttpListener;
    }

    private void validateWSConfig() throws AMTuneException {
        StringBuffer resultBuffer;
        String resultCmd = this.getWSAdminCmd() + "list-configs" + this.wsadmCommonParamsNoConfig;
        int retVal = AMTuneUtil.executeCommand(resultCmd, resultBuffer = new StringBuffer());
        if (retVal == 0) {
            if (resultBuffer.toString().indexOf(this.getWSAdminConfig()) == -1) {
                this.mWriter.writeLocaleMsg("pt-web-conf-error");
                this.mWriter.write("WSADMIN_CONFIG ");
                this.mWriter.writelnLocaleMsg("pt-web-invalid");
                this.mWriter.writeLocaleMsg("pt-web-cur-wadm-settings");
                this.mWriter.writeln(this.getWSAdminConfig());
                this.mWriter.writeLocaleMsg("pt-web-cur-configs");
                this.mWriter.writeln(resultBuffer.toString());
                this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
                this.mWriter.writeln("WSADMIN_CONFIG");
                throw new AMTuneException("Web server config is wrong");
            }
        } else {
            this.mWriter.writelnLocaleMsg("pt-web-wadm-conf-error");
            this.mWriter.writeln(resultBuffer.toString());
            throw new AMTuneException(resultBuffer.toString());
        }
        this.pLogger.log(Level.INFO, "validateWSConfig", "Validated WS config " + resultBuffer.toString());
    }

    private void validateWSHttpListener() throws AMTuneException {
        StringBuffer resultBuffer;
        String resultCmd = this.getWSAdminCmd() + "list-http-listeners" + this.wsAdminCommonParams;
        int retVal = AMTuneUtil.executeCommand(resultCmd, resultBuffer = new StringBuffer());
        if (retVal == 0) {
            if (resultBuffer.toString().indexOf(this.getWSAdminHttpListener()) == -1) {
                this.mWriter.writeLocaleMsg("pt-web-cur-http-listener-msg");
                this.mWriter.writeln(this.getWSAdminHttpListener());
                this.mWriter.writeLocaleMsg("pt-web-cur-listeners");
                this.mWriter.writeln(resultBuffer.toString());
                this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
                this.mWriter.writeln("WSADMIN_HTTPLISTENER");
                throw new AMTuneException("Web server Http-Listener is not valid");
            }
        } else {
            this.mWriter.writelnLocaleMsg("pt-web-wadm-httplistener-error");
            this.mWriter.writeln(resultBuffer.toString());
            throw new AMTuneException(resultBuffer.toString());
        }
        this.pLogger.log(Level.INFO, "validateWSHttpListener", "Validated WS httplistener" + resultBuffer.toString());
    }

    private void checkWebContainer64BitEnabled() {
        this.mWriter.writelnLocaleMsg("pt-web-check-jvmbits");
        String jvmcmd = this.getWSAdminCmd() + "get-config-prop" + this.wsAdminCommonParams + " platform";
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = AMTuneUtil.executeCommand(jvmcmd, resultBuffer);
        if (retVal == 0) {
            if (resultBuffer.toString().indexOf("64") == -1) {
                this.setJVM64BitEnabled(false);
            } else {
                this.setJVM64BitEnabled(true);
            }
        } else {
            this.pLogger.log(Level.SEVERE, "checkWebContainer64BitEnabled", "Error checking jvm bits so using 32 bit. " + resultBuffer.toString());
            this.setJVM64BitEnabled(false);
        }
    }

    private void fillCfgMap() throws AMTuneException {
        try {
            this.pLogger.log(Level.INFO, "filCfgMap", "Getting server configuration information.");
            String propCmd = this.getWSAdminCmd() + "get-thread-pool-prop" + this.wsAdminCommonParams;
            String httpPropCmd = this.getWSAdminCmd() + "get-http-listener-prop" + this.wsAdminCommonParams + " --http-listener=" + this.getWSAdminHttpListener();
            String statsPropCmd = this.getWSAdminCmd() + "get-stats-prop" + this.wsAdminCommonParams;
            String jvmPropCmd = this.getWSAdminCmd() + "get-jvm-prop" + this.wsAdminCommonParams;
            String listJvmOptions = this.getWSAdminCmd() + "list-jvm-options" + this.wsAdminCommonParams;
            StringBuffer resultBuffer = new StringBuffer();
            String reqLine = "";
            this.cfgMap = new HashMap();
            int retVal = AMTuneUtil.executeCommand(propCmd, resultBuffer);
            if (retVal != 0) {
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting get-thread-pool-prop configuration information. " + resultBuffer.toString());
                throw new AMTuneException("Error getting thread pool prop.");
            }
            AMTuneUtil.writeResultBufferToTempFile(resultBuffer, this.tempFile);
            FileHandler cfgF = new FileHandler(this.tempFile);
            reqLine = cfgF.getLine("min-threads");
            this.cfgMap.put("min-threads", AMTuneUtil.getLastToken(reqLine, "="));
            reqLine = cfgF.getLine("max-threads");
            this.cfgMap.put("max-threads", AMTuneUtil.getLastToken(reqLine, "="));
            reqLine = cfgF.getLine("queue-size");
            this.cfgMap.put("queue-size", AMTuneUtil.getLastToken(reqLine, "="));
            reqLine = cfgF.getLine("stack-size");
            this.cfgMap.put("stack-size", AMTuneUtil.getLastToken(reqLine, "="));
            cfgF.close();
            resultBuffer.setLength(0);
            retVal = AMTuneUtil.executeCommand(httpPropCmd, resultBuffer);
            if (retVal != 0) {
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting get-http-listener-prop configuration information. " + resultBuffer.toString());
                throw new AMTuneException("Error getting http listener prop");
            }
            AMTuneUtil.writeResultBufferToTempFile(resultBuffer, this.tempFile);
            cfgF = new FileHandler(this.tempFile);
            reqLine = cfgF.getLine("acceptor-threads");
            this.cfgMap.put("acceptor-threads", AMTuneUtil.getLastToken(reqLine, "="));
            cfgF.close();
            resultBuffer.setLength(0);
            retVal = AMTuneUtil.executeCommand(statsPropCmd, resultBuffer);
            if (retVal != 0) {
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting get-stats-prop configuration information. " + resultBuffer.toString());
                throw new AMTuneException("Error getting stats prop.");
            }
            AMTuneUtil.writeResultBufferToTempFile(resultBuffer, this.tempFile);
            cfgF = new FileHandler(this.tempFile);
            reqLine = cfgF.getLine("enabled");
            this.cfgMap.put("enabled", AMTuneUtil.getLastToken(reqLine, "="));
            cfgF.close();
            resultBuffer.setLength(0);
            retVal = AMTuneUtil.executeCommand(listJvmOptions, resultBuffer);
            if (retVal == 0) {
                AMTuneUtil.writeResultBufferToTempFile(resultBuffer, this.tempFile);
                cfgF = new FileHandler(this.tempFile);
                reqLine = cfgF.getLine("-Xms");
                StringTokenizer st = new StringTokenizer(reqLine, " ");
                st.hasMoreElements();
                this.cfgMap.put("-Xms", st.nextToken());
                st.hasMoreTokens();
                this.cfgMap.put("-Xmx", st.nextToken());
                reqLine = cfgF.getLine("-Xloggc");
                this.cfgMap.put("-Xloggc", reqLine.trim());
                reqLine = cfgF.getLine("-server");
                this.cfgMap.put("-server", reqLine.trim());
                reqLine = cfgF.getLine("-Xss");
                this.cfgMap.put("-Xss", reqLine.trim());
                reqLine = cfgF.getLine("-XX:NewSize");
                this.cfgMap.put("-XX:NewSize", reqLine.trim());
                reqLine = cfgF.getLine("-XX:MaxNewSize");
                this.cfgMap.put("-XX:MaxNewSize", reqLine.trim());
                reqLine = cfgF.getLine("-XX:+DisableExplicitGC");
                this.cfgMap.put("-XX:+DisableExplicitGC", reqLine.trim());
                reqLine = cfgF.getLine("-XX:+UseParNewGC");
                this.cfgMap.put("-XX:+UseParNewGC", reqLine.trim());
                reqLine = cfgF.getLine("-XX:+PrintClassHistogram");
                this.cfgMap.put("-XX:+PrintClassHistogram", reqLine.trim());
                reqLine = cfgF.getLine("-XX:+PrintGCTimeStamps");
                this.cfgMap.put("-XX:+PrintGCTimeStamps", reqLine.trim());
                reqLine = cfgF.getLine("-XX:+UseConcMarkSweepGC");
                this.cfgMap.put("-XX:+UseConcMarkSweepGC", reqLine.trim());
                if (AMTuneUtil.isNiagara()) {
                    reqLine = cfgF.getLine("-XX:ParallelGCThreads");
                    this.cfgMap.put("-XX:ParallelGCThreads", AMTuneUtil.getLastToken(reqLine, "="));
                }
            } else {
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting list-jvm-options configuration information. " + resultBuffer.toString());
                throw new AMTuneException("Error gettig list jvm options.");
            }
            cfgF.close();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting server config information.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public String getWSAdmCommonParamsNoConfig() {
        return this.wsadmCommonParamsNoConfig;
    }

    public String getWSAdminCommonParams() {
        return this.wsAdminCommonParams;
    }

    public Map getServerCfgMap() {
        return this.cfgMap;
    }

    private void setWSAdminPort(String wsAdminPort) throws AMTuneException {
        if (wsAdminPort == null || wsAdminPort.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
            this.mWriter.writeln("WSADMIN_PORT");
            throw new AMTuneException("Invalid Web server Admin port.");
        }
        this.wsAdminPort = wsAdminPort.trim();
    }

    public String getWSAdminPort() {
        return this.wsAdminPort;
    }

    private void setWSAdminUser(String wsAdminUser) throws AMTuneException {
        if (wsAdminUser == null || wsAdminUser.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
            this.mWriter.writeln("WSADMIN_USER");
            throw new AMTuneException("Invalid Web server Admin User.");
        }
        this.wsAdminUser = wsAdminUser.trim();
    }

    public String getWSAdminUser() {
        return this.wsAdminUser;
    }
}

