/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.tools.ant.Project;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Info
extends SvnCommand {
    private String target = null;
    private boolean verbose = false;
    private String propPrefix = "svn.info.";
    private ISVNInfo info = null;
    private static final String[] DIR_PROP_NAMES = new String[]{"path", "url", "repouuid", "rev", "nodekind", "schedule", "author", "lastRev", "lastDate"};
    private static final String[] FILE_PROP_NAMES = new String[]{"path", "name", "url", "repouuid", "rev", "nodekind", "schedule", "author", "lastRev", "lastDate", "lastTextUpdate", "lastPropUpdate", "checksum"};

    public void execute() throws SvnAntException {
        Project project = this.getProject();
        try {
            this.info = this.acquireInfo();
            if (this.info.getRevision() == null || SVNRevision.INVALID_REVISION.equals((Object)this.info.getRevision())) {
                throw new SvnAntException(this.target + " - Not a versioned resource");
            }
            String[] stringArray = SVNNodeKind.DIR == this.info.getNodeKind() ? DIR_PROP_NAMES : FILE_PROP_NAMES;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = this.getValue(stringArray[i]);
                project.setProperty(this.propPrefix + stringArray[i], string);
                if (this.verbose) {
                    this.logInfo(this.propPrefix + stringArray[i] + ": " + string);
                    continue;
                }
                this.logVerbose(this.propPrefix + stringArray[i] + ": " + string);
            }
        }
        catch (Exception exception) {
            throw new SvnAntException("Failed to set 'info' properties", exception);
        }
    }

    private ISVNInfo acquireInfo() throws SVNClientException {
        File file = new File(Project.translatePath((String)this.target));
        if (file.exists()) {
            return this.svnClient.getInfo(file);
        }
        try {
            SVNUrl sVNUrl = new SVNUrl(this.target);
            return this.svnClient.getInfo(sVNUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return this.svnClient.getInfo(file);
        }
    }

    public String getValue(String string) {
        Object object = null;
        if (FILE_PROP_NAMES[0].equals(string)) {
            object = this.info.getFile();
            object = object != null ? ((File)object).getAbsolutePath() : this.info.getUrl().getLastPathSegment();
        } else if (FILE_PROP_NAMES[1].equals(string)) {
            object = this.info.getFile();
            object = object != null ? ((File)object).getName() : this.info.getUrl().getLastPathSegment();
        } else if (FILE_PROP_NAMES[2].equals(string)) {
            object = this.info.getUrl();
        } else if (FILE_PROP_NAMES[3].equals(string)) {
            object = this.info.getUuid();
        } else if (FILE_PROP_NAMES[4].equals(string)) {
            object = this.info.getRevision();
        } else if (FILE_PROP_NAMES[5].equals(string)) {
            object = this.info.getNodeKind();
        } else if (FILE_PROP_NAMES[6].equals(string)) {
            object = this.info.getSchedule();
        } else if (FILE_PROP_NAMES[7].equals(string)) {
            object = this.info.getLastCommitAuthor();
        } else if (FILE_PROP_NAMES[8].equals(string)) {
            object = this.info.getLastChangedRevision();
        } else if (FILE_PROP_NAMES[9].equals(string)) {
            object = this.info.getLastChangedDate();
        } else if (FILE_PROP_NAMES[10].equals(string)) {
            object = this.info.getLastDateTextUpdate();
        } else if (FILE_PROP_NAMES[11].equals(string)) {
            object = this.info.getLastDatePropsUpdate();
        } else if (FILE_PROP_NAMES[12].equals(string)) {
            this.log("    Property '" + string + "' not implemented", 1);
        } else if (this.verbose) {
            this.logInfo("    Property '" + string + "' not recognized");
        } else {
            this.logVerbose("    Property '" + string + "' not recognized");
        }
        return object == null ? "" : object.toString();
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.target == null) {
            throw new SvnAntValidationException("target must be set to a file or directory in your working copy, or to a URI");
        }
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setPropPrefix(String string) {
        this.propPrefix = string.endsWith(".") ? string : string + '.';
    }
}

