/*
 * Decompiled with CFR 0.152.
 */
package com.jera.anttasks;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class IncVersion
extends Task {
    private String file;

    public void setFile(String theFile) {
        this.file = theFile;
    }

    public void execute() throws BuildException {
        if (this.file == null) {
            throw new BuildException("Task <incversion> requires attribute \"file\"");
        }
        try {
            String newVersion = IncVersion.incFile(this.file);
            this.getProject().setProperty("version", newVersion);
            this.getProject().setProperty("cvsversion", IncVersion.toCvsVersion(newVersion));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static String incFile(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader reader = new BufferedReader(isr);
        String line = reader.readLine();
        reader.close();
        String incLine = IncVersion.increment(line);
        FileOutputStream fos = new FileOutputStream(fileName);
        OutputStreamWriter osw = new OutputStreamWriter(fos);
        PrintWriter writer = new PrintWriter(osw);
        writer.println(incLine);
        writer.close();
        return incLine;
    }

    public static String toCvsVersion(String version) {
        return version.replace('.', '_');
    }

    public static String increment(String oldVersion) {
        int offsetToSeparator = -1;
        if (oldVersion.lastIndexOf(".") > offsetToSeparator) {
            offsetToSeparator = oldVersion.lastIndexOf(".");
        }
        if (oldVersion.lastIndexOf("-") > offsetToSeparator) {
            offsetToSeparator = oldVersion.lastIndexOf("-");
        }
        if (oldVersion.lastIndexOf("_") > offsetToSeparator) {
            offsetToSeparator = oldVersion.lastIndexOf("_");
        }
        String oldVersionHead = oldVersion.substring(0, offsetToSeparator + 1);
        String oldVersionTail = oldVersion.substring(offsetToSeparator + 1);
        int value = Integer.parseInt(oldVersionTail);
        return oldVersionHead + Integer.toString(++value);
    }
}

