/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.memory;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.memory.MemoryMessageStore;
import org.apache.activemq.util.SubscriptionKey;

public class MemoryTopicMessageStore
extends MemoryMessageStore
implements TopicMessageStore {
    private Map ackDatabase;
    private Map subscriberDatabase;
    MessageId lastMessageId;
    static /* synthetic */ Class class$java$lang$String;

    public MemoryTopicMessageStore(ActiveMQDestination destination) {
        this(destination, new LinkedHashMap(), MemoryTopicMessageStore.makeMap(), MemoryTopicMessageStore.makeMap());
    }

    protected static Map makeMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    public MemoryTopicMessageStore(ActiveMQDestination destination, Map messageTable, Map subscriberDatabase, Map ackDatabase) {
        super(destination, messageTable);
        this.subscriberDatabase = subscriberDatabase;
        this.ackDatabase = ackDatabase;
    }

    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        super.addMessage(context, message);
        this.lastMessageId = message.getMessageId();
    }

    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        this.ackDatabase.put(new SubscriptionKey(clientId, subscriptionName), messageId);
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return (SubscriptionInfo)this.subscriberDatabase.get(new SubscriptionKey(clientId, subscriptionName));
    }

    public void addSubsciption(String clientId, String subscriptionName, String selector, boolean retroactive) throws IOException {
        MessageId l;
        SubscriptionInfo info = new SubscriptionInfo();
        info.setDestination(this.destination);
        info.setClientId(clientId);
        info.setSelector(selector);
        info.setSubcriptionName(subscriptionName);
        SubscriptionKey key = new SubscriptionKey(clientId, subscriptionName);
        this.subscriberDatabase.put(key, info);
        MessageId messageId = l = retroactive ? null : this.lastMessageId;
        if (l != null) {
            this.ackDatabase.put(key, l);
        }
    }

    public void deleteSubscription(String clientId, String subscriptionName) {
        SubscriptionKey key = new SubscriptionKey(clientId, subscriptionName);
        this.ackDatabase.remove(key);
        this.subscriberDatabase.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Exception {
        MessageId lastAck = (MessageId)this.ackDatabase.get(new SubscriptionKey(clientId, subscriptionName));
        boolean pastLastAck = lastAck == null;
        Map map = this.messageTable;
        synchronized (map) {
            Iterator iter = this.messageTable.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (pastLastAck) {
                    Object msg = entry.getValue();
                    if (msg.getClass() == (class$java$lang$String == null ? MemoryTopicMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                        listener.recoverMessageReference((String)msg);
                        continue;
                    }
                    listener.recoverMessage((Message)msg);
                    continue;
                }
                pastLastAck = entry.getKey().equals(lastAck);
            }
            listener.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverNextMessages(String clientId, String subscriptionName, MessageId lastMessageId, int maxReturned, MessageRecoveryListener listener) throws Exception {
        MessageId lastAck = (MessageId)this.ackDatabase.get(new SubscriptionKey(clientId, subscriptionName));
        boolean startFound = false;
        Map map = this.messageTable;
        synchronized (map) {
            int count = 0;
            Iterator iter = this.messageTable.entrySet().iterator();
            while (iter.hasNext() && count < maxReturned) {
                Map.Entry entry = iter.next();
                Object msg = entry.getValue();
                if (msg.getClass() == (class$java$lang$String == null ? MemoryTopicMessageStore.class$("java.lang.String") : class$java$lang$String)) {
                    String ref = msg.toString();
                    if (startFound || ref.equals(lastMessageId.toString())) {
                        startFound = true;
                        continue;
                    }
                    if (!startFound) continue;
                    listener.recoverMessageReference(ref);
                    ++count;
                    continue;
                }
                Message message = (Message)msg;
                if (startFound || message.getMessageId().equals(lastMessageId)) {
                    startFound = true;
                    continue;
                }
                if (!startFound) continue;
                listener.recoverMessage(message);
                ++count;
            }
            listener.finished();
        }
    }

    public void delete() {
        super.delete();
        this.ackDatabase.clear();
        this.subscriberDatabase.clear();
        this.lastMessageId = null;
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        return this.subscriberDatabase.values().toArray(new SubscriptionInfo[this.subscriberDatabase.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageId getNextMessageIdToDeliver(String clientId, String subscriptionName, MessageId id) throws IOException {
        boolean matchFound = false;
        Map map = this.messageTable;
        synchronized (map) {
            Iterator iter = this.messageTable.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!matchFound && entry.getKey().equals(id)) {
                    matchFound = true;
                    continue;
                }
                if (!matchFound) continue;
                Message msg = (Message)entry.getValue();
                return msg.getMessageId();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageId getPreviousMessageIdToDeliver(String clientId, String subscriptionName, MessageId id) throws IOException {
        Message last = null;
        Map map = this.messageTable;
        synchronized (map) {
            Iterator iter = this.messageTable.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (entry.getKey().equals(id)) {
                    return last != null ? last.getMessageId() : null;
                }
                last = (Message)entry.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        int result = 0;
        MessageId lastAck = (MessageId)this.ackDatabase.get(new SubscriptionKey(clientId, subscriberName));
        Map map = this.messageTable;
        synchronized (map) {
            Map.Entry entry;
            result = this.messageTable.size();
            Iterator iter = this.messageTable.entrySet().iterator();
            while (iter.hasNext() && !(entry = iter.next()).getKey().equals(lastAck)) {
                --result;
            }
        }
        return result;
    }

    public void resetBatching(String clientId, String subscriptionName, MessageId id) {
    }
}

