/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.AbstractCacheListener;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.JBossCacheWrapper;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;

public class CacheListener
extends AbstractCacheListener {
    private static final int JSESSION_FQN_INDEX = 0;
    private static final int HOSTNAME_FQN_INDEX = 1;
    private static final int WEBAPP_FQN_INDEX = 2;
    private static final int SESSION_ID_FQN_INDEX = 3;
    private static final int SESSION_FQN_SIZE = 4;
    private static final int POJO_ATTRIBUTE_FQN_INDEX = 4;
    private static final int POJO_KEY_FQN_INDEX = 5;
    private static final int POJO_KEY_FQN_SIZE = 6;
    private static final int BUDDY_BACKUP_ROOT_OWNER_INDEX = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN.size();
    private static final int BUDDY_BACKUP_ROOT_OWNER_SIZE = BUDDY_BACKUP_ROOT_OWNER_INDEX + 1;
    private static Logger log_ = Logger.getLogger(CacheListener.class);
    private JBossCacheWrapper cacheWrapper_;
    private JBossCacheManager manager_;
    private String webapp_;
    private String hostname_;
    private boolean fieldBased_;
    private boolean disdainLocalActivity_;

    CacheListener(JBossCacheWrapper wrapper, JBossCacheManager manager, String hostname, String webapp) {
        this.cacheWrapper_ = wrapper;
        this.manager_ = manager;
        this.hostname_ = hostname;
        this.webapp_ = webapp;
        int granularity = this.manager_.getReplicationGranularity();
        this.fieldBased_ = granularity == 2;
        this.disdainLocalActivity_ = granularity == 0;
    }

    public void nodeRemoved(Fqn fqn) {
        boolean local = SessionReplicationContext.isLocallyActive();
        if (!this.fieldBased_ && local) {
            return;
        }
        boolean isBuddy = CacheListener.isBuddyFqn(fqn);
        int size = fqn.size();
        if (CacheListener.isFqnSessionRootSized(size, isBuddy)) {
            if (!local && this.isFqnForOurWebapp(fqn, isBuddy)) {
                String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
                this.manager_.processRemoteInvalidation(sessId);
            }
        } else if (this.fieldBased_ && this.isFqnForOurWebapp(fqn, isBuddy)) {
            if (!local && CacheListener.isFqnPojoKeySized(size, isBuddy)) {
                String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
                String attrKey = CacheListener.getPojoKeyFromFqn(fqn, isBuddy);
                this.manager_.processRemoteAttributeRemoval(sessId, attrKey);
            } else if (local && CacheListener.isFqnInPojo(size, isBuddy)) {
                String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
                this.manager_.processLocalPojoModification(sessId);
            }
        }
    }

    public void nodeModified(Fqn fqn) {
        boolean local = SessionReplicationContext.isLocallyActive();
        if (!this.fieldBased_ && local) {
            return;
        }
        boolean isBuddy = CacheListener.isBuddyFqn(fqn);
        int size = fqn.size();
        if (CacheListener.isFqnSessionRootSized(size, isBuddy)) {
            if (!local && this.isFqnForOurWebapp(fqn, isBuddy)) {
                this.handleSessionRootModification(fqn, isBuddy);
            }
        } else if (this.fieldBased_ && local && this.isFqnForOurWebapp(fqn, isBuddy) && CacheListener.isFqnInPojo(size, isBuddy)) {
            String sessId = CacheListener.getIdFromFqn(fqn, isBuddy);
            this.manager_.processLocalPojoModification(sessId);
        }
    }

    private void handleSessionRootModification(Fqn fqn, boolean isBuddy) {
        if (!this.isFqnForOurWebapp(fqn, isBuddy)) {
            return;
        }
        Integer version = (Integer)this.cacheWrapper_.get(fqn, "VERSION");
        if (version != null) {
            String realId = CacheListener.getIdFromFqn(fqn, isBuddy);
            ClusteredSession session = this.manager_.findLocalSession(realId);
            if (session == null) {
                String owner = isBuddy ? CacheListener.getBuddyOwner(fqn) : null;
                this.manager_.unloadedSessionChanged(realId, owner);
            } else if (session.isNewData(version)) {
                session.setOutdatedVersion(version);
                if (log_.isTraceEnabled()) {
                    log_.trace((Object)("nodeDirty(): session in-memory data is invalidated with id: " + realId + " and version: " + version));
                }
            } else if (!isBuddy) {
                log_.info((Object)("Possible concurrency problem: Replicated version id " + version + " matches in-memory version for session " + realId));
                session.setOutdatedVersion(version);
            }
        } else {
            log_.warn((Object)("No VERSION_KEY attribute found in " + fqn));
        }
    }

    private boolean isFqnForOurWebapp(Fqn fqn, boolean isBuddy) {
        try {
            if (this.webapp_.equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 2 : 2)) && this.hostname_.equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 1 : 1)) && "JSESSION".equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 0 : 0))) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isFqnSessionRootSized(int size, boolean isBuddy) {
        return size == (isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 4 : 4);
    }

    private static boolean isFqnPojoKeySized(int size, boolean isBuddy) {
        return size == (isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 6 : 6);
    }

    private static boolean isFqnInPojo(int size, boolean isBuddy) {
        return size >= (isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 6 : 6);
    }

    private static String getIdFromFqn(Fqn fqn, boolean isBuddy) {
        return (String)fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 3 : 3);
    }

    private static String getPojoKeyFromFqn(Fqn fqn, boolean isBuddy) {
        return (String)fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 5 : 5);
    }

    private static boolean isBuddyFqn(Fqn fqn) {
        try {
            return "_BUDDY_BACKUP_".equals(fqn.get(0));
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private static String getBuddyOwner(Fqn fqn) {
        return (String)fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX);
    }
}

