/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.transport;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.transport.Transport;
import org.apache.ws.scout.transport.TransportException;
import org.apache.ws.scout.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LocalTransport
implements Transport {
    private static Log log = LogFactory.getLog(LocalTransport.class);

    public Element send(Element request, URI endpointURI) throws TransportException {
        Element response = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\nRequest message:\n" + XMLUtils.convertNodeToXMLString(request)));
            log.debug((Object)("Calling " + endpointURI + " locally"));
        }
        try {
            String className = endpointURI.getPath();
            String methodName = endpointURI.getFragment();
            log.debug((Object)("Calling class=" + className));
            log.debug((Object)("Method=" + methodName));
            Class<?> c = Class.forName(className);
            Object requestHandler = c.newInstance();
            Method method = c.getMethod(methodName, Element.class);
            Node node = (Node)method.invoke(requestHandler, request);
            response = (Element)node.getFirstChild();
        }
        catch (InvocationTargetException ite) {
            throw new TransportException(new Exception(ite.getTargetException().getMessage()));
        }
        catch (Exception ex) {
            throw new TransportException(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\nResponse message:\n" + XMLUtils.convertNodeToXMLString(response)));
        }
        return response;
    }

    public String send(String request, URI endpointURI) throws TransportException {
        String response = null;
        log.debug((Object)("\nRequest message:\n" + request));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(request);
            Element element = document.getDocumentElement();
            response = XMLUtils.convertNodeToXMLString(this.send(element, endpointURI));
        }
        catch (Exception ex) {
            throw new TransportException(ex);
        }
        log.debug((Object)("\nResponse message:\n" + response));
        return response;
    }
}

