/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.BitSet;
import org.apache.jackrabbit.core.query.lucene.CachingIndexReader;
import org.apache.jackrabbit.core.query.lucene.CommittableIndexReader;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.jackrabbit.core.query.lucene.SharedIndexReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractIndex {
    private static final Logger log = LoggerFactory.getLogger((Class)AbstractIndex.class);
    private static final LoggingPrintStream STREAM_LOGGER = new LoggingPrintStream();
    private IndexWriter indexWriter;
    private CommittableIndexReader indexReader;
    private Directory directory;
    private Analyzer analyzer;
    private boolean useCompoundFile = true;
    private int minMergeDocs = 100;
    private int maxMergeDocs = 100000;
    private int mergeFactor = 10;
    private int maxFieldLength = 10000;
    private DocNumberCache cache;
    private SharedIndexReader sharedReader;

    AbstractIndex(Analyzer analyzer, Directory directory, DocNumberCache cache) throws IOException {
        this.analyzer = analyzer;
        this.directory = directory;
        this.cache = cache;
        if (!IndexReader.indexExists((Directory)directory)) {
            this.indexWriter = new IndexWriter(directory, analyzer, true);
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    Directory getDirectory() throws IOException {
        return this.directory;
    }

    void addDocument(Document doc) throws IOException {
        this.getIndexWriter().addDocument(doc);
        this.invalidateSharedReader();
    }

    int removeDocument(Term idTerm) throws IOException {
        return this.getIndexReader().deleteDocuments(idTerm);
    }

    protected synchronized IndexReader getIndexReader() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            log.debug("closing IndexWriter.");
            this.indexWriter = null;
        }
        if (this.indexReader == null) {
            this.indexReader = new CommittableIndexReader(IndexReader.open((Directory)this.getDirectory()));
        }
        return this.indexReader;
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader() throws IOException {
        IndexReader modifiableReader = this.getIndexReader();
        BitSet deleted = new BitSet(modifiableReader.maxDoc());
        for (int i = 0; i < modifiableReader.maxDoc(); ++i) {
            if (!modifiableReader.isDeleted(i)) continue;
            deleted.set(i);
        }
        if (this.sharedReader == null) {
            CachingIndexReader cr = new CachingIndexReader(IndexReader.open((Directory)this.getDirectory()), this.cache);
            this.sharedReader = new SharedIndexReader(cr);
        }
        return new ReadOnlyIndexReader(this.sharedReader, deleted);
    }

    protected synchronized IndexWriter getIndexWriter() throws IOException {
        if (this.indexReader != null) {
            this.indexReader.close();
            log.debug("closing IndexReader.");
            this.indexReader = null;
        }
        if (this.indexWriter == null) {
            this.indexWriter = new IndexWriter(this.getDirectory(), this.analyzer, false);
            this.indexWriter.setMaxBufferedDocs(this.minMergeDocs);
            this.indexWriter.setMaxMergeDocs(this.maxMergeDocs);
            this.indexWriter.setMergeFactor(this.mergeFactor);
            this.indexWriter.setMaxFieldLength(this.maxFieldLength);
            this.indexWriter.setUseCompoundFile(this.useCompoundFile);
            this.indexWriter.setInfoStream((PrintStream)STREAM_LOGGER);
        }
        return this.indexWriter;
    }

    protected void commit() throws IOException {
        this.commit(false);
    }

    protected synchronized void commit(boolean optimize) throws IOException {
        if (!IndexReader.isLocked((Directory)this.getDirectory())) {
            return;
        }
        if (this.indexReader != null) {
            this.indexReader.commitDeleted();
        }
        if (this.indexWriter != null) {
            log.debug("committing IndexWriter.");
            this.indexWriter.close();
            this.indexWriter = null;
        }
        if (optimize) {
            IndexWriter writer = this.getIndexWriter();
            writer.optimize();
            writer.close();
            this.indexWriter = null;
        }
    }

    synchronized void close() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index writer: " + e.toString());
            }
            this.indexWriter = null;
        }
        if (this.indexReader != null) {
            try {
                this.indexReader.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
            this.indexReader = null;
        }
        if (this.sharedReader != null) {
            try {
                this.sharedReader.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
        }
        if (this.directory != null) {
            try {
                this.directory.close();
            }
            catch (IOException e) {
                this.directory = null;
            }
        }
    }

    protected synchronized void invalidateSharedReader() throws IOException {
        if (this.sharedReader != null) {
            this.sharedReader.close();
            this.sharedReader = null;
        }
    }

    void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
        if (this.indexWriter != null) {
            this.indexWriter.setUseCompoundFile(b);
        }
    }

    void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
        if (this.indexWriter != null) {
            this.indexWriter.setMaxBufferedDocs(minMergeDocs);
        }
    }

    void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
        if (this.indexWriter != null) {
            this.indexWriter.setMaxMergeDocs(maxMergeDocs);
        }
    }

    void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
        if (this.indexWriter != null) {
            this.indexWriter.setMergeFactor(mergeFactor);
        }
    }

    void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
        if (this.indexWriter != null) {
            this.indexWriter.setMaxFieldLength(maxFieldLength);
        }
    }

    private static final class LoggingPrintStream
    extends PrintStream {
        private StringBuffer buffer = new StringBuffer();

        public LoggingPrintStream() {
            super(new OutputStream(){

                public void write(int b) {
                }
            });
        }

        public void print(String s) {
            this.buffer.append(s);
        }

        public void println(String s) {
            this.buffer.append(s);
            log.debug(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }
}

