/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.cert.CertId;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.Extension;
import sun.security.x509.SerialNumber;
import sun.security.x509.X509CertImpl;

class OCSPResponse {
    public static final int CERT_STATUS_GOOD = 0;
    public static final int CERT_STATUS_REVOKED = 1;
    public static final int CERT_STATUS_UNKNOWN = 2;
    private static final Debug debug = SecurityDebug.debug;
    private static final boolean dump = false;
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID;
    private static final ObjectIdentifier OCSP_NONCE_EXTENSION_OID;
    private static final int OCSP_RESPONSE_OK = 0;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private SingleResponse singleResponse;

    /*
     * WARNING - void declaration
     */
    OCSPResponse(byte[] bytes, PKIXParameters params, X509Certificate responderCert) throws IOException, CertPathValidatorException {
        block35: {
            try {
                void cert;
                short tag;
                CertificateIssuerName responderName = null;
                DerValue der = new DerValue(bytes);
                if (der.tag != 48) {
                    throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
                }
                DerInputStream derIn = der.getData();
                int responseStatus = derIn.getEnumerated();
                if (debug.messageEnabled()) {
                    debug.message("OCSPResponse.OCSPResponse: responseStatus" + OCSPResponse.responseToText(responseStatus));
                }
                if (responseStatus != 0) {
                    throw new CertPathValidatorException("OCSP Response Failure: " + OCSPResponse.responseToText(responseStatus));
                }
                der = derIn.getDerValue();
                if (!der.isContextSpecific((byte)0)) {
                    throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
                }
                DerValue tmp = der.data.getDerValue();
                if (tmp.tag != 48) {
                    throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
                }
                derIn = tmp.data;
                ObjectIdentifier responseType = derIn.getOID();
                if (responseType.equals(OCSP_BASIC_RESPONSE_OID)) {
                    if (debug.messageEnabled()) {
                        debug.message("OCSPResponse.OCSPResponse: type: basic");
                    }
                } else {
                    if (debug.messageEnabled()) {
                        debug.message("OCSPResponse.OCSPResponse: type: " + responseType);
                    }
                    throw new IOException("Unsupported OCSP response type: " + responseType);
                }
                DerInputStream basicOCSPResponse = new DerInputStream(derIn.getOctetString());
                DerValue[] seqTmp = basicOCSPResponse.getSequence(2);
                DerValue responseData = seqTmp[0];
                byte[] responseDataDer = seqTmp[0].toByteArray();
                if (responseData.tag != 48) {
                    throw new IOException("Bad encoding in tbsResponseData  element of OCSP response: expected ASN.1 SEQUENCE tag.");
                }
                DerInputStream seqDerIn = responseData.data;
                DerValue seq = seqDerIn.getDerValue();
                if (seq.isContextSpecific((byte)0) && seq.isConstructed() && seq.isContextSpecific()) {
                    seq = seq.data.getDerValue();
                    int version = seq.getInteger();
                    if (seq.data.available() != 0) {
                        throw new IOException("Bad encoding in version  element of OCSP response: bad format");
                    }
                    seq = seqDerIn.getDerValue();
                }
                if ((tag = (short)((byte)(seq.tag & 0x1F))) == 1) {
                    responderName = new CertificateIssuerName(seq.getData());
                    if (debug.messageEnabled()) {
                        debug.message("OCSPResponse.OCSPResponse: Responder name: " + responderName);
                    }
                } else if (tag != 2) {
                    throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 0 or 1");
                }
                seq = seqDerIn.getDerValue();
                Date producedAtDate = seq.getGeneralizedTime();
                DerValue[] singleResponseDer = seqDerIn.getSequence(1);
                this.singleResponse = new SingleResponse(singleResponseDer[0]);
                if (seqDerIn.available() > 0 && (seq = seqDerIn.getDerValue()).isContextSpecific((byte)1)) {
                    DerValue[] responseExtDer = seq.data.getSequence(3);
                    Extension[] responseExtension = new Extension[responseExtDer.length];
                    for (int i = 0; i < responseExtDer.length; ++i) {
                        responseExtension[i] = new Extension(responseExtDer[i]);
                        if (debug.messageEnabled()) {
                            debug.message("OCSPResponse.OCSPResponse: extension: " + responseExtension[i]);
                        }
                        if (responseExtension[i].getExtensionId().equals(OCSP_NONCE_EXTENSION_OID)) {
                            byte[] ocspNonce = responseExtension[i].getExtensionValue();
                            continue;
                        }
                        if (!responseExtension[i].isCritical()) continue;
                        throw new IOException("Unsupported OCSP criticial extension: " + responseExtension[i].getExtensionId());
                    }
                }
                AlgorithmId sigAlgId = AlgorithmId.parse(seqTmp[1]);
                byte[] signature = seqTmp[2].getBitString();
                X509CertImpl[] x509Certs = null;
                if (seqTmp.length > 3) {
                    DerValue seqCert = seqTmp[3];
                    if (!seqCert.isContextSpecific((byte)0)) {
                        throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
                    }
                    DerValue[] certs = seqCert.getData().getSequence(3);
                    x509Certs = new X509CertImpl[certs.length];
                    for (int i = 0; i < certs.length; ++i) {
                        x509Certs[i] = new X509CertImpl(certs[i].toByteArray());
                    }
                }
                if (x509Certs[0] != null && !(cert = x509Certs[0]).equals(responderCert) && ((Object)cert.getIssuerDN()).equals(responderCert.getSubjectDN())) {
                    List<String> keyPurposes = cert.getExtendedKeyUsage();
                    if (keyPurposes == null || !keyPurposes.contains(KP_OCSP_SIGNING_OID)) {
                        if (debug.messageEnabled()) {
                            debug.message("OCSPResponse.OCSPResponse: Responder's certificate is not valid for signing OCSP responses.");
                        }
                        throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                    }
                    try {
                        cert.verify(responderCert.getPublicKey());
                        responderCert = cert;
                    }
                    catch (GeneralSecurityException e) {
                        responderCert = null;
                    }
                }
                if (responderCert != null) {
                    if (!this.verifyResponse(responseDataDer, responderCert, sigAlgId, signature, params)) {
                        if (debug.messageEnabled()) {
                            debug.message("OCSPResponse.OCSPResponse: Error verifying OCSP Responder's signature");
                        }
                        throw new CertPathValidatorException("Error verifying OCSP Responder's signature");
                    }
                    break block35;
                }
                if (debug.messageEnabled()) {
                    debug.message("OCSPResponse.OCSPResponse: Unable to verify OCSP Responder's signature");
                }
                throw new CertPathValidatorException("Unable to verify OCSP Responder's signature");
            }
            catch (CertPathValidatorException cpve) {
                throw cpve;
            }
            catch (Exception e) {
                throw new CertPathValidatorException(e);
            }
        }
    }

    private boolean verifyResponse(byte[] responseData, X509Certificate cert, AlgorithmId sigAlgId, byte[] signBytes, PKIXParameters params) throws SignatureException {
        try {
            Signature respSignature = Signature.getInstance(sigAlgId.getName());
            respSignature.initVerify(cert);
            respSignature.update(responseData);
            if (respSignature.verify(signBytes)) {
                if (debug.messageEnabled()) {
                    debug.message("OCSPResponse.verifyResponse: Verified signature of OCSP Responder");
                }
                return true;
            }
            if (debug.messageEnabled()) {
                debug.message("OCSPResponse.verifyResponse: Error verifying signature of OCSP Responder");
            }
            return false;
        }
        catch (InvalidKeyException ike) {
            throw new SignatureException(ike.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SignatureException(nsae.getMessage());
        }
    }

    int getCertStatus(SerialNumber sn) {
        return this.singleResponse.getStatus();
    }

    CertId getCertId() {
        return this.singleResponse.getCertId();
    }

    private static String responseToText(int status) {
        switch (status) {
            case 0: {
                return "Successful";
            }
            case 1: {
                return "Malformed request";
            }
            case 2: {
                return "Internal error";
            }
            case 3: {
                return "Try again later";
            }
            case 4: {
                return "Unused status code";
            }
            case 5: {
                return "Request must be signed";
            }
            case 6: {
                return "Request is unauthorized";
            }
        }
        return "Unknown status code: " + status;
    }

    static String certStatusToText(int certStatus) {
        switch (certStatus) {
            case 0: {
                return "Good";
            }
            case 1: {
                return "Revoked";
            }
            case 2: {
                return "Unknown";
            }
        }
        return "Unknown certificate status code: " + certStatus;
    }

    static {
        ObjectIdentifier tmp1 = null;
        ObjectIdentifier tmp2 = null;
        try {
            tmp1 = new ObjectIdentifier("1.3.6.1.5.5.7.48.1.1");
            tmp2 = new ObjectIdentifier("1.3.6.1.5.5.7.48.1.2");
        }
        catch (Exception exception) {
            // empty catch block
        }
        OCSP_BASIC_RESPONSE_OID = tmp1;
        OCSP_NONCE_EXTENSION_OID = tmp2;
    }

    private class SingleResponse {
        private CertId certId;
        private int certStatus;
        private Date thisUpdate;
        private Date nextUpdate;

        private SingleResponse(DerValue der) throws IOException {
            if (der.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream tmp = der.data;
            this.certId = new CertId(tmp.getDerValue().data);
            DerValue derVal = tmp.getDerValue();
            short tag = (byte)(derVal.tag & 0x1F);
            if (tag == 0) {
                this.certStatus = 0;
            } else if (tag == 1) {
                this.certStatus = 1;
                if (debug.messageEnabled()) {
                    Date revocationTime = derVal.data.getGeneralizedTime();
                    debug.message("OCSPResponse.SingleResponse.SingleResponse: Revocation time: " + revocationTime);
                }
            } else if (tag == 2) {
                this.certStatus = 2;
            } else {
                throw new IOException("Invalid certificate status");
            }
            this.thisUpdate = tmp.getGeneralizedTime();
            if (tmp.available() != 0) {
                derVal = tmp.getDerValue();
                tag = (byte)(derVal.tag & 0x1F);
                if (tag == 0) {
                    this.nextUpdate = derVal.data.getGeneralizedTime();
                    if (tmp.available() == 0) {
                        return;
                    }
                    derVal = tmp.getDerValue();
                    tag = (byte)(derVal.tag & 0x1F);
                }
            }
            Date now = new Date();
            if (debug.messageEnabled()) {
                String until = "";
                if (this.nextUpdate != null) {
                    until = " until " + this.nextUpdate;
                }
                debug.message("OCSPResponse.SingleResponse.SingleResponse: now is " + now);
                debug.message("OCSPResponse.SingleResponse.SingleResponse: Response's validity interval is from " + this.thisUpdate + until);
            }
            if (this.thisUpdate != null && now.before(this.thisUpdate) || this.nextUpdate != null && now.after(this.nextUpdate)) {
                if (debug.messageEnabled()) {
                    debug.message("OCSPResponse.SingleResponse.SingleResponse: Response is unreliable: its validity interval is out-of-date");
                }
                throw new IOException("Response is unreliable: its validity interval is out-of-date");
            }
        }

        private int getStatus() {
            return this.certStatus;
        }

        private CertId getCertId() {
            return this.certId;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SingleResponse:  \n");
            sb.append(this.certId);
            sb.append("\nCertStatus: " + OCSPResponse.certStatusToText(OCSPResponse.this.getCertStatus(null)) + "\n");
            sb.append("thisUpdate is " + this.thisUpdate + "\n");
            if (this.nextUpdate != null) {
                sb.append("nextUpdate is " + this.nextUpdate + "\n");
            }
            return sb.toString();
        }
    }
}

