/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared;

import java.net.MalformedURLException;
import java.net.URL;

public class FQDNUrl {
    private URL url;
    private boolean valid;
    private boolean fqdn;

    public FQDNUrl(String strURL) throws MalformedURLException {
        this.url = new URL(strURL);
        this.valid = strURL.startsWith("http://") || strURL.startsWith("https://");
        String host = this.url.getHost();
        this.fqdn = host.indexOf(".") != -1;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isFullyQualified() {
        return this.fqdn;
    }

    public URL getURL() {
        return this.url;
    }

    public String getURI() {
        int idx;
        String uri = this.url.getPath();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if ((idx = uri.indexOf(47)) != -1) {
            uri = uri.substring(0, idx);
        }
        return uri.length() > 0 ? "/" + uri : uri;
    }

    public String getProtocol() {
        return this.url.getProtocol();
    }

    public String getHost() {
        return this.url.getHost();
    }

    public String getPort() {
        return Integer.toString(this.url.getPort());
    }
}

