/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTH
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)AUTH.class);

    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        session.resetState();
        if (!request.hasArgument()) {
            out.write(FtpReplyUtil.translate(session, 501, "AUTH", null));
            return;
        }
        if (session.getListener().getSsl() == null) {
            out.write(FtpReplyUtil.translate(session, 431, "AUTH", null));
            return;
        }
        String authType = request.getArgument().toUpperCase();
        if (authType.equals("SSL")) {
            try {
                connection.beforeSecureControlChannel(session, "SSL");
                out.write(FtpReplyUtil.translate(session, 234, "AUTH.SSL", null));
                connection.afterSecureControlChannel(session, "SSL");
            }
            catch (FtpException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.LOG.warn("AUTH.execute()", (Throwable)ex);
                throw new FtpException("AUTH.execute()", (Throwable)ex);
            }
        } else if (authType.equals("TLS")) {
            try {
                connection.beforeSecureControlChannel(session, "TLS");
                out.write(FtpReplyUtil.translate(session, 234, "AUTH.TLS", null));
                connection.afterSecureControlChannel(session, "TLS");
            }
            catch (FtpException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.LOG.warn("AUTH.execute()", (Throwable)ex);
                throw new FtpException("AUTH.execute()", (Throwable)ex);
            }
        } else {
            out.write(FtpReplyUtil.translate(session, 502, "AUTH", null));
        }
    }
}

