/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.EntityDescriptorElement;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaSecurityUtils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.FederationConfigElement;
import com.sun.identity.wsfederation.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaSecurityUtils;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ExportMetaData
extends AuthenticatedCommand {
    private static Debug debug = SAML2MetaUtils.debug;
    private String realm;
    private String entityID;
    private boolean sign;
    private String metadata;
    private String extendedData;
    private boolean isWebBase;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.realm = this.getStringOptionValue("realm", "/");
        this.entityID = this.getStringOptionValue("entityid");
        this.sign = this.isOptionSet("sign");
        this.metadata = this.getStringOptionValue("meta-data-file");
        this.extendedData = this.getStringOptionValue("extended-data-file");
        String webURL = this.getCommandManager().getWebEnabledURL();
        boolean bl = this.isWebBase = webURL != null && webURL.trim().length() > 0;
        if (this.metadata == null && this.extendedData == null) {
            throw new CLIException(this.getResourceString("export-entity-exception-no-datafile"), 127);
        }
        String spec = FederationManager.getIDFFSubCommandSpecification(rc);
        if (spec.equals("saml2")) {
            this.handleSAML2Request(rc);
        } else if (spec.equals("idff")) {
            this.handleIDFFRequest(rc);
        } else if (spec.equals("wsfed")) {
            this.handleWSFedRequest(rc);
        } else {
            throw new CLIException(this.getResourceString("unsupported-specification"), 127);
        }
    }

    private void handleSAML2Request(RequestContext rc) throws CLIException {
        if (this.metadata != null) {
            if (this.sign) {
                this.runExportMetaSign();
            } else {
                this.runExportMeta();
            }
        }
        if (this.extendedData != null) {
            this.runExportExtended();
        }
    }

    private void handleIDFFRequest(RequestContext rc) throws CLIException {
        if (this.metadata != null) {
            if (this.sign) {
                this.runIDFFExportMetaSign();
            } else {
                this.runIDFFExportMeta();
            }
        }
        if (this.extendedData != null) {
            this.runIDFFExportExtended();
        }
    }

    private void handleWSFedRequest(RequestContext rc) throws CLIException {
        if (this.metadata != null) {
            if (this.sign) {
                this.runWSFedExportMetaSign();
            } else {
                this.runWSFedExportMeta();
            }
        }
        if (this.extendedData != null) {
            this.runWSFedExportExtended();
        }
    }

    private void runExportMetaSign() throws CLIException {
        PrintWriter pw = null;
        String out = this.isWebBase ? "web" : this.metadata;
        Object[] objs = new Object[]{out};
        try {
            IDPSSOConfigElement idpConfig;
            SAML2MetaManager metaManager = new SAML2MetaManager();
            com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement descriptor = metaManager.getEntityDescriptor(this.realm, this.entityID);
            if (descriptor == null) {
                Object[] objs2 = new Object[]{this.entityID, this.realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-entity-descriptor-not-exist"), objs2), 127);
            }
            com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement spConfig = metaManager.getSPSSOConfig(this.realm, this.entityID);
            Document doc = SAML2MetaSecurityUtils.sign((com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement)descriptor, (com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement)spConfig, (IDPSSOConfigElement)(idpConfig = metaManager.getIDPSSOConfig(this.realm, this.entityID)));
            if (doc == null) {
                this.runExportMeta();
                return;
            }
            String xmlstr = XMLUtils.print((Node)doc);
            xmlstr = ExportMetaData.workaroundAbstractRoleDescriptor(xmlstr);
            if (this.isWebBase) {
                this.getOutputWriter().printlnMessage(xmlstr);
            } else {
                pw = new PrintWriter(new FileWriter(this.metadata));
                pw.print(xmlstr);
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("export-entity-export-descriptor-succeeded"), objs));
        }
        catch (SAML2MetaException e) {
            debug.error("ExportMetaData.runExportMetaSign", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (JAXBException jaxbe) {
            Object[] objs3 = new Object[]{this.entityID, this.realm};
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid_descriptor"), objs3), 127);
        }
        catch (IOException e) {
            debug.error("ExportMetaData.runExportMetaSign", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private void runIDFFExportMetaSign() throws CLIException {
        PrintWriter pw = null;
        String out = this.isWebBase ? "web" : this.metadata;
        Object[] objs = new Object[]{out};
        try {
            IDFFMetaManager metaManager = new IDFFMetaManager((Object)this.getAdminSSOToken());
            EntityDescriptorElement descriptor = metaManager.getEntityDescriptor(this.realm, this.entityID);
            if (descriptor == null) {
                Object[] objs2 = new Object[]{this.entityID, this.realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-entity-descriptor-not-exist"), objs2), 127);
            }
            SPDescriptorConfigElement spConfig = metaManager.getSPDescriptorConfig(this.realm, this.entityID);
            IDPDescriptorConfigElement idpConfig = metaManager.getIDPDescriptorConfig(this.realm, this.entityID);
            Node doc = null;
            if (doc == null) {
                this.runIDFFExportMeta();
                return;
            }
            String xmlstr = XMLUtils.print(doc);
            if (this.isWebBase) {
                this.getOutputWriter().printlnMessage(xmlstr);
            } else {
                pw = new PrintWriter(new FileWriter(this.metadata));
                pw.print(xmlstr);
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("export-entity-export-descriptor-succeeded"), objs));
        }
        catch (IDFFMetaException e) {
            debug.error("ExportMetaData.runIDFFExportMetaSign", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (IOException e) {
            debug.error("ExportMetaData.runIDFFExportMetaSign", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private void runWSFedExportMetaSign() throws CLIException {
        PrintWriter pw = null;
        String out = this.isWebBase ? "web" : this.metadata;
        Object[] objs = new Object[]{out};
        try {
            com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement idpConfig;
            FederationElement descriptor = WSFederationMetaManager.getEntityDescriptor((String)this.realm, (String)this.entityID);
            if (descriptor == null) {
                Object[] objs2 = new Object[]{this.entityID, this.realm};
                throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-entity-descriptor-not-exist"), objs2), 127);
            }
            SPSSOConfigElement spConfig = WSFederationMetaManager.getSPSSOConfig((String)this.realm, (String)this.entityID);
            Document doc = WSFederationMetaSecurityUtils.sign((FederationElement)descriptor, (SPSSOConfigElement)spConfig, (com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement)(idpConfig = WSFederationMetaManager.getIDPSSOConfig((String)this.realm, (String)this.entityID)));
            if (doc == null) {
                this.runWSFedExportMeta();
                return;
            }
            String xmlstr = XMLUtils.print((Node)doc);
            if (this.isWebBase) {
                this.getOutputWriter().printlnMessage(xmlstr);
            } else {
                pw = new PrintWriter(new FileWriter(this.metadata));
                pw.print(xmlstr);
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("export-entity-export-descriptor-succeeded"), objs));
        }
        catch (WSFederationMetaException e) {
            debug.error("ExportMetaData.runExportMetaSign", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (JAXBException jaxbe) {
            Object[] objs3 = new Object[]{this.entityID, this.realm};
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid_descriptor"), objs3), 127);
        }
        catch (IOException e) {
            debug.error("ExportMetaData.runExportMetaSign", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private void runExportMeta() throws CLIException {
        if (debug.messageEnabled()) {
            debug.message("ExportMetaData.runExportMeta:");
        }
        PrintWriter pw = null;
        String out = this.isWebBase ? "web" : this.metadata;
        Object[] objs = new Object[]{out};
        Object[] objs2 = new Object[]{this.entityID, this.realm};
        try {
            SAML2MetaManager metaManager = new SAML2MetaManager();
            com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement descriptor = metaManager.getEntityDescriptor(this.realm, this.entityID);
            if (descriptor == null) {
                throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-entity-descriptor-not-exist"), objs2), 127);
            }
            String xmlstr = SAML2MetaUtils.convertJAXBToString((Object)descriptor);
            xmlstr = ExportMetaData.workaroundAbstractRoleDescriptor(xmlstr);
            xmlstr = SAML2MetaSecurityUtils.formatBase64BinaryElement((String)xmlstr);
            if (this.isWebBase) {
                this.getOutputWriter().printlnMessage(xmlstr);
            } else {
                pw = new PrintWriter(new FileWriter(this.metadata));
                pw.print(xmlstr);
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("export-entity-export-descriptor-succeeded"), objs));
        }
        catch (SAML2MetaException e) {
            debug.error("ExportMetaData.runExportMeta", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (IOException e) {
            debug.error("ExportMetaData.runExportMeta", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (JAXBException e) {
            debug.warning("ExportMetaData.runExportMeta", (Throwable)e);
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid_descriptor"), objs2), 127);
        }
        catch (IllegalArgumentException e) {
            debug.warning("ExportMetaData.runExportMeta", (Throwable)e);
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid_descriptor"), objs2), 127);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private void runIDFFExportMeta() throws CLIException {
        PrintWriter pw = null;
        String out = this.isWebBase ? "web" : this.metadata;
        Object[] objs = new Object[]{out};
        Object[] objs2 = new Object[]{this.entityID, this.realm};
        try {
            IDFFMetaManager metaManager = new IDFFMetaManager((Object)this.getAdminSSOToken());
            EntityDescriptorElement descriptor = metaManager.getEntityDescriptor(this.realm, this.entityID);
            if (descriptor == null) {
                throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-entity-descriptor-not-exist"), objs2), 127);
            }
            String xmlstr = IDFFMetaUtils.convertJAXBToString((Object)descriptor);
            xmlstr = SAML2MetaSecurityUtils.formatBase64BinaryElement((String)xmlstr);
            if (this.isWebBase) {
                this.getOutputWriter().printlnMessage(xmlstr);
            } else {
                pw = new PrintWriter(new FileWriter(this.metadata));
                pw.print(xmlstr);
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("export-entity-export-descriptor-succeeded"), objs));
        }
        catch (IDFFMetaException e) {
            debug.error("ExportMetaData.runIDFFExportMeta", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (IOException e) {
            debug.error("ExportMetaData.runIDFFExportMeta", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (JAXBException e) {
            debug.warning("ExportMetaData.runIDFFExportMeta", (Throwable)e);
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid_descriptor"), objs2), 127);
        }
        catch (IllegalArgumentException e) {
            debug.warning("ExportMetaData.runExportMeta", (Throwable)e);
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid_descriptor"), objs2), 127);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private void runWSFedExportMeta() throws CLIException {
        PrintWriter pw = null;
        String out = this.isWebBase ? "web" : this.metadata;
        Object[] objs = new Object[]{out};
        Object[] objs2 = new Object[]{this.entityID, this.realm};
        try {
            FederationElement federation = WSFederationMetaManager.getEntityDescriptor((String)this.realm, (String)this.entityID);
            if (federation == null) {
                throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-entity-descriptor-not-exist"), objs2), 127);
            }
            String xmlstr = WSFederationMetaUtils.convertJAXBToString((Object)federation);
            xmlstr = WSFederationMetaSecurityUtils.formatBase64BinaryElement((String)xmlstr);
            if (this.isWebBase) {
                this.getOutputWriter().printlnMessage(xmlstr);
            } else {
                pw = new PrintWriter(new FileWriter(this.metadata));
                pw.print(xmlstr);
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("export-entity-export-descriptor-succeeded"), objs));
        }
        catch (WSFederationMetaException e) {
            debug.error("ExportMetaData.runExportMeta", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (IOException e) {
            debug.error("ExportMetaData.runExportMeta", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (JAXBException e) {
            debug.warning("ExportMetaData.runExportMeta", (Throwable)e);
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid_descriptor"), objs2), 127);
        }
        catch (IllegalArgumentException e) {
            debug.warning("ExportMetaData.runExportMeta", (Throwable)e);
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid_descriptor"), objs2), 127);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private void runExportExtended() throws CLIException {
        OutputStream os = null;
        String out = this.isWebBase ? "web" : this.extendedData;
        Object[] objs = new Object[]{out};
        Object[] objs2 = new Object[]{this.entityID, this.realm};
        try {
            SAML2MetaManager metaManager = new SAML2MetaManager();
            EntityConfigElement config = metaManager.getEntityConfig(this.realm, this.entityID);
            if (config == null) {
                throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-entity-config-not-exist"), objs2), 127);
            }
            os = this.isWebBase ? new ByteArrayOutputStream() : new FileOutputStream(this.extendedData);
            SAML2MetaUtils.convertJAXBToOutputStream((Object)config, (OutputStream)os);
            if (this.isWebBase) {
                this.getOutputWriter().printlnMessage(os.toString());
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("export-entity-export-config-succeeded"), objs));
        }
        catch (SAML2MetaException e) {
            debug.error("ExportMetaData.runExportExtended", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (FileNotFoundException e) {
            debug.warning("ExportMetaData.runExportExtended", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (JAXBException e) {
            debug.warning("ExportMetaData.runExportExtended", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (IllegalArgumentException e) {
            debug.warning("ExportMetaData.runExportExtended", (Throwable)e);
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid-config"), objs2), 127);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void runIDFFExportExtended() throws CLIException {
        OutputStream os = null;
        String out = this.isWebBase ? "web" : this.extendedData;
        Object[] objs = new Object[]{out};
        Object[] objs2 = new Object[]{this.entityID, this.realm};
        try {
            IDFFMetaManager metaManager = new IDFFMetaManager((Object)this.getAdminSSOToken());
            com.sun.identity.federation.jaxb.entityconfig.EntityConfigElement config = metaManager.getEntityConfig(this.realm, this.entityID);
            if (config == null) {
                throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-entity-config-not-exist"), objs2), 127);
            }
            String xmlString = IDFFMetaUtils.convertJAXBToString((Object)config);
            if (this.isWebBase) {
                this.getOutputWriter().printlnMessage(xmlString);
            } else {
                os = new FileOutputStream(this.extendedData);
                os.write(xmlString.getBytes());
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("export-entity-export-config-succeeded"), objs));
        }
        catch (IDFFMetaException e) {
            debug.warning("ExportMetaData.runIDFFExportExtended", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (IOException e) {
            debug.warning("ExportMetaData.runIDFFExportExtended", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (JAXBException e) {
            debug.warning("ExportMetaData.runIDFFExportExtended", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (IllegalArgumentException e) {
            debug.warning("ExportMetaData.runIDFFExportExtended", (Throwable)e);
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid-config"), objs2), 127);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void runWSFedExportExtended() throws CLIException {
        OutputStream os = null;
        String out = this.isWebBase ? "web" : this.extendedData;
        Object[] objs = new Object[]{out};
        Object[] objs2 = new Object[]{this.entityID, this.realm};
        try {
            FederationConfigElement config = WSFederationMetaManager.getEntityConfig((String)this.realm, (String)this.entityID);
            if (config == null) {
                throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-entity-config-not-exist"), objs2), 127);
            }
            os = this.isWebBase ? new ByteArrayOutputStream() : new FileOutputStream(this.extendedData);
            WSFederationMetaUtils.convertJAXBToOutputStream((Object)config, (OutputStream)os);
            if (this.isWebBase) {
                this.getOutputWriter().printlnMessage(os.toString());
            }
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("export-entity-export-config-succeeded"), objs));
        }
        catch (WSFederationMetaException e) {
            debug.error("ExportMetaData.runExportExtended", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (FileNotFoundException e) {
            debug.warning("ExportMetaData.runExportExtended", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (JAXBException e) {
            debug.warning("ExportMetaData.runExportExtended", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
        catch (IllegalArgumentException e) {
            debug.warning("ExportMetaData.runExportExtended", (Throwable)e);
            throw new CLIException(MessageFormat.format(this.getResourceString("export-entity-exception-invalid-config"), objs2), 127);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String workaroundAbstractRoleDescriptor(String xmlstr) {
        int index;
        if (debug.messageEnabled()) {
            debug.message("ExportMetaData.workaroundAbstractRoleDescriptor:");
        }
        if ((index = xmlstr.indexOf(":AttributeQueryDescriptor")) == -1) {
            return xmlstr;
        }
        int index2 = xmlstr.lastIndexOf("<", index);
        if (index2 == -1) {
            return xmlstr;
        }
        String prefix = xmlstr.substring(index2 + 1, index);
        String type = prefix + ":" + "AttributeQueryDescriptorType";
        xmlstr = xmlstr.replaceAll("<" + prefix + ":" + "AttributeQueryDescriptor", "<RoleDescriptor xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"" + type + "\"");
        xmlstr = xmlstr.replaceAll("</" + prefix + ":" + "AttributeQueryDescriptor", "</RoleDescriptor");
        return xmlstr;
    }
}

