/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.plugin.datastore.impl;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.DNUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.SMSEntry;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class IdRepoDataStoreProvider
implements DataStoreProvider {
    private static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"fmDataStoreProvider");
    private static Debug debug = Debug.getInstance((String)"fmDataStoreProvider");
    private static Map idRepoMap = new HashMap();

    public IdRepoDataStoreProvider() {
        debug.message("IdRepoDataStoreProvider.constructor()");
    }

    public void init(String componentName) throws DataStoreProviderException {
    }

    public Set getAttribute(String userID, String attrName) throws DataStoreProviderException {
        if (userID == null) {
            throw new DataStoreProviderException(bundle.getString("nullUserId"));
        }
        if (attrName == null) {
            throw new DataStoreProviderException(bundle.getString("nullAttrName"));
        }
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            adminToken.setProperty("Organization", SMSEntry.getRootSuffix());
            AMIdentity amId = IdUtils.getIdentity((SSOToken)adminToken, (String)userID);
            return amId.getAttribute(attrName);
        }
        catch (SSOException ssoe) {
            debug.error("IdRepoDataStoreProvider.getAttribute(1): invalid admin SSOtoken", (Throwable)ssoe);
            throw new DataStoreProviderException(ssoe.getMessage());
        }
        catch (IdRepoException ide) {
            debug.error("IdRepoDataStoreProvider.getAttribute(1): IdRepo exception", (Throwable)ide);
            throw new DataStoreProviderException(ide.getMessage());
        }
    }

    public Map getAttributes(String userID, Set attrNames) throws DataStoreProviderException {
        if (userID == null) {
            throw new DataStoreProviderException(bundle.getString("nullUserId"));
        }
        if (attrNames == null) {
            throw new DataStoreProviderException(bundle.getString("nullAttrSet"));
        }
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            adminToken.setProperty("Organization", SMSEntry.getRootSuffix());
            AMIdentity amId = IdUtils.getIdentity((SSOToken)adminToken, (String)userID);
            return amId.getAttributes(attrNames);
        }
        catch (SSOException ssoe) {
            debug.error("IdRepoDataStoreProvider.getAttribute(2): invalid admin SSOtoken", (Throwable)ssoe);
            throw new DataStoreProviderException(ssoe.getMessage());
        }
        catch (IdRepoException ide) {
            debug.error("IdRepoDataStoreProvider.getAttribute(2): IdRepo exception", (Throwable)ide);
            throw new DataStoreProviderException(ide.getMessage());
        }
    }

    public void setAttributes(String userID, Map attrMap) throws DataStoreProviderException {
        if (userID == null) {
            throw new DataStoreProviderException(bundle.getString("nullUserId"));
        }
        if (attrMap == null) {
            throw new DataStoreProviderException(bundle.getString("nullAttrMap"));
        }
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            adminToken.setProperty("Organization", SMSEntry.getRootSuffix());
            AMIdentity amId = IdUtils.getIdentity((SSOToken)adminToken, (String)userID);
            amId.setAttributes(attrMap);
            amId.store();
        }
        catch (SSOException ssoe) {
            debug.error("IdRepoDataStoreProvider.setAttribute(): invalid admin SSOtoken", (Throwable)ssoe);
            throw new DataStoreProviderException(ssoe.getMessage());
        }
        catch (IdRepoException ide) {
            debug.error("IdRepoDataStoreProvider.setAttribute(): IdRepo exception", (Throwable)ide);
            throw new DataStoreProviderException(ide.getMessage());
        }
    }

    public String getUserID(String orgDN, Map avPairs) throws DataStoreProviderException {
        if (orgDN == null) {
            orgDN = SMSEntry.getRootSuffix();
        }
        if (avPairs == null || avPairs.size() == 0) {
            throw new DataStoreProviderException(bundle.getString("nullAvPair"));
        }
        Set amIdSet = null;
        try {
            IdSearchControl searchControl = IdRepoDataStoreProvider.getIdSearchControl(avPairs, IdSearchOpModifier.AND);
            AMIdentityRepository idRepo = this.getAMIdentityRepository(orgDN);
            IdSearchResults searchResults = idRepo.searchIdentities(IdType.USER, "*", searchControl);
            amIdSet = searchResults.getSearchResults();
        }
        catch (IdRepoException ame) {
            debug.error("IdRepoDataStoreProvider.getUserID(): IdRepoException", (Throwable)ame);
            throw new DataStoreProviderException(ame.getMessage());
        }
        catch (SSOException ssoe) {
            debug.error("IdRepoDataStoreProvider.getUserID() : SSOException", (Throwable)ssoe);
            throw new DataStoreProviderException(ssoe.getMessage());
        }
        if (amIdSet == null || amIdSet.isEmpty()) {
            debug.message("IdRepoDataStoreProvider.getUserID : user not found");
            return null;
        }
        if (amIdSet.size() > 1) {
            debug.message("IdRepoDataStoreProvider.getUserID : multiple match");
            throw new DataStoreProviderException(bundle.getString("multipleMatches"));
        }
        AMIdentity amId = (AMIdentity)amIdSet.iterator().next();
        if (debug.messageEnabled()) {
            debug.message("IdRepoDataStoreProvider.getUserID() Name=: " + amId.getName() + " DN=: " + amId.getDN() + " univId=: " + IdUtils.getUniversalId((AMIdentity)amId));
        }
        return DNUtils.normalizeDN((String)IdUtils.getUniversalId((AMIdentity)amId));
    }

    public boolean isUserExists(String userID) throws DataStoreProviderException {
        if (userID == null) {
            throw new DataStoreProviderException(bundle.getString("nullUserId"));
        }
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            adminToken.setProperty("Organization", SMSEntry.getRootSuffix());
            AMIdentity amId = IdUtils.getIdentity((SSOToken)adminToken, (String)userID);
            return amId.isActive();
        }
        catch (IdRepoException ide) {
            debug.message("IdRepoDataStoreProvider.isUserExists()", (Throwable)ide);
            return false;
        }
        catch (SSOException ssoe) {
            debug.error("IdRepoDataStoreProvider.isUserExists() : SSOException", (Throwable)ssoe);
            throw new DataStoreProviderException(ssoe.getMessage());
        }
    }

    private synchronized AMIdentityRepository getAMIdentityRepository(String realm) throws DataStoreProviderException {
        AMIdentityRepository amIdentityRepository = null;
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            adminToken.setProperty("Organization", SMSEntry.getRootSuffix());
            amIdentityRepository = (AMIdentityRepository)idRepoMap.get(realm);
            if (amIdentityRepository == null) {
                amIdentityRepository = new AMIdentityRepository(adminToken, realm);
                idRepoMap.put(realm, amIdentityRepository);
                if (debug.messageEnabled()) {
                    debug.message("IdRepoDataStoreProvider.getAMIdRepo :  create IdRepo for realm " + realm);
                }
            }
        }
        catch (IdRepoException ie) {
            debug.error("IdRepoDataStoreProvider.getAMIdRepo : IdRepoException: ", (Throwable)ie);
            throw new DataStoreProviderException(ie.getMessage());
        }
        catch (SSOException se) {
            debug.error("IdRepoDataStoreProvider.getAMIdRepo : SSOException: ", (Throwable)se);
            throw new DataStoreProviderException(se.getMessage());
        }
        return amIdentityRepository;
    }

    private static IdSearchControl getIdSearchControl(Map avPairs, IdSearchOpModifier modifier) {
        if (avPairs == null || avPairs.isEmpty()) {
            return null;
        }
        IdSearchControl searchControl = new IdSearchControl();
        searchControl.setTimeOut(0);
        searchControl.setMaxResults(0);
        searchControl.setAllReturnAttributes(false);
        searchControl.setSearchModifiers(IdSearchOpModifier.AND, avPairs);
        return searchControl;
    }
}

