/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.security.AssertionToken;
import com.sun.identity.wss.security.AssertionTokenSpec;
import com.sun.identity.wss.security.BinarySecurityToken;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SAML2TokenSpec;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.SecurityTokenSpec;
import com.sun.identity.wss.security.TokenProvider;
import com.sun.identity.wss.security.UserNameToken;
import com.sun.identity.wss.security.UserNameTokenSpec;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.security.X509TokenSpec;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509IssuerSerial;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;

public class AMTokenProvider
implements TokenProvider {
    private SSOToken ssoToken = null;
    private SecurityTokenSpec tokenSpec = null;
    private static XMLSignatureManager sigManager = null;
    private static KeyProvider keyProvider = null;
    private static Debug debug = WSSUtils.debug;
    private static ResourceBundle bundle = WSSUtils.bundle;

    public AMTokenProvider(SSOToken token) throws SSOException {
        SSOTokenManager.getInstance().validateToken(token);
        this.ssoToken = token;
        sigManager = WSSUtils.getXMLSignatureManager();
        keyProvider = sigManager.getKeyProvider();
    }

    public void init(SecurityTokenSpec tokenSpec) {
        this.tokenSpec = tokenSpec;
    }

    public SecurityToken getSecurityToken() throws SecurityException {
        if (this.tokenSpec == null) {
            throw new SecurityException(WSSUtils.bundle.getString("tokenSpecNotSpecified"));
        }
        if (this.tokenSpec instanceof AssertionTokenSpec) {
            AssertionToken assertionToken = new AssertionToken((AssertionTokenSpec)this.tokenSpec, this.ssoToken);
            String trustAlias = SystemConfigurationUtil.getProperty((String)"com.sun.identity.saml.xmlsig.certalias");
            assertionToken.sign(trustAlias);
            return assertionToken;
        }
        if (this.tokenSpec instanceof X509TokenSpec) {
            return new BinarySecurityToken((X509TokenSpec)this.tokenSpec);
        }
        if (this.tokenSpec instanceof UserNameTokenSpec) {
            return new UserNameToken((UserNameTokenSpec)this.tokenSpec);
        }
        if (this.tokenSpec instanceof SAML2TokenSpec) {
            SAML2Token saml2Token = new SAML2Token((SAML2TokenSpec)this.tokenSpec, this.ssoToken);
            String trustAlias = SystemConfigurationUtil.getProperty((String)"com.sun.identity.saml.xmlsig.certalias");
            saml2Token.sign(trustAlias);
            return saml2Token;
        }
        debug.error("AMTokenProvider.getSecurityToken:: unsupported token specification");
        throw new SecurityException(bundle.getString("unsupportedTokenSpec"));
    }

    static KeyProvider getKeyProvider() {
        return AMTokenProvider.getSignatureManager().getKeyProvider();
    }

    static XMLSignatureManager getSignatureManager() {
        return WSSUtils.getXMLSignatureManager();
    }

    static X509Certificate getX509Certificate(String alias) {
        return keyProvider.getX509Certificate(alias);
    }

    static List getX509Certificates(String[] alias) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 0; i < alias.length; ++i) {
            String aliasName = alias[i];
            X509Certificate cert = AMTokenProvider.getX509Certificate(aliasName);
            if (cert == null) continue;
            list.add(alias);
        }
        return list;
    }

    static X509Certificate loadCertificate(InputStream in) throws SecurityException {
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)AMTokenProvider.getCertificateFactory().generateCertificate(in);
        }
        catch (CertificateException ce) {
            debug.error("AMTokenProvider.loadCertificate:: failed to load certificate", (Throwable)ce);
        }
        return cert;
    }

    static CertificateFactory getCertificateFactory() throws SecurityException {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            throw new SecurityException(ce.getMessage());
        }
    }

    static X509Certificate getX509Certificate(X509Data x509Data) throws SecurityException {
        String issuerName = null;
        BigInteger serialNumber = null;
        try {
            XMLX509IssuerSerial issuerSerial = x509Data.itemIssuerSerial(0);
            issuerName = issuerSerial.getIssuerName();
            serialNumber = issuerSerial.getSerialNumber();
        }
        catch (XMLSecurityException xe) {
            throw new SecurityException(xe.getMessage());
        }
        X509Certificate x509cert = null;
        Certificate cert = null;
        try {
            JKSKeyProvider jksProvider = (JKSKeyProvider)keyProvider;
            KeyStore keystore = jksProvider.getKeyStore();
            Enumeration<String> e = keystore.aliases();
            while (e.hasMoreElements()) {
                String certDN;
                String alias = e.nextElement();
                Certificate[] certs = keystore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = keystore.getCertificate(alias);
                    if (cert == null) {
                        continue;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || (x509cert = (X509Certificate)cert).getSerialNumber().compareTo(serialNumber) != 0 || !(certDN = x509cert.getIssuerDN().getName()).equals(issuerName)) continue;
                return x509cert;
            }
        }
        catch (KeyStoreException e) {
            throw new SecurityException(bundle.getString("keystoreException"));
        }
        return null;
    }
}

