/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts.config;

import com.sun.identity.plugin.configuration.ConfigurationActionEvent;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.identity.wss.sts.config.FAMCallbackHandler;
import com.sun.identity.wss.sts.config.FAMTrustSPMetadata;
import com.sun.xml.ws.api.security.trust.config.STSConfiguration;
import com.sun.xml.ws.api.security.trust.config.TrustSPMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.callback.CallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAMSTSConfiguration
implements STSConfiguration,
ConfigurationListener {
    private static Map<String, TrustSPMetadata> spMap = new HashMap<String, TrustSPMetadata>();
    private static String type;
    private static String issuer;
    private static boolean encryptIssuedToken;
    private static boolean encryptIssuedKey;
    private static long issuedTokenTimeout;
    private static String stsEndpoint;
    private static String certAlias;
    private static String clientUserToken;
    private static List secMech;
    private static boolean isResponseSign;
    private static boolean isResponseEncrypt;
    private static boolean isRequestSign;
    private static boolean isRequestEncrypt;
    private static boolean isRequestHeaderEncrypt;
    private static String privateKeyType;
    private static String privateKeyAlias;
    private static String publicKeyAlias;
    private CallbackHandler callbackHandler;
    private Map<String, Object> otherOptions = new HashMap<String, Object>();
    static final String CONFIG_NAME = "STS_CONFIG";
    static final String SERVICE_NAME = "sunFAMSTSService";
    static final String ISSUER = "stsIssuer";
    static final String END_POINT = "stsEndPoint";
    static final String ENCRYPT_ISSUED_KEY = "stsEncryptIssuedKey";
    static final String ENCRYPT_ISSUED_TOKEN = "stsEncryptIssuedToken";
    static final String LIFE_TIME = "stsLifetime";
    static final String TOKEN_IMPL_CLASS = "stsTokenImplClass";
    static final String CERT_ALIAS = "stsCertAlias";
    static final String CLIENT_USER_TOKEN = "com.sun.identity.wss.sts.clientusertoken";
    static final String SEC_MECH = "SecurityMech";
    static final String RESPONSE_SIGN = "isResponseSign";
    static final String RESPONSE_ENCRYPT = "isResponseEncrypt";
    static final String REQUEST_SIGN = "isRequestSign";
    static final String REQUEST_ENCRYPT = "isRequestEncrypt";
    static final String REQUEST_HEADER_ENCRYPT = "isRequestHeaderEncrypt";
    static final String PRIVATE_KEY_TYPE = "privateKeyType";
    static final String PRIVATE_KEY_ALIAS = "privateKeyAlias";
    static final String PUBLIC_KEY_ALIAS = "publicKeyAlias";
    private static Debug debug;
    static ConfigurationInstance ci;

    public void configChanged(ConfigurationActionEvent e) {
        if (debug.messageEnabled()) {
            debug.message("FAMSTSConfiguration: configChanged");
        }
        FAMSTSConfiguration.setValues();
    }

    private static void setValues() {
        String classMethod = "FAMSTSConfiguration.setValues:";
        Map attrMap = null;
        try {
            attrMap = ci.getConfiguration(null, null);
        }
        catch (ConfigurationException ce) {
            debug.error(classMethod, (Throwable)ce);
            return;
        }
        Set values = (Set)attrMap.get(ISSUER);
        if (values != null && !values.isEmpty()) {
            issuer = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(END_POINT)) != null && !values.isEmpty()) {
            stsEndpoint = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(ENCRYPT_ISSUED_KEY)) != null && !values.isEmpty()) {
            encryptIssuedKey = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(ENCRYPT_ISSUED_TOKEN)) != null && !values.isEmpty()) {
            encryptIssuedToken = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(LIFE_TIME)) != null && !values.isEmpty()) {
            issuedTokenTimeout = Long.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(TOKEN_IMPL_CLASS)) != null && !values.isEmpty()) {
            type = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(CERT_ALIAS)) != null && !values.isEmpty()) {
            certAlias = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(CLIENT_USER_TOKEN)) != null && !values.isEmpty()) {
            clientUserToken = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(SEC_MECH)) != null && !values.isEmpty()) {
            String value = (String)values.iterator().next();
            if (secMech == null) {
                secMech = new ArrayList();
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                secMech.add(st.nextToken());
            }
        }
        if ((values = (Set)attrMap.get(RESPONSE_SIGN)) != null && !values.isEmpty()) {
            isResponseSign = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(RESPONSE_ENCRYPT)) != null && !values.isEmpty()) {
            isResponseEncrypt = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(REQUEST_SIGN)) != null && !values.isEmpty()) {
            isRequestSign = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(REQUEST_ENCRYPT)) != null && !values.isEmpty()) {
            isRequestEncrypt = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(REQUEST_HEADER_ENCRYPT)) != null && !values.isEmpty()) {
            isRequestHeaderEncrypt = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(PRIVATE_KEY_TYPE)) != null && !values.isEmpty()) {
            privateKeyType = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(PRIVATE_KEY_ALIAS)) != null && !values.isEmpty()) {
            privateKeyAlias = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(PUBLIC_KEY_ALIAS)) != null && !values.isEmpty()) {
            publicKeyAlias = (String)values.iterator().next();
        }
    }

    public void addTrustSPMetadata(TrustSPMetadata data, String spEndpoint) {
        spMap.put(spEndpoint, data);
    }

    public TrustSPMetadata getTrustSPMetadata(String spEndpoint) {
        FAMTrustSPMetadata data = new FAMTrustSPMetadata(spEndpoint);
        spMap.put(spEndpoint, data);
        return spMap.get(spEndpoint);
    }

    public void setType(String type) {
        FAMSTSConfiguration.type = type;
    }

    public String getType() {
        return type;
    }

    public void setIssuer(String issuer) {
        FAMSTSConfiguration.issuer = issuer;
    }

    public String getIssuer() {
        return issuer;
    }

    public void setEncryptIssuedToken(boolean encryptIssuedToken) {
        FAMSTSConfiguration.encryptIssuedToken = encryptIssuedToken;
    }

    public boolean getEncryptIssuedToken() {
        return encryptIssuedToken;
    }

    public void setEncryptIssuedKey(boolean encryptIssuedKey) {
        FAMSTSConfiguration.encryptIssuedKey = encryptIssuedKey;
    }

    public boolean getEncryptIssuedKey() {
        return encryptIssuedKey;
    }

    public void setIssuedTokenTimeout(long issuedTokenTimeout) {
        FAMSTSConfiguration.issuedTokenTimeout = issuedTokenTimeout;
    }

    public long getIssuedTokenTimeout() {
        return issuedTokenTimeout;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public CallbackHandler getCallbackHandler() {
        return new FAMCallbackHandler(certAlias);
    }

    public void setClientUserTokenClass(String clientUserTokenClass) {
        clientUserToken = clientUserTokenClass;
    }

    public String getClientUserTokenClass() {
        return clientUserToken;
    }

    public List getSecurityMechanisms() {
        return secMech;
    }

    public void setSecurityMechanisms(List authMech) {
        secMech = authMech;
    }

    public boolean isResponseSignEnabled() {
        return isResponseSign;
    }

    public void setResponseSignEnabled(boolean enable) {
        isResponseSign = enable;
    }

    public boolean isResponseEncryptEnabled() {
        return isResponseEncrypt;
    }

    public void setResponseEncryptEnabled(boolean enable) {
        isResponseEncrypt = enable;
    }

    public boolean isRequestSignEnabled() {
        return isRequestSign;
    }

    public void setRequestSignEnabled(boolean enable) {
        isRequestSign = enable;
    }

    public boolean isRequestEncryptEnabled() {
        return isRequestEncrypt;
    }

    public void setRequestEncryptEnabled(boolean enable) {
        isRequestEncrypt = enable;
    }

    public boolean isRequestHeaderEncryptEnabled() {
        return isRequestHeaderEncrypt;
    }

    public void setRequestHeaderEncryptEnabled(boolean enable) {
        isRequestHeaderEncrypt = enable;
    }

    public String getPrivateKeyType() {
        return privateKeyType;
    }

    public void setPrivateKeyType(String keyType) {
        privateKeyType = keyType;
    }

    public String getPrivateKeyAlias() {
        return privateKeyAlias;
    }

    public void setPrivateKeyAlias(String alias) {
        privateKeyAlias = alias;
    }

    public String getPublicKeyAlias() {
        return publicKeyAlias;
    }

    public void setPublicKeyAlias(String alias) {
        publicKeyAlias = alias;
    }

    public Map<String, Object> getOtherOptions() {
        return this.otherOptions;
    }

    static {
        encryptIssuedToken = false;
        encryptIssuedKey = true;
        secMech = null;
        isResponseSign = false;
        isResponseEncrypt = false;
        isRequestSign = false;
        isRequestEncrypt = false;
        isRequestHeaderEncrypt = false;
        debug = STSUtils.debug;
        ci = null;
        try {
            ci = ConfigurationManager.getConfigurationInstance((String)CONFIG_NAME);
            ci.addListener((ConfigurationListener)new FAMSTSConfiguration());
            FAMSTSConfiguration.setValues();
        }
        catch (ConfigurationException ce) {
            debug.error("FAMSTSConfiguration.static:", (Throwable)ce);
        }
    }
}

