/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.obl.MatchMethodEntry;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabase;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseActionType;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntry;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntryType;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.ml.SplitCamelCaseIdentifier;
import edu.umd.cs.findbugs.util.ExactStringMatcher;
import edu.umd.cs.findbugs.util.RegexStringMatcher;
import edu.umd.cs.findbugs.util.SubtypeTypeMatcher;
import java.util.Collection;
import java.util.Iterator;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class BuildObligationPolicyDatabase
implements Detector2,
NonReportingDetector {
    private static final boolean INFER_CLOSE_METHODS = SystemProperties.getBoolean("oa.inferclose", true);
    private static final boolean DEBUG_ANNOTATIONS = SystemProperties.getBoolean("oa.debug.annotations");
    private static final boolean DUMP_DB = SystemProperties.getBoolean("oa.dumpdb");
    private final BugReporter reporter;
    private final ObligationPolicyDatabase database;
    private final ClassDescriptor willClose;
    private final ClassDescriptor willNotClose;
    private final ClassDescriptor willCloseWhenClosed;
    private final ClassDescriptor cleanupObligation;
    private final ClassDescriptor createsObligation;
    private final ClassDescriptor dischargesObligation;
    private boolean sawAnnotationsInApplicationCode;

    public BuildObligationPolicyDatabase(BugReporter bugReporter) {
        this.reporter = bugReporter;
        this.willClose = DescriptorFactory.instance().getClassDescriptor("javax/annotation/WillClose");
        this.willNotClose = DescriptorFactory.instance().getClassDescriptor("javax/annotation/WillNotClose");
        this.willCloseWhenClosed = DescriptorFactory.instance().getClassDescriptor("javax/annotation/WillCloseWhenClosed");
        this.cleanupObligation = DescriptorFactory.instance().getClassDescriptor("edu/umd/cs/findbugs/annotations/CleanupObligation");
        this.createsObligation = DescriptorFactory.instance().getClassDescriptor("edu/umd/cs/findbugs/annotations/CreatesObligation");
        this.dischargesObligation = DescriptorFactory.instance().getClassDescriptor("edu/umd/cs/findbugs/annotations/DischargesObligation");
        this.database = new ObligationPolicyDatabase();
        this.addBuiltInPolicies();
        this.scanForResourceTypes();
        Global.getAnalysisCache().eagerlyPutDatabase(ObligationPolicyDatabase.class, this.database);
    }

    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, classDescriptor);
        Obligation thisClassObligation = this.database.getFactory().getObligationByType(xclass.getClassDescriptor());
        for (XMethod xMethod : xclass.getXMethods()) {
            if (thisClassObligation != null) {
                if (xMethod.getAnnotation(this.createsObligation) != null) {
                    this.database.addEntry(new MatchMethodEntry(xMethod, ObligationPolicyDatabaseActionType.ADD, thisClassObligation, ObligationPolicyDatabaseEntryType.STRONG));
                }
                if (xMethod.getAnnotation(this.dischargesObligation) != null) {
                    this.database.addEntry(new MatchMethodEntry(xMethod, ObligationPolicyDatabaseActionType.DEL, thisClassObligation, ObligationPolicyDatabaseEntryType.STRONG));
                }
            }
            Obligation[] paramObligationTypes = this.database.getFactory().getParameterObligationTypes(xMethod);
            boolean methodHasCloseInName = false;
            if (INFER_CLOSE_METHODS) {
                SplitCamelCaseIdentifier splitter = new SplitCamelCaseIdentifier(xMethod.getName());
                methodHasCloseInName = splitter.split().contains("close");
            }
            for (int i = 0; i < xMethod.getNumParams(); ++i) {
                if (paramObligationTypes[i] == null) continue;
                if (xMethod.getParameterAnnotation(i, this.willCloseWhenClosed) != null) {
                    this.handleWillCloseWhenClosed(xMethod, paramObligationTypes[i]);
                    continue;
                }
                if (xMethod.getParameterAnnotation(i, this.willClose) != null) {
                    if (paramObligationTypes[i] == null) {
                        if (DEBUG_ANNOTATIONS) {
                            System.out.println("Method " + xMethod.toString() + " has param " + i + " annotated @WillClose, " + "but its type is not an obligation type");
                        }
                    } else {
                        this.addParameterDeletesObligationDatabaseEntry(xMethod, paramObligationTypes[i], ObligationPolicyDatabaseEntryType.STRONG);
                    }
                    this.sawAnnotationsInApplicationCode = true;
                    continue;
                }
                if (xMethod.getParameterAnnotation(i, this.willNotClose) != null) {
                    this.sawAnnotationsInApplicationCode = true;
                    continue;
                }
                if (paramObligationTypes[i] == null) continue;
                if (INFER_CLOSE_METHODS && methodHasCloseInName) {
                    this.addParameterDeletesObligationDatabaseEntry(xMethod, paramObligationTypes[i], ObligationPolicyDatabaseEntryType.STRONG);
                    continue;
                }
                if (!xMethod.getName().equals("<init>") && !xMethod.isStatic() && xMethod.getName().toLowerCase().indexOf("close") < 0 && xMethod.getSignature().toLowerCase().indexOf("Closeable") < 0) continue;
                this.addParameterDeletesObligationDatabaseEntry(xMethod, paramObligationTypes[i], ObligationPolicyDatabaseEntryType.WEAK);
            }
        }
    }

    public void finishPass() {
        this.database.setStrictChecking(this.sawAnnotationsInApplicationCode);
        if (DUMP_DB || ObligationPolicyDatabase.DEBUG) {
            System.out.println("======= Completed ObligationPolicyDatabase ======= ");
            System.out.println("Strict checking is " + (this.database.isStrictChecking() ? "ENABLED" : "disabled"));
            for (ObligationPolicyDatabaseEntry entry : this.database.getEntries()) {
                System.out.println("  * " + entry);
            }
            System.out.println("================================================== ");
        }
    }

    public String getDetectorClassName() {
        return this.getClass().getName();
    }

    private void addBuiltInPolicies() {
        this.addFileStreamEntries("InputStream");
        this.addFileStreamEntries("OutputStream");
        this.addFileStreamEntries("Reader");
        this.addFileStreamEntries("Writer");
        Obligation connection = this.database.getFactory().addObligation("java.sql.Connection");
        Obligation statement = this.database.getFactory().addObligation("java.sql.Statement");
        Obligation resultSet = this.database.getFactory().addObligation("java.sql.ResultSet");
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(ObjectType.getInstance("java.sql.DriverManager")), new ExactStringMatcher("getConnection"), new RegexStringMatcher("^.*\\)Ljava/sql/Connection;$"), false, ObligationPolicyDatabaseActionType.ADD, connection, ObligationPolicyDatabaseEntryType.STRONG));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(ObjectType.getInstance("java.sql.Connection")), new ExactStringMatcher("createStatement"), new RegexStringMatcher("^.*\\)Ljava/sql/Statement;$"), false, ObligationPolicyDatabaseActionType.ADD, statement, ObligationPolicyDatabaseEntryType.STRONG));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(ObjectType.getInstance("java.sql.Connection")), new ExactStringMatcher("prepareStatement"), new RegexStringMatcher("^.*\\)Ljava/sql/PreparedStatement;$"), false, ObligationPolicyDatabaseActionType.ADD, statement, ObligationPolicyDatabaseEntryType.STRONG));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(ObjectType.getInstance("java.sql.Statement")), new ExactStringMatcher("executeQuery"), new RegexStringMatcher("^.*\\)Ljava/sql/ResultSet;$"), false, ObligationPolicyDatabaseActionType.ADD, resultSet, ObligationPolicyDatabaseEntryType.STRONG));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(ObjectType.getInstance("java.sql.Connection")), new ExactStringMatcher("close"), new ExactStringMatcher("()V"), false, ObligationPolicyDatabaseActionType.DEL, connection, ObligationPolicyDatabaseEntryType.STRONG));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(ObjectType.getInstance("java.sql.Statement")), new ExactStringMatcher("close"), new ExactStringMatcher("()V"), false, ObligationPolicyDatabaseActionType.DEL, statement, ObligationPolicyDatabaseEntryType.STRONG));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(ObjectType.getInstance("java.sql.ResultSet")), new ExactStringMatcher("close"), new ExactStringMatcher("()V"), false, ObligationPolicyDatabaseActionType.DEL, resultSet, ObligationPolicyDatabaseEntryType.STRONG));
    }

    private void addFileStreamEntries(String kind) {
        Obligation obligation = this.database.getFactory().addObligation("java.io." + kind);
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(ObjectType.getInstance("java.io.File" + kind)), new ExactStringMatcher("<init>"), new RegexStringMatcher(".*"), false, ObligationPolicyDatabaseActionType.ADD, obligation, ObligationPolicyDatabaseEntryType.STRONG));
        this.database.addEntry(new MatchMethodEntry(new SubtypeTypeMatcher(ObjectType.getInstance("java.io." + kind)), new ExactStringMatcher("close"), new ExactStringMatcher("()V"), false, ObligationPolicyDatabaseActionType.DEL, obligation, ObligationPolicyDatabaseEntryType.STRONG));
    }

    private void addParameterDeletesObligationDatabaseEntry(XMethod xmethod, Obligation obligation, ObligationPolicyDatabaseEntryType entryType) {
        MatchMethodEntry entry = new MatchMethodEntry(xmethod, ObligationPolicyDatabaseActionType.DEL, obligation, entryType);
        this.database.addEntry(entry);
        if (DEBUG_ANNOTATIONS) {
            System.out.println("Added entry: " + entry);
        }
    }

    private void handleWillCloseWhenClosed(XMethod xmethod, Obligation deletedObligation) {
        if (deletedObligation == null) {
            if (DEBUG_ANNOTATIONS) {
                System.out.println("Method " + xmethod.toString() + " is marked @WillCloseWhenClosed, " + "but its parameter is not an obligation");
            }
            return;
        }
        Obligation createdObligation = null;
        if (xmethod.getName().equals("<init>")) {
            createdObligation = this.database.getFactory().getObligationByType(xmethod.getClassDescriptor());
        } else {
            Type returnType = Type.getReturnType(xmethod.getSignature());
            if (returnType instanceof ObjectType) {
                try {
                    createdObligation = this.database.getFactory().getObligationByType((ObjectType)returnType);
                }
                catch (ClassNotFoundException e) {
                    this.reporter.reportMissingClass(e);
                    return;
                }
            }
        }
        if (createdObligation == null) {
            if (DEBUG_ANNOTATIONS) {
                System.out.println("Method " + xmethod.toString() + " is marked @WillCloseWhenClosed, " + "but its return type is not an obligation");
            }
            return;
        }
        this.database.addEntry(new MatchMethodEntry(xmethod, ObligationPolicyDatabaseActionType.DEL, deletedObligation, ObligationPolicyDatabaseEntryType.STRONG));
        this.database.addEntry(new MatchMethodEntry(xmethod, ObligationPolicyDatabaseActionType.ADD, createdObligation, ObligationPolicyDatabaseEntryType.STRONG));
    }

    private void scanForResourceTypes() {
        Subtypes2 subtypes2 = Global.getAnalysisCache().getDatabase(Subtypes2.class);
        Collection<XClass> knownClasses = subtypes2.getXClassCollection();
        for (XClass xclass : knownClasses) {
            if (xclass.getAnnotation(this.cleanupObligation) == null) continue;
            this.database.getFactory().addObligation(xclass.getClassDescriptor().toDottedClassName());
        }
        if (DEBUG_ANNOTATIONS) {
            System.out.println("After scanning for resource types:");
            Iterator<Obligation> i = this.database.getFactory().obligationIterator();
            while (i.hasNext()) {
                Obligation obligation = i.next();
                System.out.println("  " + obligation);
            }
        }
    }
}

