/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.remoting;

import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.http.HTTPMarshaller;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.transport.http.HTTPMetadataConstants;
import org.jboss.soa.esb.listeners.gateway.JBossRemotingGatewayListener;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/**
 * Extended version of the JBossRemoting HTTPMarshaller.
 * <p/>
 * Add support for byte[].
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class HttpMarshaller extends HTTPMarshaller {

    public void write(Object object, OutputStream outputStream, int version) throws IOException {
        if(object instanceof InvocationResponse) {
            Object result = ((InvocationResponse)object).getResult();
            InvocationRequest currentRequest = JBossRemotingGatewayListener.getCurrentRequest();
            boolean sendJavaResponse = false;

            if(result != null && currentRequest != null) {
                Map requestMetadata = currentRequest.getRequestPayload();
                Map responseMetadata = currentRequest.getReturnPayload();
                String userAgent = (String) requestMetadata.get(HTTPMetadataConstants.REMOTING_USER_AGENT);

                sendJavaResponse = JBossRemotingUtil.sendJavaObjectPayload(responseMetadata, userAgent);
            }
            
            if(!sendJavaResponse) {
                // This block of code tries to work around a bug in JBoss Remoting, while at the same time
                // providing backward compatibility for earlier versions of the ESB.  This code should not
                // have been present.  See https://jira.jboss.org/jira/browse/JBESB-2611
                if(result instanceof byte[]) {
                    outputStream.write((byte[])result);
                    outputStream.flush();
                } else {
                    // Going to rely on the base class to encode it anyway because
                    // we don't know....
                    super.write(object, outputStream, version);
                }
            } else {
                super.write(object, outputStream, version);
            }
        } else {
            if(object instanceof byte[]) {
                outputStream.write((byte[])object);
                outputStream.flush();
            } else {
                super.write(object, outputStream, version);
            }
        }
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new HttpMarshaller();
    }
}
