/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2009
 */
package org.jboss.soa.esb.actions.routing.http;

import java.net.URL;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;

/**
 * AbstractHttpMethodFactory.
 * 
 * @author dward at jboss.org
 */
public abstract class AbstractHttpMethodFactory implements HttpMethodFactory
{
	
	private URL endpoint;

    public void setEndpoint(URL endpoint)
    {
    	this.endpoint = endpoint;
    }
    
    protected String getEndpointPathAndQuery()
    {
    	StringBuilder sb = new StringBuilder();
    	String path = endpoint.getPath();
    	sb.append("".equals(path) ? "/" : path);
    	String query = endpoint.getQuery();
    	if (query != null)
    	{
    		sb.append("?");
    		sb.append(query);
    	}
    	return sb.toString();
    }
    
    public void setConfiguration(ConfigTree config) throws ConfigurationException {}

}
