/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.common;

public class Environment
{
        public enum Transports
        {
                File, FTP, JMS, SQL, Hibernate;
        }

        public static final String PROPERTIES_FILE = "org.jboss.soa.esb.propertyFile";

        /**
         * Binding properties
         */
        public static final String ESB_BIND_ADDRESS = "jboss.esb.bind.address" ;
        /*
         * Transport specific properties.
         */

    public static final String DEFAULT_INVM_SCOPE     = "jboss.esb.invm.scope.default";
    public static final String INVM_EXPIRY_TIME = "org.jboss.soa.esb.invm.expiryTime";
    public static final String INVM_RETRY_LIMIT = "org.jboss.soa.esb.invm.retry.limit";
    public static final String SQL_RETRY_LIMIT = "org.jboss.soa.esb.sql.retry.limit";

    public static final String SMTP_HOST     = "org.jboss.soa.esb.mail.smtp.host";
        public static final String SMTP_USERNAME = "org.jboss.soa.esb.mail.smtp.user";
        public static final String SMTP_PASSWORD = "org.jboss.soa.esb.mail.smtp.password";
        public static final String SMTP_PORT     = "org.jboss.soa.esb.mail.smtp.port";
        public static final String SMTP_FROM     = "org.jboss.soa.esb.mail.smtp.from";
        public static final String SMTP_AUTH     = "org.jboss.soa.esb.mail.smtp.auth";

		public static final String HTTP_HOST = "org.jboss.soa.esb.http.host";
		public static final String HTTP_PORT = "org.jboss.soa.esb.http.port";
		public static final String HTTP_SECURE_PORT = "org.jboss.soa.esb.http.securePort";
		public static final String HTTP_RESPONSE_STATUS_ENABLED = "org.jboss.soa.esb.http.responseStatusEnabled";

        public static final String FTP_LOCALDIR  = "org.jboss.soa.esb.ftp.localdir";
        public static final String FTP_REMOTEDIR = "org.jboss.soa.esb.ftp.remotedir";
        public static final String FTP_SOCKET_TIMEOUT = "org.jboss.soa.esb.ftp.timeout";
        public static final String FTP_RENAME_RETRY = "org.jboss.soa.esb.ftp.renameretry";

        public static final String JMS_CONNECTION_POOL_SIZE = "org.jboss.soa.esb.jms.connectionPool";
        public static final String JMS_SESSION_SLEEP        = "org.jboss.soa.esb.jms.sessionSleep";

        public static final String WS_RETURN_STACK_TRACE = "org.jboss.soa.esb.ws.returnStackTrace";
        public static final String WS_TIMEOUT = "org.jboss.soa.esb.ws.timeout" ;
        /*
         * Core properties
         */
        public static final String JNDI_SERVER_URL                = "org.jboss.soa.esb.jndi.server.url";
        public static final String JNDI_SERVER_CONTEXT_FACTORY    = "org.jboss.soa.esb.jndi.server.context.factory";
        public static final String JNDI_SERVER_PKG_PREFIX         = "org.jboss.soa.esb.jndi.server.pkg.prefix";
        public static final String JNDI_SERVER_TEST_LOOKUP         = "org.jboss.soa.esb.jndi.test.lookup";
        public static final String PARAMS_REPOS_IMPL_CLASS        = "org.jboss.soa.esb.paramsRepository.class";
        public static final String OBJECT_STORE_CONFIG_FILE       = "org.jboss.soa.esb.objStore.configFile";
        public static final String ENCRYPT_FACTORY_CLASS          = "org.jboss.soa.esb.encryption.factory.class";
    public static final String LOAD_BALANCER_POLICY           = "org.jboss.soa.esb.loadbalancer.policy";
    public static final String REDELIVER_DLS_SERVICE_ON       = "org.jboss.soa.esb.dls.redeliver";
    public static final String REGISTRY_CACHE_LIFE_MILLIS    = "org.jboss.soa.esb.registry.cache.life";
    public static final String REMOVE_DEAD_EPR                = "org.jboss.soa.esb.failure.detect.removeDeadEPR";
        public static final String EXCEPTION_ON_DELIVERY_FAILURE = "org.jboss.soa.esb.exceptionOnDeliverFailure";

        /**
         * The Registry Query Manager URI defines the endPoint where registry queries can be made.
         */
        public static final String REGISTRY_QUERY_MANAGER_URI     = "org.jboss.soa.esb.registry.queryManagerURI";
        /**
         * The Registry Lifecycle Manager URI defines the endPoint where service information can be published to.
         */
        public static final String REGISTRY_LIFECYCLE_MANAGER_URI = "org.jboss.soa.esb.registry.lifeCycleManagerURI";
        public static final String REGISTRY_SECURITY_MANAGER_URI = "org.jboss.soa.esb.registry.securityManagerURI";
    /**
     * The Registry Implementation class, a light wrapper class.
     */
        public static final String REGISTRY_IMPEMENTATION_CLASS = "org.jboss.soa.esb.registry.implementationClass";
        /**
         * The Registry Factory Class setting specifies which JAXR implementation should be used.
         */
        public static final String REGISTRY_FACTORY_CLASS         = "org.jboss.soa.esb.registry.factoryClass";
        /**
         * The user used to query and publish to the registry.
         */
        public static final String REGISTRY_USER                  = "org.jboss.soa.esb.registry.user";
        /**
         * The password for the registry user.
         */
        public static final String REGISTRY_PASSWORD              = "org.jboss.soa.esb.registry.password";
        /**
         * The Registry Scout Transport Class property defines which communication protocol Scout should use to communicate
         * with the UDDI registry. Note that this parameter is Scout specific.
         */
        public static final String REGISTRY_SCOUT_TRANSPORT_CLASS = "org.jboss.soa.esb.scout.proxy.transportClass";
        /**
         * The Registry Scout UDDI Version property defines which UDDI Version Scout should use to communicate
         * with the UDDI registry. Note that this parameter is Scout specific.
         */
        public static final String REGISTRY_SCOUT_UDDI_VERSION = "org.jboss.soa.esb.scout.proxy.uddiVersion";
        public static final String REGISTRY_SCOUT_UDDI_NAMESPACE = "org.jboss.soa.esb.scout.proxy.uddiNameSpace";
        /**
         * Property that holds directory to use with the helper EPRManager class.
         */
        public static final String REGISTRY_FILE_HELPER_DIR       = "org.jboss.soa.esb.registry.file.directory";
    /**
     * Property that holds the setting to the semantic equivalence scheme to use.
     */
        public static final String REGISTRY_SEMANTIC_EQUIVALENCES = "org.jboss.soa.esb.registry.semanticEquivalences";
    /**
     * Property that holds the postal address scheme.
     */
    public static final String REGISTRY_POSTAL_ADDRESS_SCHEME = "org.jboss.soa.esb.registry.postalAddressScheme";
    /**
     * Property that holds the authentican method the JAXR implementation is supposed to use.
     */
    public static final String REGISTRY_SECURITY_AUTHENTICATION_METHOD = "org.jboss.soa.esb.registry.security.authenticationMethod";
    /**
     * Property that holds the max number of rows the UDDI should return on searches.
     */
    public static final String REGISTRY_UDDI_MAX_ROWS          = "org.jboss.soa.esb.registry.uddi.maxRows";

    /**
     * The Registry interceptor class names.
     */
    public static final String REGISTRY_INTERCEPTORS = "org.jboss.soa.esb.registry.interceptors";
    /**
     * The maximum cache size for the registry.
     */
    public static final String REGISTRY_CACHE_MAX_SIZE = "org.jboss.soa.esb.registry.cache.maxSize";
    /**
     * The cache validity period.
     */
    public static final String REGISTRY_CACHE_VALIDITY_PERIOD = "org.jboss.soa.esb.registry.cache.validityPeriod";
    /**
     * The Registry Organization Category to be used by this deployment.
     */
    public static final String REGISTRY_ORG_CATEGORY = "org.jboss.soa.esb.registry.orgCategory";
        /*
         * Some default values.
         */
        public static final String DEFAULT_PROPERTY_FILE                  = "jbossesb-properties.xml";
        public static final String DEFAULT_HOST                           = "localhost";
        public static final String DEFAULT_USERNAME                       = "";
        public static final String DEFAULT_PASSWORD                       = "";
        public static final String DEFAULT_PORT                           = "25";
        public static final String DEFAULT_JNDI_CONTEXT_FACTORY           = "org.jnp.interfaces.NamingContextFactory";
        public static final String DEFAULT_JNDI_PKG_PREFIX                = "org.jnp.interfaces";
    public static final String DEFAULT_LOAD_BALANCER_POLICY           = "org.jboss.soa.esb.listeners.ha.FirstAvailable";
        public static final String DEFAULT_REDELIVER_DLS_ON               = "true";
    public static final String DEFAULT_REGISTRY_CACHE_LIFE_MILLIS    = "60000";
        /*
         * DatabaseMessageStore Persistence Store properties.
         */
        public static final String MSG_STORE_DB_CONNECTION_URL          = "org.jboss.soa.esb.persistence.db.connection.url";
        public static final String MSG_STORE_DB_CONNECTION_USER         = "org.jboss.soa.esb.persistence.db.user";
        public static final String MSG_STORE_DB_CONNECTION_PWD          = "org.jboss.soa.esb.persistence.db.pwd";
        public static final String MSG_STORE_DB_TABLE_NAME                      = "org.jboss.soa.esb.persistence.db.table";
        public static final String MSG_STORE_DB_JDBC_DRIVER                     = "org.jboss.soa.esb.persistence.db.jdbc.driver";
        public static final String MSG_STORE_DB_POOL_INITIAL_SIZE       = "org.jboss.soa.esb.persistence.db.pool.initial.size";
        public static final String MSG_STORE_DB_POOL_MIN_SIZE           = "org.jboss.soa.esb.persistence.db.pool.min.size";
        public static final String MSG_STORE_DB_POOL_MAX_SIZE           = "org.jboss.soa.esb.persistence.db.pool.max.size";
        public static final String MSG_STORE_DB_POOL_TEST_TABLE         = "org.jboss.soa.esb.persistence.db.pool.test.table";
        public static final String MSG_STORE_DB_POOL_TIMEOUT_MILLIS     = "org.jboss.soa.esb.persistence.db.pool.timeout.millis";
        public static final String MSG_STORE_DB_CONN_MANAGER            = "org.jboss.soa.esb.persistence.db.conn.manager";
        public static final String MSG_STORE_DB_DATASOURCE_NAME         = "org.jboss.soa.esb.persistence.db.datasource.name";

        /*
         * JcrMessageStore Persistence Store properties.
         */
        public static final String MSG_STORE_JCR_JNDI_PATH                      = "org.jboss.soa.esb.persistence.jcr.jndi.path";
        public static final String MSG_STORE_JCR_USERNAME                       = "org.jboss.soa.esb.persistence.jcr.username";
        public static final String MSG_STORE_JCR_PASSWORD                       = "org.jboss.soa.esb.persistence.jcr.password";
        public static final String MSG_STORE_JCR_ROOT_NODE_PATH         = "org.jboss.soa.esb.persistence.jcr.root.node.path";

        /*
         * Some message metadata properties.
         */

        public static final String TRANSPORT_TYPE = "org.jboss.soa.esb.message.transport.type";
        public static final String MESSAGE_SOURCE = "org.jboss.soa.esb.message.source";
        public static final String MESSAGE_ENTRY_TIME = "org.jboss.soa.esb.message.time.dob"; // time born
        public static final String MESSAGE_EXIT_TIME = "org.jboss.soa.esb.message.time.dod";  // time died
        public static final String MESSAGE_BYTE_SIZE = "org.jboss.soa.esb.message.byte.size"; // size
        public static final String MESSAGE_TIME_PROCESSED = "org.jboss.soa.esb.message.time.processed"; // 
        
        /** Message property name for original filename */

        public static final String ORIGINAL_FILE_NAME_MSG_PROP = "org.jboss.soa.esb.gateway.original.file.name";
        public static final String ORIGINAL_QUEUE_NAME_MSG_PROP = "org.jboss.soa.esb.gateway.original.queue.name";
        public static final String ORIGINAL_URL_PROP = "org.jboss.soa.esb.gateway.original.url";

        /*
         * Some gateway attachment names.
         */

        public static final String ORIGINAL_FILE = "org.jboss.soa.esb.gateway.file";
        public static final String GATEWAY_CONFIG = "org.jboss.soa.esb.gateway.config";

        /*
         * Some JMS specific message element names.
         */

        public static final String JMS_MESSAGE_ID = "org.jboss.soa.esb.message.transport.jms.messageID";
        public static final String JMS_NATIVE_MESSAGE_TYPE = "org.jboss.soa.esb.message.transport.jms.nativeMessageType"; // Text or Object

        /*
         * Filter properties should be identified by:
         *
         * org.jboss.soa.esb.filter.<number>
         *
         * and will be called in increasing order of <number>. Same <number> may be
         * called arbitrarily.
         */

        public static final String FILTER_NAME = "org.jboss.soa.esb.filter";

        /*
         * Some specific out-of-the-box filter configuration options.
         */

        public static final String MESSAGE_TRACE = "org.jboss.soa.esb.messagetrace"; // on or off
        public static final String PER_MESSAGE_TRACE = "org.jboss.soa.esb.permessagetrace"; // on or off

    /**
     * The SecurityService Implementation class
     */
        public static final String SECURITY_SERVICE_IMPEMENTATION_CLASS         = "org.jboss.soa.esb.services.security.implementationClass";
        public static final String SECURITY_SERVICE_CALLBACK_HANLDER_CLASS      = "org.jboss.soa.esb.services.security.callbackHandler";
        public static final String SECURITY_SERVICE_CALLBACK                            = "org.jboss.soa.esb.services.security.callback_";
        public static final String SECURITY_SERVICE_CONFIG_URL                          = "org.jboss.soa.esb.services.security.configUrl";
        public static final String SECURITY_SERVICE_SEAL_ALGORITHM                      = "org.jboss.soa.esb.services.security.sealAlgorithm";
        public static final String SECURITY_SERVICE_SEAL_KEYSIZE                        = "org.jboss.soa.esb.services.security.sealKeySize";
	public static final String SECURITY_SERVICE_CONTEXT_TIMEOUT			= "org.jboss.soa.esb.services.security.contextTimeout";
	public static final String SECURITY_SERVICE_CONTEXT_PROPAGATOR_CLASS= "org.jboss.soa.esb.services.security.contextPropagatorImplementationClass";
	public static final String SECURITY_JBOSSAS_SECURITY_CONTEXT_OPERATIONS_CLASS = "org.jboss.internal.soa.esb.services.security.jbossasSecurityContextOperationsImplementationClass" ;

        public static final String SECURITY_SERVICE_PUBLIC_KEYSTORE             = "org.jboss.soa.esb.services.security.publicKeystore";
        public static final String SECURITY_SERVICE_PUBLIC_KEYSTORE_TYPE        = "org.jboss.soa.esb.services.security.publicKeystoreType";
        public static final String SECURITY_SERVICE_PUBLIC_KEYSTORE_PASS        = "org.jboss.soa.esb.services.security.publicKeystorePassword";
        public static final String SECURITY_SERVICE_PUBLIC_KEY_ALIAS        = "org.jboss.soa.esb.services.security.publicKeyAlias";
        public static final String SECURITY_SERVICE_PUBLIC_KEY_PASS             = "org.jboss.soa.esb.services.security.publicKeyPassword";
        public static final String SECURITY_SERVICE_PUBLIC_KEY_TRANSFORMATION = "org.jboss.soa.esb.services.security.publicKeyTransformation";

        /** Message property name for EBWS WS-A properties*/

        public static final String WSA_MESSAGE_ID = "org.jboss.soa.esb.gateway.ebws.messageID" ;
        public static final String WSA_RELATES_TO = "org.jboss.soa.esb.gateway.ebws.relatesTo";
        public static final String WSA_RELATIONSHIP_TYPE = "org.jboss.soa.esb.gateway.ebws.relationshipType";

        // Configuration options for the Naming Context pooling.
        /**
         * The maximum pool size.
         */
        public static final String NAMING_CONTEXT_POOL_SIZE = "org.jboss.soa.esb.namingcontext.poolsize" ;
        /**
         * The maximum sleep period when waiting for a naming context, specified in seconds.
         */
        public static final String NAMING_CONTEXT_SLEEP_PERIOD = "org.jboss.soa.esb.namingcontext.sleepperiod" ;
        /**
         * The maximum number of retries when creating a naming context.
         */
        public static final String NAMING_CONTEXT_RETRY_COUNT = "org.jboss.soa.esb.namingcontext.retrycount" ;
        /**
         * The JBoss JNDI provider URL.
         */
        public static final String JBOSS_PROVIDER_URL = "localhost";
        /**
         * The JBoss JNDI initial context factory.
         */
        public static final String JBOSS_INITIAL_CONTEXT_FACTORY = "org.jnp.interfaces.NamingContextFactory";
        /**
         * The JBoss JNDI URL package prefix.
         */
        public static final String JBOSS_URL_PKG_PREFIX = ""; //"org.jboss.naming:org.jnp.interfaces"

        /**
         * Configuration options for JCA ActivationMappers
         *
         * org.jboss.soa.esb.jca.activation.mapper.&lt;adapterName&gt;
         */
        public static final String JCA_ACTIVATION_MAPPER = "org.jboss.soa.esb.jca.activation.mapper" ;
        
        /**
         * The default rules continue state.
         */
        public static final String RULES_CONTINUE_STATE = "org.jboss.soa.esb.services.rules.continueState" ;
}
