/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.helpers.persist;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.util.ClassUtil;

public abstract class SqlDbTable
{
	protected String m_sTableName;

	protected SqlField[] m_oaFields;

	protected PreparedStatement[] m_oaPS;

	private JdbcCleanConn m_oConn;

	public JdbcCleanConn getConn ()
	{
		return m_oConn;
	}

	public final String getTableName ()
	{
		return m_sTableName;
	}

	public final SqlField[] getAllFields ()
	{
		return m_oaFields;
	}

	private String m_sInsertSql, m_sUpdateSql, m_sDeleteSql;

	protected String m_sSelectSql;

	public SqlDbTable (JdbcCleanConn p_oC, String p_sTblNm) throws SQLException, ConfigurationException
	{
		m_oConn = p_oC;
		m_sTableName = p_sTblNm;
		initFields();
	} // ________________________________

	public abstract int setInsValues (PreparedStatement p_PS, Object bobj)
			throws SQLException;

	public abstract Object getFromRS (ResultSet p_oRS) throws SQLException;

	protected abstract String getSelectFields ();

	public String getFldName (int p_i)
	{
		return (null == m_oaFields) ? null : (p_i < 0) ? null : (p_i >= m_oaFields.length) ? null : m_oaFields[p_i]
				.getFieldName();
	} // ________________________________

	public String getSelectStatement ()
	{
		if (m_sSelectSql != null) return m_sSelectSql;
		StringBuffer sb = new StringBuffer("select ").append(getSelectFields());
		m_sSelectSql = sb.append(" from ").append(getTableName()).toString();
		return m_sSelectSql;
	} // ________________________________

	public String getInsertStatement ()
	{
		if (m_sInsertSql != null) return m_sInsertSql;

		StringBuffer sb = new StringBuffer(256);
		sb.append("insert into ").append(getTableName());

		sb.append(" values (");
		for (int i = 0; i < m_oaFields.length; i++)
			((i < 1) ? sb : sb.append(",")).append('?');
		sb.append(')');

		return (m_sInsertSql = sb.toString());
	} // ________________________________

	public String getUpdateStatement ()
	{
		if (m_sUpdateSql != null) return m_sUpdateSql;

		StringBuffer sb = new StringBuffer(256);
		sb.append("update ").append(getTableName()).append(" set ");

		StringBuffer sbWhere = new StringBuffer(" where ");

		int iVal = 0;
		int iWh = 0;
		for (int i = 0; i < m_oaFields.length; i++)
		{
			SqlField oCurr = m_oaFields[i];
			if (oCurr.isPrimaryKey()) ((iWh++ < 1) ? sbWhere : sbWhere
					.append(" and ")).append(oCurr.getFieldName()).append(
					" = ?");
			else
				((iVal++ < 1) ? sb : sb.append(",")).append(
						oCurr.getFieldName()).append(" = ?");
		}
		sb.append(sbWhere);

		return (m_sUpdateSql = sb.toString());
	} // ________________________________

	public String getDeleteStatement ()
	{
		if (m_sDeleteSql != null) return m_sDeleteSql;

		StringBuffer sb = new StringBuffer(256);
		sb.append("delete from ").append(getTableName()).append(" where ");

		int iWh = 0;
		for (int i = 0; i < m_oaFields.length; i++)
		{
			SqlField oCurr = m_oaFields[i];
			if (!oCurr.isPrimaryKey()) continue;
			((iWh++ < 1) ? sb : sb.append(" and "))
					.append(oCurr.getFieldName()).append(" = ?");
		}

		return (m_sDeleteSql = sb.toString());
	} // ________________________________

	public void setObject (PreparedStatement p_PS, int p_iFld, Object p_sFldVal)
			throws SQLException
	{
		if (null != p_sFldVal) if (p_sFldVal instanceof String)
		{
			String sTr = ((String) p_sFldVal).trim();
			p_sFldVal = (sTr.length() > 0) ? sTr : null;
		}
		;
		int iSqlIdx = 1 + p_iFld;
		if (null == p_sFldVal) p_PS.setNull(iSqlIdx, m_oaFields[p_iFld]
				.getSqlType());
		else
			p_PS.setObject(iSqlIdx, p_sFldVal);
	} // ________________________________

	public void setLong (PreparedStatement p_PS, int p_iFld, long p_lVal)
			throws SQLException
	{
		p_PS.setLong(1 + p_iFld, p_lVal);
	} // ________________________________

	public void setInt (PreparedStatement p_PS, int p_iFld, int p_iVal)
			throws SQLException
	{
		p_PS.setInt(1 + p_iFld, p_iVal);
	} // ________________________________

	private void initFields () throws SQLException, ConfigurationException
	{
		PreparedStatement PS = m_oConn.prepareStatement(getSelectStatement());

		ResultSetMetaData MD = m_oConn.execQueryWait(PS, 3).getMetaData();
		m_oaFields = new SqlField[MD.getColumnCount()];
		
		try
		{
			for (int i1 = 0; i1 < m_oaFields.length; i1++)
			{
				int iCol = 1 + i1;
				String sFN = MD.getColumnName(iCol);
				Class oCL = ClassUtil.forName(MD.getColumnClassName(iCol), getClass());
				int iTP = MD.getColumnType(iCol);
				int iSZ = MD.getColumnDisplaySize(iCol);
				m_oaFields[i1] = new SqlField(sFN, oCL, iTP, iSZ, false);
			}
		}
		catch (ClassNotFoundException ex)
		{
			throw new ConfigurationException(ex);
		}
		
		PS.close();
	} // ________________________________
} // ____________________________________________________________________________
