package org.jboss.soa.esb.listeners.config.mappers110;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.PropertyDocument.Property;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.HttpBusDocument.HttpBus;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.HttpListenerDocument.HttpListener;
import org.jboss.soa.esb.listeners.config.xbeanmodel110.HttpProviderDocument.HttpProvider;
import org.jboss.soa.esb.listeners.gateway.HttpGatewayListener;
import org.w3c.dom.Element;

/**
 * Http listener mapper.
 * @author <a href="mailto:ema@redhat.com">Jim Ma</a>
 */
public class HttpListenerMapper {
	 /**
     * Perform the Http listener mapping.
     * @param root The "ConfigTree" configuration root node.
     * @param listener http listener config.
     * @param model The configuration model from which the mapping is being performed.
     * @return The ConfigTree listener configuration node.
     * @throws org.jboss.soa.esb.ConfigurationException Invalid listener configuration.
     */
    public static Element map(Element root, HttpListener listener, XMLBeansModel model) throws ConfigurationException {
        Element listenerNode = YADOMUtil.addElement(root, "listener");
        HttpBus bus;
        HttpProvider provider;
        
        listenerNode.setAttribute("name", listener.getName());

        try {
            bus = (HttpBus) model.getBus(listener.getBusidref());
        } catch (ClassCastException e) {
            throw new ConfigurationException("Invalid busid reference [" + listener.getBusidref() + "] on listener [" + listener.getName() + "].  A <http-listener> must reference a <http-bus>.");
        }
        try {
            provider = (HttpProvider) model.getProvider(bus);
            
        } catch (ClassCastException e) {
            throw new ConfigurationException("Invalid bus config [" + listener.getBusidref() + "].  Should be contained within a <http-provider> instance.  Unexpected exception - this should have caused a validation error!");
        }

        // Map the standard listener attributes - common across all listener types...
        MapperUtil.mapDefaultAttributes(listener, listenerNode, model);
        // Map the <property> elements targeted at the listener - from the listener itself.
        //MapperUtil.mapProperties(provider.getPropertyList(), listenerNode);
        for(Property property : provider.getPropertyList()) {
            Element propertyElement = listenerNode.getOwnerDocument().createElement("property");
            MapperUtil.serialize(property, propertyElement);
            listenerNode.appendChild(propertyElement);           
         }
        
        
        
        
        MapperUtil.mapProperties(bus.getPropertyList(), listenerNode);
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);

        if(listener.getIsGateway()) {
            String host = provider.getHost();
            int port = provider.getPort();
            
            listenerNode.setAttribute("gatewayClass", HttpGatewayListener.class.getName());
			listenerNode.setAttribute(ListenerTagNames.IS_GATEWAY_TAG, Boolean.toString(listener.getIsGateway()));

            if(host != null) {
                listenerNode.setAttribute(HttpGatewayListener.SERVER_HOST_TAG, host);
            }
            listenerNode.setAttribute(HttpGatewayListener.REQUEST_CONTEXT_TAG, bus.getContext());
            listenerNode.setAttribute(HttpGatewayListener.SERVER_PORT_TAG, Integer.toString(port));
        } else {
			throw new ConfigurationException("Invalid <http-listener> config [" + listener.getName() +"]. <http-listener> is currently only supported as a gateway listener.");
        }

        return listenerNode;
    }
}
