package org.jboss.soa.esb.message;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * Messages may contain attachments that do not appear in the main payload body.
 * For example, binary document formats, zip files etc.
 * <br/>Handles both 'named' attachment and a list of 'unnamed' attachments
 * 
 * Eventually attachments will be allowed to have difference encoding properties
 * as they can in the SOAP/Attachments standard.
 * 
 * @author Mark Little
 */

public interface Attachment
{
	/**
	 * Returns the attachment to which this object maps the specified key. 
	 * Returns null if the there's no value mapped for this key.
	 * @param name String - The name of the attachment to get
	 * @return Object - the value mapped to arg0 or &lt;null&gt; if none
	 */
	Object get(String name);
	/**
	 * Associates the specified value with the specified name
	 * If there was already a mapping for this name, the old value is replaced by 
	 * arg1
	 * @param name String - the name for the object to be stored
	 * @param value Object - the object to be associated with the name (arg0)
	 * @return Object - previous value associated with specified name,
	 * or null  if there was none
	 */
	Object put(String name, Object value);
	/**
	 * Removes the mapping for this name if it was present
	 * @param name String - the name of the object to be removed
	 * @return the value previously associated the name, or null if there was none
	 */
	Object remove(String name);
	/**
	 * @return String[] - the list of names of the named Objects
	 */
	String[] getNames();

	/**
     * get the item at the specified position in the list of unnamed objects
     * @param index int - index of element to return
     * @return Object the element at the specified position in the list of unnamed objects
     * @throws IndexOutOfBoundsException - if the index is out of range
     */
	Object itemAt 		(int index) throws IndexOutOfBoundsException;
	/**
	 * Removes the element at the specified position in the list of unnamed objects
	 * Shifts any subsequent elements to the left 
	 * @param index int - index of element to remove
	 * @return Object - the element that was removed from the list
	 * @throws IndexOutOfBoundsException - if the index is out of range
	 */
	Object removeItemAt	(int index) throws IndexOutOfBoundsException;
	/**
	 * Replaces the element at the specified position in the list of unnamed objects 
	 * with the value supplied
	 * @param index int - index of element to be replaced
	 * @param  value Object - the object to replace the one previously stored at that index
	 * @return Object - previous value at that index
	 * @throws IndexOutOfBoundsException - if the index is out of range
	 */
	Object replaceItemAt(int index, Object value) throws IndexOutOfBoundsException;
	/**
	 * Appends the specified element to the end of the list of unnamed objects
	 * <br/>null values are allowed 
	 * @param value Object - the object to be appended
	 */
	void addItem		(Object value);
	/**
	 * Replaces the element at the specified position in the list of unnamed objects
	 * <br/> allows null values
	 * @param index int - index where to insert the value - Shifts any subsequent elements to the right
	 * @param value Object - value to be stored at the specified position
	 * @throws IndexOutOfBoundsException
	 */
	void addItemAt	(int index, Object value) throws IndexOutOfBoundsException;
	/**
	 * getUnnamedCount()
	 * @return the count of unnamed objects
	 */
	int	getUnnamedCount();
	/**
	 * getNamedCount()
	 * @return the count of named objects
	 */
	public int getNamedCount(); 
}
