/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.notification.jms;

import javax.jms.JMSException;
import javax.jms.Message;

/**
 * Sets JMS Fields and Properties from an ESB Message instance
 * 
 * @author <a href="daniel.bevenius@redpill.se">Daniel Bevenius</a>				
 *
 */
public interface JMSPropertiesSetter
{
	
	/**
	 * Key used when setting the JMSExpiration as a 
	 * property on an ESB Message instance.
	 */
	String JMS_EXPIRATION = "javax.jms.message.expiration";
	
	/**
	 * Key used when setting the JMSRedelivered as a 
	 * property on an ESB Message instance.
	 */
	String JMS_REDELIVERED = "javax.jms.message.redelivered";
	
	/**
	 * Key used when setting the JMSReplyTo as a 
	 * property on an ESB Message instance.
	 */
	String JMS_REPLY_TO = "javax.jms.message.replyTo";
	
	/**
     * Sets JMS properties fields on the outgoing JMS Message.
     * </p>
     * 
     * @param jmsMessage		the out-going JMS Message object
     * @param esbMsg			the Message object from the ESB
     * 
     * @throws JMSException
     */
	void setJMSProperties( org.jboss.soa.esb.message.Message fromESBMsg, Message toJMSMessage ) throws JMSException; 	
	
}
