/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.rosetta.pooling.jms;

import org.jboss.internal.soa.esb.rosetta.pooling.MockJndiContextHandler;

import javax.jms.ConnectionFactory;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.ArrayList;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class MockJMSConnectionFactory implements ConnectionFactory {

    private int maxSessionsPerConnection;

    public MockJMSConnectionFactory(int maxSessionsPerConnection) {
        this.maxSessionsPerConnection = maxSessionsPerConnection;
    }

    public Connection createConnection() throws JMSException {
        return createConnectionHandler();
    }

    public Connection createConnection(String s, String s1) throws JMSException {
        return createConnectionHandler();
    }

    private Connection createConnectionHandler() {
        return (Connection) Proxy.newProxyInstance(Connection.class.getClassLoader(),
                new Class[]{Connection.class},
                new MockJMSConnectionHandler(maxSessionsPerConnection));
    }

    private class MockJMSConnectionHandler implements InvocationHandler {

        private int maxSessionsPerConnection;
        private List<Session> sessions = new ArrayList<Session>();

        public MockJMSConnectionHandler(int maxSessionsPerConnection) {
            this.maxSessionsPerConnection = maxSessionsPerConnection;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {

            if(method.getName().equals("createSession")) {
                System.out.println("Creating JMS Session");

                if(maxSessionsPerConnection > 0 && sessions.size() == maxSessionsPerConnection) {
                    throw new JMSException("Unable to create JMS Session on Connection.  Maximum of " + maxSessionsPerConnection + " Sessions/Connection.");
                }

                Session session = (Session) Proxy.newProxyInstance(Session.class.getClassLoader(),
                        new Class[]{Session.class},
                        new MockJMSSessionHandler());

                sessions.add(session);

                return session;
            }

            System.out.println("MockJMSConnectionHandler: Call to " + method.getName());

            return null;
        }
    }

    private class MockJMSSessionHandler implements InvocationHandler {

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {

            if(method.getName().equals("getAcknowledgeMode")) {
                return Session.AUTO_ACKNOWLEDGE;
            }

            System.out.println("MockJMSSessionHandler: Call to " + method.getName());

            return null;
        }
    }
}
