/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.webservice_consumer2.test.SendJMSMessage;

/**
 * CI test for the webservice_consumer2 quickstart.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class WebServiceConsumer2Test extends AbstractQuickstartTestCase {
	private static final String JMS_MESSAGE = "Jimbo";
	private static final String RESULT_STRING = "{processOrderResponse.return.comment=order processed, processOrderResponse.return.id=1, processOrderResponse.return.returnCode=1}";

	public WebServiceConsumer2Test(String name) {
		super(name);
	}

	public void testMessage() throws Exception {
	    clearMessages() ;
	    sendMessage();
	    String[] sinkMessages = waitForMessages(1, 30000);
	    assertTrue("Expected to find string " + RESULT_STRING + " found " + sinkMessages[0],
	    		sinkMessages[0].equals(RESULT_STRING));
	}

	public void sendMessage() throws Exception {
		SendJMSMessage sm = new SendJMSMessage();
		sm.setupConnection();
		sm.sendAMessage(JMS_MESSAGE);
		sm.stop();
	}

	public static Test suite() throws Exception {
		return getDeploySetup(WebServiceConsumer2Test.class, "QuickstartMessageStoreServer.sar, Quickstart_webservice_consumer2.esb");
	}
}
