/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.jruby.Ruby;
import org.jruby.RubyGlobal;
import org.jruby.RubyIO;
import org.jruby.embed.AttributeName;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.io.WriterOutputStream;
import org.jruby.embed.variable.TransientLocalVariable;
import org.jruby.embed.variable.VariableInterceptor;
import org.jruby.util.io.BadDescriptorException;

public class Utils {
    static int getLineNumber(ScriptContext context) {
        Object obj = context.getAttribute(AttributeName.LINENUMBER.toString(), 100);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    static Object getReceiver(ScriptContext context) {
        return context.getAttribute(AttributeName.RECEIVER.toString(), 100);
    }

    static String getFilename(ScriptContext context) {
        Object filename2 = context.getAttribute("javax.script.filename");
        return filename2 != null ? (String)filename2 : "<script>";
    }

    static boolean isTerminationOn(ScriptContext context) {
        Object obj = context.getAttribute(AttributeName.TERMINATION.toString());
        return obj != null && obj instanceof Boolean && (Boolean)obj == true;
    }

    static void preEval(ScriptingContainer container, ScriptContext context) {
        Object value2;
        Object receiver2 = Utils.getReceiverObject(context);
        Bindings bindings = context.getBindings(100);
        Set keys2 = bindings.keySet();
        for (String key2 : keys2) {
            value2 = bindings.get(key2);
            Utils.put(container, receiver2, key2, value2, context);
        }
        try {
            Utils.setWriter(container, context.getWriter());
            Utils.setErrorWriter(container, context.getErrorWriter());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (BadDescriptorException ex) {
            throw new RuntimeException(ex);
        }
        bindings = context.getBindings(200);
        if (bindings == null) {
            return;
        }
        keys2 = bindings.keySet();
        for (String key2 : keys2) {
            if (container.getVarMap().containsKey(key2)) continue;
            value2 = bindings.get(key2);
            Utils.put(container, receiver2, key2, value2, context);
        }
    }

    private static Object getReceiverObject(ScriptContext context) {
        if (context == null) {
            return null;
        }
        return context.getAttribute(AttributeName.RECEIVER.toString(), 100);
    }

    private static void setWriter(ScriptingContainer container, Writer writer) throws IOException, BadDescriptorException {
        Writer old;
        if (writer == null) {
            return;
        }
        Map map = container.getAttributeMap();
        if (map.containsKey((Object)AttributeName.WRITER) && (old = (Writer)map.get((Object)AttributeName.WRITER)) == writer) {
            return;
        }
        map.put(AttributeName.WRITER, writer);
        Ruby runtime2 = container.getProvider().getRuntime();
        RubyIO io2 = Utils.getRubyIO(runtime2, writer);
        runtime2.defineVariable(new RubyGlobal.OutputGlobalVariable(runtime2, "$stdout", io2));
        runtime2.getObject().getConstantMapForWrite().put("STDOUT", io2);
        runtime2.getGlobalVariables().alias("$>", "$stdout");
        runtime2.getGlobalVariables().alias("$defout", "$stdout");
    }

    private static void setErrorWriter(ScriptingContainer container, Writer writer) throws IOException, BadDescriptorException {
        Writer old;
        if (writer == null) {
            return;
        }
        Map map = container.getAttributeMap();
        if (map.containsKey((Object)AttributeName.ERROR_WRITER) && (old = (Writer)map.get((Object)AttributeName.ERROR_WRITER)) == writer) {
            return;
        }
        map.put(AttributeName.ERROR_WRITER, writer);
        Ruby runtime2 = container.getProvider().getRuntime();
        RubyIO io2 = Utils.getRubyIO(runtime2, writer);
        runtime2.defineVariable(new RubyGlobal.OutputGlobalVariable(runtime2, "$stderr", io2));
        runtime2.getObject().getConstantMapForWrite().put("STDERR", io2);
        runtime2.getGlobalVariables().alias("$deferr", "$stderr");
    }

    private static RubyIO getRubyIO(Ruby runtime2, Writer writer) throws IOException, BadDescriptorException {
        PrintStream pstream = new PrintStream(new WriterOutputStream(writer), true);
        RubyIO io2 = new RubyIO(runtime2, pstream, false);
        io2.getOpenFile().getMainStreamSafe().setSync(true);
        io2.getOpenFile().getMainStreamSafe().fflush();
        return io2;
    }

    static void postEval(ScriptingContainer container, ScriptContext context) {
        Bindings globalMap;
        if (context == null) {
            return;
        }
        Object receiver2 = Utils.getReceiverObject(context);
        Bindings engineMap = context.getBindings(100);
        int size2 = engineMap.keySet().size();
        String[] names2 = engineMap.keySet().toArray(new String[size2]);
        for (int i2 = 0; i2 < names2.length; ++i2) {
            if (!Utils.shouldLVarBeDeleted(container, names2[i2])) continue;
            engineMap.remove(names2[i2]);
        }
        Set keys2 = container.getVarMap().keySet();
        if (keys2 != null && keys2.size() > 0) {
            for (String key2 : keys2) {
                Object value2 = container.getVarMap().get(key2);
                engineMap.put(Utils.adjustKey(key2), value2);
            }
        }
        if ((globalMap = context.getBindings(100)) == null) {
            return;
        }
        keys2 = globalMap.keySet();
        if (keys2 != null && keys2.size() > 0) {
            for (String key3 : keys2) {
                if (engineMap.containsKey(key3)) continue;
                Object value3 = container.getVarMap().get(receiver2, key3);
                globalMap.put(key3, value3);
            }
        }
    }

    private static Object put(ScriptingContainer container, Object receiver2, String key2, Object value2, ScriptContext context) {
        Object oldValue = null;
        String adjustedKey = Utils.adjustKey(key2);
        if (Utils.isRubyVariable(container, adjustedKey)) {
            boolean sharing_variables = true;
            Object obj = context.getAttribute(AttributeName.SHARING_VARIABLES.toString(), 100);
            if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
                sharing_variables = false;
            }
            if (sharing_variables || "ARGV".equals(adjustedKey)) {
                oldValue = container.put(receiver2, adjustedKey, value2);
            }
        } else {
            oldValue = adjustedKey.equals(AttributeName.SHARING_VARIABLES.toString()) ? container.setAttribute((Object)AttributeName.SHARING_VARIABLES, value2) : container.setAttribute(adjustedKey, value2);
        }
        return oldValue;
    }

    static boolean isRubyVariable(ScriptingContainer container, String name2) {
        return VariableInterceptor.isKindOfRubyVariable(container.getProvider().getLocalVariableBehavior(), name2);
    }

    private static String adjustKey(String key2) {
        if (key2.equals("javax.script.argv")) {
            return "ARGV";
        }
        if ("ARGV".equals(key2)) {
            return "javax.script.argv";
        }
        return key2;
    }

    private static boolean shouldLVarBeDeleted(ScriptingContainer container, String key2) {
        LocalVariableBehavior behavior = container.getProvider().getLocalVariableBehavior();
        if (behavior != LocalVariableBehavior.TRANSIENT) {
            return false;
        }
        return TransientLocalVariable.isValidName(key2);
    }
}

