/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageData {
    private volatile Map<String, Integer[]> coverage;
    private final EventHook COVERAGE_HOOK = new EventHook(){

        public synchronized void eventHandler(ThreadContext context, String eventName, String file2, int line, String name2, IRubyObject type2) {
            if (CoverageData.this.coverage == null) {
                return;
            }
            Integer[] lines2 = (Integer[])CoverageData.this.coverage.get(file2);
            if (lines2 == null) {
                lines2 = new Integer[line];
                CoverageData.this.coverage.put(file2, lines2);
            } else if (lines2.length <= line) {
                Integer[] newLines = new Integer[line];
                System.arraycopy(lines2, 0, newLines, 0, lines2.length);
                lines2 = newLines;
                CoverageData.this.coverage.put(file2, lines2);
            }
            Integer count2 = lines2[line - 1];
            lines2[line - 1] = count2 == null ? Integer.valueOf(1) : Integer.valueOf(count2 + 1);
        }

        public boolean isInterestedInEvent(RubyEvent event) {
            return event == RubyEvent.LINE;
        }
    };

    public boolean isCoverageEnabled() {
        return this.coverage != null;
    }

    public synchronized void setCoverageEnabled(Ruby runtime2, boolean enabled) {
        if (enabled) {
            this.coverage = new HashMap<String, Integer[]>();
            runtime2.addEventHook(this.COVERAGE_HOOK);
        } else {
            this.coverage = null;
        }
    }

    public synchronized Map<String, Integer[]> resetCoverage(Ruby runtime2) {
        Map<String, Integer[]> coverage2 = this.coverage;
        runtime2.removeEventHook(this.COVERAGE_HOOK);
        this.coverage = null;
        return coverage2;
    }
}

