/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.vfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.spring.vfs.VFSResource;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class VFSResourceLoader
extends DefaultResourceLoader {
    public VFSResourceLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public Resource getResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        if (location.startsWith("classpath:")) {
            return this.doGetResourceForLocation(location.substring("classpath:".length()));
        }
        return super.getResource(location);
    }

    protected Resource getResourceByPath(String path) {
        return this.doGetResourceForLocation(path);
    }

    private final Resource doGetResourceForLocation(String path) {
        URL url = this.getClassLoader().getResource(path);
        if (url != null) {
            return new VFSResource(url);
        }
        return new InexistentResource(path);
    }

    private static class InexistentResource
    extends AbstractResource {
        private final String path;

        private InexistentResource(String path) {
            this.path = path;
        }

        public String getDescription() {
            return null;
        }

        public InputStream getInputStream() throws IOException {
            throw new FileNotFoundException("Resource does not exist for path " + this.path);
        }

        public boolean exists() {
            return false;
        }
    }
}

