/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STOU
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)STOU.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        block31: {
            try {
                DataConnection dataConnection;
                FtpletEnum ftpletRet;
                session.resetState();
                FtpServerContext serverContext = connection.getServerContext();
                Ftplet ftpletContainer = serverContext.getFtpletContainer();
                try {
                    ftpletRet = ftpletContainer.onUploadUniqueStart((FtpSession)session, request, out);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_SKIP) {
                    return;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    serverContext.getConnectionManager().closeConnection(connection);
                    return;
                }
                String dirName = request.getArgument();
                String filePrefix = dirName == null ? "ftp.dat" : dirName + "/ftp.dat";
                FileObject file = null;
                try {
                    file = session.getFileSystemView().getFileObject(filePrefix);
                    if (file != null) {
                        file = this.getUniqueFile(connection, session, file);
                    }
                }
                catch (Exception ex) {
                    this.LOG.debug("Exception getting file object", (Throwable)ex);
                }
                if (file == null) {
                    out.write(FtpReplyUtil.translate(session, 550, "STOU", null));
                    return;
                }
                String fileName = file.getFullName();
                if (!file.hasWritePermission()) {
                    out.write(FtpReplyUtil.translate(session, 550, "STOU.permission", fileName));
                    return;
                }
                out.write(FtpReplyUtil.translate(session, 150, "STOU", null));
                boolean failure = false;
                OutputStream os = null;
                out.write(FtpReplyUtil.translate(session, 250, "STOU", fileName));
                try {
                    dataConnection = session.getDataConnection().openConnection();
                }
                catch (Exception e) {
                    this.LOG.debug("Exception getting the input data stream", (Throwable)e);
                    out.write(FtpReplyUtil.translate(session, 425, "STOU", fileName));
                    session.getDataConnection().closeDataConnection();
                    return;
                }
                try {
                    os = file.createOutputStream(0L);
                    long transSz = dataConnection.transferFromClient(os);
                    String userName = session.getUser().getName();
                    this.LOG.info("File upload : " + userName + " - " + fileName);
                    ServerFtpStatistics ftpStat = (ServerFtpStatistics)serverContext.getFtpStatistics();
                    if (ftpStat != null) {
                        ftpStat.setUpload(connection, file, transSz);
                    }
                }
                catch (SocketException ex) {
                    this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                    failure = true;
                    out.write(FtpReplyUtil.translate(session, 426, "STOU", fileName));
                }
                catch (IOException ex) {
                    this.LOG.debug("IOException during data transfer", (Throwable)ex);
                    failure = true;
                    out.write(FtpReplyUtil.translate(session, 551, "STOU", fileName));
                }
                finally {
                    IoUtils.close(os);
                }
                if (failure) break block31;
                out.write(FtpReplyUtil.translate(session, 226, "STOU", fileName));
                try {
                    ftpletRet = ftpletContainer.onUploadUniqueEnd((FtpSession)session, request, out);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    serverContext.getConnectionManager().closeConnection(connection);
                    return;
                }
            }
            finally {
                session.getDataConnection().closeDataConnection();
            }
        }
    }

    protected FileObject getUniqueFile(Connection connection, FtpSession session, FileObject oldFile) throws FtpException {
        FileObject newFile = oldFile;
        FileSystemView fsView = session.getFileSystemView();
        String fileName = newFile.getFullName();
        while (newFile.doesExist() && (newFile = fsView.getFileObject(fileName + '.' + System.currentTimeMillis())) != null) {
        }
        return newFile;
    }
}

