/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ivy.plugins.repository.BasicResource;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.sftp.SFTPResource;
import org.apache.ivy.plugins.repository.ssh.AbstractSshBasedRepository;
import org.apache.ivy.plugins.repository.ssh.SshCache;
import org.apache.ivy.util.Message;

public class SFTPRepository
extends AbstractSshBasedRepository {
    public Resource getResource(String source) {
        return new SFTPResource(this, source);
    }

    public Resource resolveResource(String path) {
        try {
            ChannelSftp c = this.getSftpChannel(path);
            Vector r = c.ls(path);
            if (r != null) {
                Iterator iter = r.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof ChannelSftp.LsEntry)) continue;
                    ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)obj;
                    SftpATTRS attrs = entry.getAttrs();
                    return new BasicResource(path, true, attrs.getSize(), attrs.getMTime() * 1000, false);
                }
            }
        }
        catch (Exception e) {
            Message.debug("reolving resource error: " + e.getMessage());
        }
        return new BasicResource(path, false, 0L, 0L, false);
    }

    public InputStream openStream(SFTPResource resource) throws IOException {
        ChannelSftp c = this.getSftpChannel(resource.getName());
        try {
            return c.get(resource.getName());
        }
        catch (SftpException e) {
            e.printStackTrace();
            IOException ex = new IOException("impossible to open stream for " + resource + " on " + this.getHost() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
            ex.initCause(e);
            throw ex;
        }
    }

    public void get(String source, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source), 5);
        ChannelSftp c = this.getSftpChannel(source);
        try {
            c.get(source, destination.getAbsolutePath(), (SftpProgressMonitor)new MyProgressMonitor());
        }
        catch (SftpException e) {
            e.printStackTrace();
            IOException ex = new IOException("impossible to get " + source + " on " + this.getHost() + (e.getMessage() != null ? ": " + e.getMessage() : ""));
            ex.initCause(e);
            throw ex;
        }
    }

    public void put(File source, String destination, boolean overwrite) throws IOException {
        this.fireTransferInitiated(this.getResource(destination), 6);
        ChannelSftp c = this.getSftpChannel(destination);
        try {
            if (!overwrite && this.checkExistence(destination, c)) {
                throw new IOException("destination file exists and overwrite == true");
            }
            if (destination.indexOf(47) != -1) {
                this.mkdirs(destination.substring(0, destination.lastIndexOf(47)), c);
            }
            c.put(source.getAbsolutePath(), destination, (SftpProgressMonitor)new MyProgressMonitor());
        }
        catch (SftpException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    private void mkdirs(String directory, ChannelSftp c) throws IOException, SftpException {
        try {
            SftpATTRS att = c.stat(directory);
            if (att != null && att.isDir()) {
                return;
            }
        }
        catch (SftpException ex) {
            if (directory.indexOf(47) != -1) {
                this.mkdirs(directory.substring(0, directory.lastIndexOf(47)), c);
            }
            c.mkdir(directory);
        }
    }

    public List list(String parent) throws IOException {
        try {
            ChannelSftp c = this.getSftpChannel(parent);
            Vector r = c.ls(parent);
            if (r != null) {
                if (!parent.endsWith("/")) {
                    parent = parent + "/";
                }
                ArrayList<String> result = new ArrayList<String>();
                Iterator iter = r.iterator();
                while (iter.hasNext()) {
                    ChannelSftp.LsEntry entry;
                    Object obj = iter.next();
                    if (!(obj instanceof ChannelSftp.LsEntry) || ".".equals((entry = (ChannelSftp.LsEntry)obj).getFilename()) || "..".equals(entry.getFilename())) continue;
                    result.add(parent + entry.getFilename());
                }
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean checkExistence(String file, ChannelSftp channel) throws IOException, SftpException {
        try {
            return channel.stat(file) != null;
        }
        catch (SftpException ex) {
            return false;
        }
    }

    private ChannelSftp getSftpChannel(String pathOrUri) throws IOException {
        Session session = this.getSession(pathOrUri);
        String host = session.getHost();
        ChannelSftp channel = SshCache.getInstance().getChannelSftp(session);
        if (channel == null) {
            try {
                channel = (ChannelSftp)session.openChannel("sftp");
                channel.connect();
                Message.verbose(":: SFTP :: connected to " + host + "!");
                SshCache.getInstance().attachChannelSftp(session, channel);
            }
            catch (JSchException e) {
                IOException ex = new IOException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }
        return channel;
    }

    protected String getRepositoryScheme() {
        return "sftp";
    }

    private final class MyProgressMonitor
    implements SftpProgressMonitor {
        private long totalLength;

        private MyProgressMonitor() {
        }

        public void init(int op, String src, String dest, long max) {
            this.totalLength = max;
            SFTPRepository.this.fireTransferStarted(max);
        }

        public void end() {
            SFTPRepository.this.fireTransferCompleted(this.totalLength);
        }

        public boolean count(long count) {
            SFTPRepository.this.fireTransferProgress(count);
            return true;
        }
    }
}

