/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.model;

import java.io.Serializable;
import net.sourceforge.wife.swift.model.SwiftValueBlock;
import org.apache.commons.lang.Validate;

public class SwiftBlock1
extends SwiftValueBlock
implements Serializable {
    public static final transient String APPLICATION_ID_FIN = "F";
    public static final transient String APPLICATION_ID_GPA = "A";
    public static final transient String APPLICATION_ID_LOGINS = "L";
    private String applicationId;
    private String serviceId;
    private String logicalTerminal;
    private String sessionNumber;
    private String sequenceNumber;

    public SwiftBlock1(String applicationId, String serviceId, String logicalTerminal, String sessionNumber, String sequenceNumber) {
        this.applicationId = applicationId;
        this.serviceId = serviceId;
        this.logicalTerminal = logicalTerminal;
        this.sessionNumber = sessionNumber;
        this.sequenceNumber = sequenceNumber;
    }

    public SwiftBlock1() {
    }

    public SwiftBlock1(String value) {
        this.setValue(value);
    }

    protected void setBlockNumber(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((blockNumber == 1 ? 1 : 0) != 0, (String)"blockNumber must be 1");
    }

    protected void setBlockName(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((blockName.compareTo("1") == 0 ? 1 : 0) != 0, (String)"blockName must be string '1'");
    }

    public Integer getNumber() {
        return new Integer(1);
    }

    public String getName() {
        return "1";
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setLogicalTerminal(String logicalTerminal) {
        this.logicalTerminal = logicalTerminal;
    }

    public String getLogicalTerminal() {
        return this.logicalTerminal;
    }

    public void setSessionNumber(String sessionNumber) {
        this.sessionNumber = sessionNumber;
    }

    public String getSessionNumber() {
        return this.sessionNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean isEmpty() {
        return this.applicationId == null && this.serviceId == null && this.logicalTerminal == null && this.sessionNumber == null && this.sequenceNumber == null;
    }

    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuffer v = new StringBuffer();
        if (this.applicationId != null) {
            v.append(this.applicationId);
        }
        if (this.serviceId != null) {
            v.append(this.serviceId);
        }
        if (this.logicalTerminal != null) {
            v.append(this.logicalTerminal);
        }
        if (this.sessionNumber != null) {
            v.append(this.sessionNumber);
        }
        if (this.sequenceNumber != null) {
            v.append(this.sequenceNumber);
        }
        return v.toString();
    }

    public String getBlockValue() {
        return this.getValue();
    }

    public void setValue(String value) {
        int slen = value.length();
        Validate.notNull((Object)value, (String)"value must not be null");
        Validate.isTrue((slen == 25 || slen == 27 || slen == 15 || slen == 17 ? 1 : 0) != 0, (String)("expected a 25 (or 27) or 15 (or 17) chars string and obtained a " + value.length() + " chars string: " + value));
        int offset = 0;
        if (slen == 27 || slen == 17) {
            Validate.isTrue((boolean)value.startsWith("1:"), (String)("expected '1:' at the beginning of value and found '" + value.substring(0, 1) + "'"));
            offset = 2;
        }
        int len = 1;
        this.setApplicationId(this.getValuePart(value, offset, len));
        offset += len;
        len = 2;
        this.setServiceId(this.getValuePart(value, offset, len));
        offset += len;
        len = 12;
        this.setLogicalTerminal(this.getValuePart(value, offset, len));
        offset += len;
        len = 4;
        this.setSessionNumber(this.getValuePart(value, offset, len));
        offset += len;
        len = 6;
        this.setSequenceNumber(this.getValuePart(value, offset, len));
        offset += len;
    }

    public void setBlockValue(String value) {
        this.setValue(value);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.applicationId == null ? 0 : this.applicationId.hashCode());
        result = 31 * result + (this.logicalTerminal == null ? 0 : this.logicalTerminal.hashCode());
        result = 31 * result + (this.sequenceNumber == null ? 0 : this.sequenceNumber.hashCode());
        result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        result = 31 * result + (this.sessionNumber == null ? 0 : this.sessionNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftBlock1 other = (SwiftBlock1)obj;
        if (this.applicationId == null ? other.applicationId != null : !this.applicationId.equals(other.applicationId)) {
            return false;
        }
        if (this.logicalTerminal == null ? other.logicalTerminal != null : !this.logicalTerminal.equals(other.logicalTerminal)) {
            return false;
        }
        if (this.sequenceNumber == null ? other.sequenceNumber != null : !this.sequenceNumber.equals(other.sequenceNumber)) {
            return false;
        }
        if (this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId)) {
            return false;
        }
        return !(this.sessionNumber == null ? other.sessionNumber != null : !this.sessionNumber.equals(other.sessionNumber));
    }
}

